/*
 * Decompiled with CFR 0.152.
 */
package jas.hep;

import hep.analysis.Histogram;
import hep.analysis.Partition;
import hep.analysis.partition.Abstract1DPartition;
import hep.analysis.partition.Abstract2DPartition;
import hep.analysis.partition.PartitionNotification;
import hep.analysis.partition.ScatterDataSource;
import jas.hep.HistogramUpdateAdapter;
import jas.hep.Partition1DAdapter;
import jas.hep.Partition2DAdapter;
import jas.hep.ScatterAdapter;
import jas.hep.StatisticsAdapter;
import jas.hist.DataSource;
import jas.hist.HasStatistics;
import jas.hist.Statistics;
import jas.hist.util.ObserverAdapter;
import java.util.Observable;

public abstract class PartitionAdapter
extends ObserverAdapter
implements DataSource,
HasStatistics {
    private String m_title;
    private Partition m_partition;

    public static DataSource create(Histogram histogram) {
        return PartitionAdapter.create(histogram.getPartition(), histogram.getName());
    }

    public static DataSource create(Partition partition, String string) {
        PartitionAdapter partitionAdapter;
        if (partition instanceof Abstract1DPartition) {
            partitionAdapter = new Partition1DAdapter((Abstract1DPartition)partition);
        } else if (partition instanceof Abstract2DPartition) {
            partitionAdapter = partition instanceof ScatterDataSource ? new ScatterAdapter((Abstract2DPartition)partition) : new Partition2DAdapter((Abstract2DPartition)partition);
        } else {
            throw new IllegalArgumentException("Argument is an unknown subtype of Partition");
        }
        partitionAdapter.m_title = string;
        ((PartitionAdapter)partitionAdapter).m_partition = partition;
        return partitionAdapter;
    }

    PartitionAdapter(Observable observable) {
        super(observable);
    }

    public void notifyObservers(Object object) {
        if (object instanceof PartitionNotification) {
            object = HistogramUpdateAdapter.create((PartitionNotification)object);
        }
        super.notifyObservers(object);
    }

    public Statistics getStatistics() {
        return new StatisticsAdapter(this.m_partition.getStatistics());
    }

    public String getTitle() {
        return this.m_title;
    }

    public String toString() {
        hep.analysis.partition.Statistics statistics = this.m_partition.getStatistics();
        if (statistics != null) {
            return this.getTitle() + ": " + statistics;
        }
        return this.getTitle() + ": no statistics available";
    }
}

