/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.normalization.AreaNormalizer;
import jas.hist.normalization.BinNormalizer;
import jas.hist.normalization.EntriesNormalizer;
import jas.hist.normalization.MaxBinNormalizer;
import jas.hist.normalization.Normalizer;
import jas.hist.normalization.RelativeNormalizer;
import jas.hist.normalization.SimpleNormalizer;
import jas.hist.normalization.StatisticsNormalizer;
import jas.util.xml.XMLNodeTraverser;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class NormalizationTraverser
extends XMLNodeTraverser {
    private String method;
    private String param;
    private String relativeTo;
    private double multiplier;

    NormalizationTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("method")) {
            this.method = string2;
        } else if (string.equals("param")) {
            this.param = string2;
        } else if (string.equals("multiplier")) {
            this.multiplier = this.toDouble(string2);
        } else if (string.equals("relativeTo")) {
            this.relativeTo = string2;
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }

    Normalizer getNormalizer(DataSource dataSource, Hashtable hashtable) throws XMLNodeTraverser.BadXMLException {
        SimpleNormalizer simpleNormalizer = this.createNormalizer(this.method, this.param, dataSource);
        if (this.relativeTo != null) {
            DataSource dataSource2 = (DataSource)hashtable.get(this.relativeTo);
            if (dataSource2 == null) {
                throw new XMLNodeTraverser.BadXMLException("Could not find data ref " + this.relativeTo);
            }
            SimpleNormalizer simpleNormalizer2 = this.createNormalizer(this.method, this.param, dataSource2);
            return new RelativeNormalizer(simpleNormalizer, simpleNormalizer2);
        }
        simpleNormalizer.setFactor(1.0 / this.multiplier);
        return simpleNormalizer;
    }

    private SimpleNormalizer createNormalizer(String string, String string2, DataSource dataSource) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("CONSTANT")) {
            return new SimpleNormalizer(1.0);
        }
        if (string.equals("MAXBIN")) {
            return new MaxBinNormalizer(dataSource);
        }
        if (string.equals("AREA")) {
            return new AreaNormalizer(dataSource);
        }
        if (string.equals("ENTRIES")) {
            return new EntriesNormalizer(dataSource);
        }
        if (string.equals("BIN")) {
            return new BinNormalizer(dataSource, this.toInt(string2));
        }
        if (string.equals("STATISTICS")) {
            return new StatisticsNormalizer(dataSource, string2);
        }
        throw new XMLNodeTraverser.BadXMLException("Unrecognized normalization method " + string);
    }
}

