/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.Statistics;
import java.util.Observable;
import java.util.Random;

public class TestScatterPlotSource
extends Observable
implements ScatterPlotSource {
    private int delay = 0;
    protected double[] x;
    protected double[] y;
    private Random random = new Random();

    public TestScatterPlotSource(int n) {
        this();
        this.delay = n;
    }

    public TestScatterPlotSource() {
        this.x = new double[10000];
        this.y = new double[10000];
        int n = 0;
        while (n < 10000) {
            this.x[n] = this.random.nextGaussian();
            this.y[n] = this.random.nextGaussian() * 2.0;
            ++n;
        }
    }

    public ScatterEnumeration startEnumeration() {
        return new TestEnumeration();
    }

    public ScatterEnumeration startEnumeration(double d, double d2, double d3, double d4) {
        return new TestEnumeration(d, d2, d3, d4);
    }

    public String getTitle() {
        return "Scatter Plot";
    }

    public double getXMin() {
        return -3.0;
    }

    public double getXMax() {
        return 3.0;
    }

    public double getYMin() {
        return -6.0;
    }

    public double getYMax() {
        return 6.0;
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    public Statistics getStatistics() {
        return null;
    }

    public void clearChanges() {
    }

    private class TestEnumeration
    implements ScatterEnumeration {
        private int n;
        private boolean limits;
        private double ymin;
        private double ymax;
        private double xmin;
        private double xmax;

        TestEnumeration() {
            this.n = 0;
            this.limits = false;
        }

        TestEnumeration(double d, double d2, double d3, double d4) {
            this.n = 0;
            this.xmin = d;
            this.xmax = d2;
            this.ymin = d3;
            this.ymax = d4;
            this.limits = true;
        }

        public boolean getNextPoint(double[] dArray) {
            if (TestScatterPlotSource.this.delay > 0) {
                try {
                    Thread.sleep(TestScatterPlotSource.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.limits) {
                while (this.n < 10000) {
                    if (TestScatterPlotSource.this.x[this.n] >= this.xmin && TestScatterPlotSource.this.x[this.n] < this.xmax && TestScatterPlotSource.this.y[this.n] >= this.ymin && TestScatterPlotSource.this.y[this.n] < this.ymax) {
                        dArray[0] = TestScatterPlotSource.this.x[this.n];
                        dArray[1] = TestScatterPlotSource.this.y[this.n];
                        ++this.n;
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }
            if (this.n == 10000) {
                return false;
            }
            dArray[0] = TestScatterPlotSource.this.x[this.n];
            dArray[1] = TestScatterPlotSource.this.y[this.n];
            ++this.n;
            return true;
        }

        public void resetEndPoint() {
        }

        public void restart() {
            this.n = 0;
        }
    }
}

