/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class CheckboxFieldBinding
extends FieldBinding
implements ItemListener {
    private boolean m_oldVal = false;
    private Checkbox m_field;

    CheckboxFieldBinding(Checkbox checkbox) {
        this.m_field = checkbox;
        checkbox.addItemListener(this);
    }

    void set(Object object) throws UnsupportedType {
        if (!(object instanceof Boolean)) {
            throw new UnsupportedType(this.m_field, object.getClass());
        }
        boolean bl = (Boolean)object;
        if (this.m_oldVal != bl) {
            this.m_field.setState(bl);
            this.m_oldVal = bl;
        }
    }

    Object get(Class clazz) throws UnsupportedType {
        if (clazz != Boolean.TYPE) {
            throw new UnsupportedType(this.m_field, clazz);
        }
        boolean bl = this.m_field.getState();
        return new Boolean(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.m_field.getState();
        if (bl != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getState();
    }
}

