/*
 * Decompiled with CFR 0.152.
 */
package jas.util.rmi;

import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDeliveryEvent;
import jas.util.rmi.RMIEventDeliveryListener;
import jas.util.rmi.RemoteEventReceiver;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class RMIEventDelivery
extends UnicastRemoteObject
implements RemoteEventReceiver {
    private static final RMIEventDeliveryEvent start = new RMIEventDeliveryEvent(true);
    private static final RMIEventDeliveryEvent stop = new RMIEventDeliveryEvent(false);
    private static final boolean debug = System.getProperty("debugEventDelivery") != null;
    private boolean swing;
    private Vector edl = new Vector();
    private Vector dest = new Vector();

    public RMIEventDelivery(boolean bl) throws RemoteException {
        this.swing = bl;
    }

    public RMIDestination getRMIDestination() {
        RMIDestination rMIDestination = new RMIDestination(this.dest.size());
        this.dest.addElement(rMIDestination);
        return rMIDestination;
    }

    public void addRMIEventDeliveryListener(RMIEventDeliveryListener rMIEventDeliveryListener) {
        this.edl.addElement(rMIEventDeliveryListener);
    }

    public void removeRMIEventDeliveryListener(RMIEventDeliveryListener rMIEventDeliveryListener) {
        this.edl.removeElement(rMIEventDeliveryListener);
    }

    private void fireEventDelivery(RMIEventDeliveryEvent rMIEventDeliveryEvent) {
        Enumeration enumeration = this.edl.elements();
        while (enumeration.hasMoreElements()) {
            RMIEventDeliveryListener rMIEventDeliveryListener = (RMIEventDeliveryListener)enumeration.nextElement();
            rMIEventDeliveryListener.eventDelivery(rMIEventDeliveryEvent);
        }
    }

    public void remoteUpdate(Serializable[] serializableArray) {
        if (this.swing) {
            SwingUtilities.invokeLater(new EventDispatcher(serializableArray));
        } else {
            this.deliver(serializableArray);
        }
    }

    private void deliver(Serializable[] serializableArray) {
        if (debug) {
            System.out.println("Starting delivery of " + serializableArray.length + " remote events");
        }
        RMIDestination rMIDestination = null;
        this.fireEventDelivery(start);
        int n = 0;
        while (n < serializableArray.length) {
            Serializable serializable = serializableArray[n];
            if (debug) {
                System.out.println("event=" + serializable);
            }
            if (serializable instanceof RMIDestination) {
                rMIDestination = (RMIDestination)this.dest.elementAt(((RMIDestination)serializable).getID());
            } else {
                rMIDestination.notifyObservers(serializable);
            }
            ++n;
        }
        this.fireEventDelivery(stop);
        if (debug) {
            System.out.println("Delivery complete");
        }
    }

    private class EventDispatcher
    implements Runnable {
        private Serializable[] arg;

        EventDispatcher(Serializable[] serializableArray) {
            this.arg = serializableArray;
        }

        public void run() {
            RMIEventDelivery.this.deliver(this.arg);
        }
    }
}

