/*
 * Decompiled with CFR 0.152.
 */
package jas.util.tree;

import jas.util.tree.OrderedNode;
import jas.util.tree.SimpleNode;
import jas.util.tree.SimpleNodeListener;
import jas.util.tree.TreeItem;
import java.io.File;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SimpleTreeModel
implements TreeModel {
    private EventListenerList listenerList = new EventListenerList();
    private SimpleNode m_root;
    private SimpleNodeListener m_nodeListener;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public SimpleTreeModel(SimpleNode simpleNode) {
        this.m_root = simpleNode;
    }

    public Object getRoot() {
        return this.m_root;
    }

    public int getChildCount(Object object) {
        SimpleNode simpleNode = (SimpleNode)object;
        return simpleNode.getChildCount();
    }

    public Object getChild(Object object, int n) {
        SimpleNode simpleNode = (SimpleNode)object;
        return simpleNode.getChild(n);
    }

    public int getIndexOfChild(Object object, Object object2) {
        SimpleNode simpleNode = (SimpleNode)object;
        return simpleNode.getIndexOfChild((SimpleNode)object2);
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = SimpleTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        if (this.m_nodeListener == null) {
            this.m_nodeListener = new SimpleListener();
            this.m_root.addNodeListener(this.m_nodeListener);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = SimpleTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        if (this.listenerList.getListenerCount() == 0) {
            this.m_root.removeNodeListener(this.m_nodeListener);
            this.m_nodeListener = null;
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeModelListener == null ? SimpleTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                ((TreeModelListener)objectArray[n + 1]).treeNodesInserted(treeModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeModelListener == null ? SimpleTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                ((TreeModelListener)objectArray[n + 1]).treeNodesRemoved(treeModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeModelListener == null ? SimpleTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                ((TreeModelListener)objectArray[n + 1]).treeStructureChanged(treeModelEvent);
            }
            n -= 2;
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperties().getProperty("user.home"));
        OrderedNode orderedNode = new OrderedNode();
        orderedNode.setOrder(new FolderComparator());
        OrderedNode orderedNode2 = new OrderedNode(orderedNode, file.getName(), null, 4, file);
        SimpleTreeModel.listFiles(orderedNode2, file);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(new JScrollPane(new JTree(new SimpleTreeModel(orderedNode))));
        jFrame.setSize(400, 400);
        jFrame.show();
    }

    private static void listFiles(SimpleNode simpleNode, File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            OrderedNode orderedNode = new OrderedNode(simpleNode, stringArray[n], null, file2.isDirectory() ? 4 : 0, file);
            if (file2.isDirectory()) {
                SimpleTreeModel.listFiles(orderedNode, file2);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FolderComparator
    implements Comparator {
        private FolderComparator() {
        }

        public int compare(Object object, Object object2) {
            boolean bl;
            SimpleNode simpleNode = (SimpleNode)object;
            SimpleNode simpleNode2 = (SimpleNode)object2;
            boolean bl2 = (simpleNode.getFlags() & 4) != 0;
            boolean bl3 = bl = (simpleNode2.getFlags() & 4) != 0;
            if (bl2 && !bl) {
                return -1;
            }
            if (!bl2 && bl) {
                return 1;
            }
            return simpleNode.getName().compareTo(simpleNode2.getName());
        }
    }

    private class SimpleListener
    implements SimpleNodeListener {
        private SimpleListener() {
        }

        public void treeChanged(TreeItem treeItem) {
            if ((treeItem.flags & 8) != 0) {
                this.structureChanged(treeItem);
            } else {
                this.nodesChanged(treeItem);
            }
        }

        private void nodesChanged(TreeItem treeItem) {
            SimpleNode simpleNode;
            Object[] objectArray = new SimpleNode[treeItem.path.length];
            SimpleNode simpleNode2 = simpleNode = SimpleTreeModel.this.m_root;
            int n = 0;
            while (true) {
                objectArray[n] = simpleNode;
                simpleNode2 = simpleNode.findChild(treeItem.path[n++]);
                if (n == objectArray.length) break;
                simpleNode = simpleNode2;
            }
            Object[] objectArray2 = new Object[]{simpleNode2};
            int[] nArray = new int[]{simpleNode.getIndexOfChild(simpleNode2)};
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(objectArray), nArray, objectArray2);
            if ((treeItem.flags & 2) != 0) {
                SimpleTreeModel.this.fireTreeNodesRemoved(treeModelEvent);
            } else {
                SimpleTreeModel.this.fireTreeNodesInserted(treeModelEvent);
            }
        }

        public void structureChanged(TreeItem treeItem) {
            Object[] objectArray = new SimpleNode[treeItem.path.length + 1];
            SimpleNode simpleNode = SimpleTreeModel.this.m_root;
            int n = 0;
            while (true) {
                objectArray[n] = simpleNode;
                if (n >= treeItem.path.length) break;
                simpleNode = simpleNode.findChild(treeItem.path[n]);
                ++n;
            }
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(objectArray));
            SimpleTreeModel.this.fireTreeStructureChanged(treeModelEvent);
        }
    }
}

