/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Graph.MarkerVertex;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;

public class Markers {
    protected int last = 0;
    protected int max = 10;
    protected Vector[] vert = new Vector[this.max];

    public Markers() {
    }

    public Markers(URL uRL) throws IOException {
        this();
        this.LoadMarkers(uRL);
    }

    public void AddMarker(int n, int n2, boolean[] blArray, int[] nArray, int[] nArray2) {
        if (n < 1 || n > this.max) {
            return;
        }
        if (n2 <= 0) {
            return;
        }
        this.last = --n;
        this.vert[n] = new Vector();
        for (int i = 0; i < n2; ++i) {
            MarkerVertex markerVertex = new MarkerVertex();
            markerVertex.draw = blArray[i];
            markerVertex.x = nArray[i];
            markerVertex.y = nArray2[i];
            this.vert[n].addElement(markerVertex);
        }
    }

    public void AddMarker(int n, boolean[] blArray, int[] nArray, int[] nArray2) {
        this.AddMarker(this.last + 1, n, blArray, nArray, nArray2);
    }

    public void DeleteMarker(int n) {
        if (n < 1 || n > this.max) {
            return;
        }
        this.vert[n - 1] = null;
    }

    public void ClearMarkers() {
        if (this.last == 0) {
            return;
        }
        for (int i = 0; i < this.max; ++i) {
            this.vert[i] = null;
        }
        this.last = 0;
    }

    public void LoadMarkers(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        block4: while (true) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break block4;
                }
                case 10: {
                    continue block4;
                }
                case -3: {
                    MarkerVertex markerVertex;
                    if ("start".equals(streamTokenizer.sval)) {
                        this.vert[this.last] = new Vector();
                        continue block4;
                    }
                    if ("end".equals(streamTokenizer.sval)) {
                        ++this.last;
                        continue block4;
                    }
                    if ("m".equals(streamTokenizer.sval)) {
                        markerVertex = new MarkerVertex();
                        markerVertex.draw = false;
                        if (streamTokenizer.nextToken() != -2) continue block4;
                        markerVertex.x = (int)streamTokenizer.nval;
                        if (streamTokenizer.nextToken() != -2) continue block4;
                        markerVertex.y = (int)streamTokenizer.nval;
                        this.vert[this.last].addElement(markerVertex);
                        continue block4;
                    }
                    if (!"l".equals(streamTokenizer.sval)) continue block4;
                    markerVertex = new MarkerVertex();
                    markerVertex.draw = true;
                    if (streamTokenizer.nextToken() != -2) continue block4;
                    markerVertex.x = (int)streamTokenizer.nval;
                    if (streamTokenizer.nextToken() != -2) continue block4;
                    markerVertex.y = (int)streamTokenizer.nval;
                    this.vert[this.last].addElement(markerVertex);
                    continue block4;
                }
            }
            break;
        }
        inputStream.close();
    }

    public void draw(Graphics graphics, int n, double d, int n2, int n3) {
        int n4 = n2;
        int n5 = n2;
        int n6 = n3;
        int n7 = n3;
        if (n < 1 || n > this.max) {
            return;
        }
        if (d <= 0.0) {
            return;
        }
        Vector vector = this.vert[n - 1];
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            MarkerVertex markerVertex = (MarkerVertex)vector.elementAt(i);
            if (markerVertex.draw) {
                n5 = n2 + (int)((double)markerVertex.x * d);
                n7 = n3 + (int)((double)markerVertex.y * d);
                graphics.drawLine(n4, n6, n5, n7);
                n4 = n5;
                n6 = n7;
                continue;
            }
            n4 = n2 + (int)((double)markerVertex.x * d);
            n6 = n3 + (int)((double)markerVertex.y * d);
        }
    }
}

