/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Gui.Param.FreqDlg;
import Gui.Param.IndiFreqDlg;
import Gui.Param.LambdDlg;
import Obj.NSimObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FrequencyPanel
extends JPanel
implements ActionListener {
    private JRadioButton corrfreqBox;
    private JRadioButton indifreqBox;
    private JRadioButton lambdBox;
    private ButtonGroup bp;
    private JButton corrfreqButton;
    private JButton indifreqButton;
    private JButton lambdButton;
    private JButton defaultButton;
    private FreqDlg freqDlg;
    private LambdDlg lambdDlg;
    private IndiFreqDlg indiDlg;
    private boolean corrfreq = true;
    private boolean indifreq = false;
    private boolean inferlambd = false;
    private NSimObj sim;

    public FrequencyPanel(NSimObj nSimObj) {
        this.sim = nSimObj;
        this.bp = new ButtonGroup();
        this.corrfreqBox = new JRadioButton("Allele Frequencies Correlated");
        this.bp.add(this.corrfreqBox);
        this.corrfreqBox.setActionCommand("corrfreqbox");
        this.corrfreqBox.addActionListener(this);
        this.indifreqBox = new JRadioButton("Allele Frequencies Independent");
        this.bp.add(this.indifreqBox);
        this.indifreqBox.setActionCommand("indifreqbox");
        this.indifreqBox.addActionListener(this);
        this.lambdBox = new JRadioButton("Infer Lambda                  ");
        this.bp.add(this.lambdBox);
        this.lambdBox.setActionCommand("lambdbox");
        this.lambdBox.addActionListener(this);
        this.corrfreqButton = new JButton("Advanced ...");
        this.corrfreqButton.setActionCommand("corrfreqbutton");
        this.corrfreqButton.addActionListener(this);
        this.indifreqButton = new JButton("Advanced ...");
        this.indifreqButton.setActionCommand("indifreqbutton");
        this.indifreqButton.addActionListener(this);
        this.lambdButton = new JButton("Advanced ...");
        this.lambdButton.setActionCommand("lambdbutton");
        this.lambdButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.corrfreqButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.indifreqButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.lambdButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 1));
        jPanel4.add(this.corrfreqBox);
        jPanel4.add(this.indifreqBox);
        jPanel4.add(this.lambdBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 1));
        jPanel5.add(jPanel);
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        JPanel jPanel6 = new JPanel();
        JLabel jLabel = new JLabel("Select ONE from the following:");
        jPanel6.add((Component)jLabel, "Center");
        jPanel6.setPreferredSize(new Dimension(500, 30));
        JPanel jPanel7 = new JPanel();
        this.defaultButton = new JButton("Default Setting");
        this.defaultButton.setActionCommand("default");
        this.defaultButton.addActionListener(this);
        jPanel7.add(this.defaultButton);
        jPanel7.setPreferredSize(new Dimension(500, 30));
        JPanel jPanel8 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel8.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel8.add(jPanel6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(40, 50, 10, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel8.add(jPanel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(40, 0, 10, 50);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel8.add(jPanel5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(30, 175, 10, 0);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel8.add(jPanel7);
        jPanel8.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel8, "Center");
        if (!nSimObj.isNew()) {
            if (nSimObj.FREQSCORR) {
                this.corrfreq = true;
                this.indifreq = false;
                this.inferlambd = false;
                this.freqDlg = new FreqDlg(this, nSimObj, false);
            } else if (nSimObj.INFERLAMBDA) {
                this.corrfreq = false;
                this.indifreq = false;
                this.inferlambd = true;
                this.lambdDlg = new LambdDlg(this, nSimObj, false);
            } else {
                this.corrfreq = false;
                this.indifreq = true;
                this.inferlambd = false;
                this.indiDlg = new IndiFreqDlg(this, nSimObj, false);
            }
        }
        this.updatePanelUI();
    }

    private void updatePanelUI() {
        this.corrfreqBox.setSelected(this.corrfreq);
        this.corrfreqButton.setEnabled(this.corrfreq);
        this.indifreqBox.setSelected(this.indifreq);
        this.indifreqButton.setEnabled(this.indifreq);
        this.lambdBox.setSelected(this.inferlambd);
        this.lambdButton.setEnabled(this.inferlambd);
    }

    public void updateData() {
        if (this.corrfreq) {
            this.sim.FREQSCORR = true;
            this.sim.INFERLAMBDA = false;
            if (this.freqDlg == null) {
                this.sim.ONEFST = false;
                this.sim.FPRIORMEAN = 0.01f;
                this.sim.FPRIORSD = 0.05f;
                this.sim.FQSETLAMBDA = true;
                this.sim.LAMBDA = 1.0f;
                this.sim.FQINFERLAMBDA = false;
            } else {
                this.freqDlg.updateData();
            }
            return;
        }
        if (this.indifreq) {
            this.sim.FREQSCORR = false;
            this.sim.INFERLAMBDA = false;
            if (this.indiDlg == null) {
                this.sim.INDIFQSETLAMBDA = true;
                this.sim.LAMBDA = 1.0f;
                this.sim.INDIFQINFERLAMBDA = false;
            } else {
                this.indiDlg.updateData();
            }
            return;
        }
        if (this.inferlambd) {
            this.sim.FREQSCORR = false;
            this.sim.INFERLAMBDA = true;
            if (this.lambdDlg == null) {
                this.sim.LAMBDA = 1.0f;
                this.sim.POPSPECIFICLAMBDA = false;
            } else {
                this.lambdDlg.updateData();
            }
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("corrfreqbox")) {
            this.corrfreq = true;
            this.indifreq = false;
            this.inferlambd = false;
            this.lambdDlg = null;
            this.updatePanelUI();
            return;
        }
        if (string.equals("indifreqbox")) {
            this.corrfreq = false;
            this.indifreq = true;
            this.inferlambd = false;
            this.lambdDlg = null;
            this.freqDlg = null;
            this.updatePanelUI();
            return;
        }
        if (string.equals("lambdbox")) {
            this.corrfreq = false;
            this.indifreq = false;
            this.inferlambd = true;
            this.freqDlg = null;
            this.updatePanelUI();
            return;
        }
        if (string.equals("lambdbutton")) {
            if (this.lambdDlg == null) {
                this.lambdDlg = new LambdDlg(this, this.sim, true);
            }
            this.lambdDlg.showDialog();
            return;
        }
        if (string.equals("corrfreqbutton")) {
            if (this.freqDlg == null) {
                this.freqDlg = new FreqDlg(this, this.sim, true);
            }
            this.freqDlg.showDialog();
            return;
        }
        if (string.equals("indifreqbutton")) {
            if (this.indiDlg == null) {
                this.indiDlg = new IndiFreqDlg(this, this.sim, true);
            }
            this.indiDlg.showDialog();
            return;
        }
        if (string.equals("default")) {
            this.corrfreq = true;
            this.indifreq = false;
            this.inferlambd = false;
            this.freqDlg = null;
            this.lambdDlg = null;
            this.updatePanelUI();
            return;
        }
    }
}

