/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Gui.Param.LambdDlg;
import Obj.NSimObj;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class IndiFreqDlg
extends JDialog
implements ActionListener {
    private int buttonHit;
    private JButton okButton;
    private JButton cancelButton;
    private JButton defaultButton;
    private JRadioButton setlambdBox;
    private JRadioButton inferlambdBox;
    private JTextField lambdField;
    private JButton lambdButton;
    private LambdDlg lambdDlg;
    private boolean setlambd = true;
    private boolean inferlambd = false;
    private float lambd = 1.0f;
    private NSimObj sim;

    public IndiFreqDlg(Component component, NSimObj nSimObj, boolean bl) {
        this.sim = nSimObj;
        this.setlambdBox = new JRadioButton("Set Lambda  ");
        this.inferlambdBox = new JRadioButton("Infer Lambda");
        this.setlambdBox.setActionCommand("setlambd");
        this.setlambdBox.addActionListener(this);
        this.inferlambdBox.setActionCommand("inferlambd");
        this.inferlambdBox.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.setlambdBox);
        buttonGroup.add(this.inferlambdBox);
        this.lambdField = new JTextField(10);
        this.lambdButton = new JButton("Configure ...");
        this.lambdButton.setActionCommand("lambdbutton");
        this.lambdButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.lambdButton);
        this.okButton = new JButton("   OK  ");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel ");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(this.setlambdBox);
        jPanel2.add(this.inferlambdBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.lambdField);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.cancelButton);
        jPanel5.add(this.defaultButton);
        jPanel5.add(this.okButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(20, 20, 4, 20));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel6.add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel6.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(25, 20, 20, 20);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel6.add(jPanel5);
        this.setContentPane(jPanel6);
        this.setLocationRelativeTo(component);
        if (!nSimObj.isNew() && !bl) {
            this.setlambd = nSimObj.INDIFQSETLAMBDA;
            this.inferlambd = nSimObj.INDIFQINFERLAMBDA;
            if (this.setlambd) {
                this.lambd = nSimObj.LAMBDA;
            }
            if (this.inferlambd) {
                this.lambdDlg = new LambdDlg((Component)this, nSimObj, false);
            }
        }
        this.updatePanelUI();
    }

    private void updatePanelUI() {
        this.setlambdBox.setSelected(this.setlambd);
        this.lambdField.setText("" + this.lambd);
        this.lambdField.setEnabled(this.setlambd);
        this.inferlambdBox.setSelected(this.inferlambd);
        this.lambdButton.setEnabled(this.inferlambd);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Default")) {
            this.reset();
            return;
        }
        if (string.equals("ok")) {
            if (!this.validateData()) {
                return;
            }
            this.buttonHit = 0;
            this.setVisible(false);
        }
        if (string.equals("cancel")) {
            this.buttonHit = 2;
            this.reset();
            this.setVisible(false);
        }
        if (string.equals("setlambd")) {
            if (!this.setlambd) {
                this.setlambd = true;
                this.inferlambd = false;
            }
            this.updatePanelUI();
            return;
        }
        if (string.equals("inferlambd")) {
            if (!this.inferlambd) {
                this.inferlambd = true;
                this.setlambd = false;
                this.lambd = 1.0f;
            }
            this.updatePanelUI();
            return;
        }
        if (string.equals("lambdbutton")) {
            if (this.lambdDlg == null) {
                this.lambdDlg = new LambdDlg((Component)this, this.sim, true);
            }
            this.lambdDlg.showDialog();
            return;
        }
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public void reset() {
        this.setlambd = true;
        this.inferlambd = false;
        this.lambd = 1.0f;
        this.updatePanelUI();
    }

    public boolean validateData() {
        String string;
        String string2 = "";
        if (this.setlambd) {
            string = this.lambdField.getText();
            try {
                this.lambd = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = string2 + new String("\nLambda Must be a Real Number");
            }
        }
        if (string2.compareTo("") != 0) {
            string = "Errors:\n";
            string2 = string.concat(string2);
            string2 = string2 + new String("\n\n");
            JOptionPane.showMessageDialog(this, string2, "errors", 0);
            return false;
        }
        return true;
    }

    public void updateData() {
        this.sim.INDIFQSETLAMBDA = this.setlambd;
        this.sim.INDIFQINFERLAMBDA = this.inferlambd;
        if (this.setlambd) {
            this.sim.LAMBDA = this.lambd;
        }
        if (this.inferlambd) {
            if (this.lambdDlg == null) {
                this.sim.LAMBDA = 1.0f;
                this.sim.POPSPECIFICLAMBDA = false;
            } else {
                this.lambdDlg.updateData();
            }
        }
    }
}

