/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Gui.Param.AdditionalPanel;
import Gui.Param.AncestryPanel;
import Gui.Param.FrequencyPanel;
import Gui.Param.MainPanel;
import Obj.NProjObj;
import Obj.NSimObj;
import Obj.ObjIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ParamDlg
extends JDialog
implements ActionListener {
    int buttonHit;
    MainPanel mainPane;
    AncestryPanel ancestPane;
    FrequencyPanel freqPane;
    AdditionalPanel additionalPane;
    NSimObj sim;

    public ParamDlg(NSimObj nSimObj) {
        this.sim = nSimObj;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.mainPane = new MainPanel(nSimObj);
        this.ancestPane = new AncestryPanel(nSimObj);
        this.freqPane = new FrequencyPanel(nSimObj);
        this.additionalPane = new AdditionalPanel(nSimObj);
        jTabbedPane.addTab("Run Length", this.mainPane);
        jTabbedPane.addTab("Ancestry Model", this.ancestPane);
        jTabbedPane.addTab("Allele Frequency Model", this.freqPane);
        jTabbedPane.addTab("Advanced", this.additionalPane);
        jTabbedPane.setSelectedIndex(0);
        jPanel.add((Component)jTabbedPane, "Center");
        JButton jButton = new JButton("  OK  ");
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel ");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add("East", jPanel2);
        jPanel3.setPreferredSize(new Dimension(400, 30));
        jPanel.add((Component)jPanel3, "South");
        jPanel.setPreferredSize(new Dimension(550, 400));
        this.getContentPane().add(jPanel);
        if (nSimObj.isNew()) {
            this.setTitle("New Parameter Set");
        } else {
            this.setTitle(nSimObj.getSimName() + " Parameters");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ParamDlg.this.buttonHit = 2;
                ParamDlg.this.setVisible(false);
            }
        });
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public NSimObj getSimObj() {
        return this.sim;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok")) {
            Object[] objectArray;
            if (!this.mainPane.validateData()) {
                return;
            }
            this.mainPane.updateData();
            if (!this.additionalPane.validateData()) {
                return;
            }
            this.additionalPane.updateData();
            this.ancestPane.updateData();
            this.freqPane.updateData();
            if (!this.sim.USEDEFAULTADMBURNIN && this.sim.ADMBURNIN > this.sim.BURNIN) {
                JOptionPane.showMessageDialog(this, "The length of admixture burnin should be \nless than burnin length\n", "errors", 0);
                return;
            }
            if (this.sim.isNew()) {
                if (this.sim.createSimSpace()) {
                    NProjObj nProjObj;
                    if (this.sim.LOCPRIOR && !(nProjObj = this.sim.getProjObj()).getLocData()) {
                        if (nProjObj.getPopId()) {
                            JOptionPane.showMessageDialog(this, "Input data contains no sampling location information,  LOCPRIOR model will use population IDs", "Sampling Location Information", 2);
                        }
                        if (!nProjObj.getPopId()) {
                            JOptionPane.showMessageDialog(this, "No sampling location information can be found in the data, structure can not apply LOCPRIOR model", "Sampling Location Information", 0);
                            this.sim.LOCPRIOR = false;
                        }
                    }
                    ObjIO.writeSimFile(this.sim);
                    this.buttonHit = 0;
                } else {
                    this.buttonHit = 2;
                }
                this.setVisible(false);
                return;
            }
            NSimObj nSimObj = ObjIO.loadSimObj(this.sim.getProjObj(), this.sim.getSimName());
            if (this.sim.LOCPRIOR && !nSimObj.LOCPRIOR && !(objectArray = this.sim.getProjObj()).getLocData()) {
                if (objectArray.getPopId()) {
                    JOptionPane.showMessageDialog(this, "Input data contains no sampling location information, LOCPRIOR model will use population IDs", "Sampling Location Information", 2);
                }
                if (!objectArray.getPopId()) {
                    JOptionPane.showMessageDialog(this, "No sampling location information can be found in the data, structure can not apply LOCPRIOR model", "Sampling Location Information", 0);
                    this.sim.LOCPRIOR = false;
                }
            }
            if (this.sim.equals(nSimObj)) {
                nSimObj = null;
                this.buttonHit = 0;
                this.setVisible(false);
                return;
            }
            objectArray = new Object[]{"Save as a new parameter set  ", "   Ignore   the   changes   "};
            int n = JOptionPane.showOptionDialog(this, "Simulation parameters have been modified!", "Simulation Parameter Settings", 0, 3, null, objectArray, objectArray[1]);
            if (n == 0) {
                if (this.sim.createSimSpace()) {
                    ObjIO.writeSimFile(this.sim);
                    this.buttonHit = 1;
                } else {
                    this.buttonHit = 2;
                    this.sim = nSimObj;
                }
                this.setVisible(false);
                return;
            }
            if (n == 1) {
                this.sim = nSimObj;
                this.buttonHit = 2;
                this.setVisible(false);
                return;
            }
        }
        if (actionEvent.getActionCommand().equals("cancel")) {
            this.buttonHit = 2;
            this.setVisible(false);
        }
    }
}

