/*
 * Decompiled with CFR 0.152.
 */
package Gui.Wizard;

import Gui.Wizard.Wizard_1;
import Gui.Wizard.Wizard_2;
import Gui.Wizard.Wizard_3;
import Gui.Wizard.Wizard_4;
import Obj.NProjObj;
import Util.FileCounter;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WizardController
extends WindowAdapter
implements ActionListener {
    private Wizard_1 w1;
    private Wizard_2 w2;
    private Wizard_3 w3;
    private Wizard_4 w4;
    private JFrame main;
    private Point pos;
    private File dataFile;
    private JDialog currDlg;
    private boolean isDone;
    private NProjObj projObj;
    private String[][] data;

    public WizardController(JFrame jFrame) {
        this.main = jFrame;
        this.isDone = false;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void initWizard() {
        this.w1 = new Wizard_1((Frame)this.main, this);
        this.w2 = new Wizard_2((Frame)this.main, this);
        this.w3 = new Wizard_3((Frame)this.main, this);
        this.w4 = new Wizard_4((Frame)this.main, this);
        this.currDlg = this.w1;
        this.w1.setLocationRelativeTo(this.main);
        this.w1.showDialog();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.projObj = null;
        this.destroyAll();
        super.windowClosing(windowEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.compareTo("w1_next") == 0) {
            this.pos = this.w1.getLocation();
            String string2 = this.w1.getDataFile();
            this.dataFile = new File(string2);
            if (!this.dataFile.exists()) {
                this.dataFile = null;
                JOptionPane.showMessageDialog(null, "Invalid data file", "Error", 0);
                return;
            }
            this.w1.dispose();
            this.w2.setLocation(this.pos);
            this.w2.showDialog();
            this.currDlg = this.w2;
            return;
        }
        if (string.compareTo("w2_next") == 0) {
            this.pos = this.w2.getLocation();
            this.w2.dispose();
            this.w3.setLocation(this.pos);
            this.w3.showDialog(this.w2.getPloidy());
            this.currDlg = this.w3;
            return;
        }
        if (string.compareTo("w3_next") == 0) {
            this.pos = this.w3.getLocation();
            this.w3.dispose();
            this.w4.setLocation(this.pos);
            this.w4.showDialog();
            this.currDlg = this.w4;
            return;
        }
        if (string.compareTo("w4_back") == 0) {
            this.pos = this.w4.getLocation();
            this.w4.dispose();
            this.w3.setLocation(this.pos);
            this.w3.showDialog(this.w2.getPloidy());
            this.currDlg = this.w3;
            return;
        }
        if (string.compareTo("w3_back") == 0) {
            this.pos = this.w3.getLocation();
            this.w3.dispose();
            this.w2.setLocation(this.pos);
            this.w2.showDialog();
            this.currDlg = this.w2;
            return;
        }
        if (string.compareTo("w2_back") == 0) {
            this.pos = this.w2.getLocation();
            this.w2.dispose();
            this.w1.setLocation(this.pos);
            this.w1.showDialog();
            this.currDlg = this.w1;
            return;
        }
        if (string.compareTo("w1_cancel") == 0) {
            this.w1.dispose();
            this.destroyAll();
            return;
        }
        if (string.compareTo("w2_cancel") == 0) {
            this.w2.dispose();
            this.destroyAll();
            return;
        }
        if (string.compareTo("w3_cancel") == 0) {
            this.w3.dispose();
            this.destroyAll();
            return;
        }
        if (string.compareTo("w4_cancel") == 0) {
            this.w4.dispose();
            this.destroyAll();
            return;
        }
        if (string.compareTo("finish") == 0) {
            this.buildProjObj();
            if (this.projObj != null) {
                this.w4.dispose();
                this.destroyAll();
            }
            return;
        }
        if (string.equals("datainfo")) {
            if (this.dataFile == null) {
                JOptionPane.showMessageDialog(null, "No valid data file is specified", "Error", 0);
                return;
            }
            FileCounter fileCounter = new FileCounter(this.dataFile);
            fileCounter.report();
            return;
        }
    }

    private void destroyAll() {
        this.w1 = null;
        this.w2 = null;
        this.w3 = null;
        this.w4 = null;
        this.isDone = true;
    }

    private void buildProjObj() {
        Object[] objectArray;
        Object object;
        String string = "";
        String string2 = this.w1.getProjName();
        String string3 = this.w1.getProjDir();
        File file = new File(string3);
        if (!file.exists()) {
            string = string + new String("\n* The directory to save project does not exist");
        }
        boolean bl = this.w4.getIndLabel();
        boolean bl2 = this.w4.getPopId();
        boolean bl3 = this.w4.getPopFlag();
        boolean bl4 = this.w3.getGeneName();
        boolean bl5 = this.w3.getLocusName();
        boolean bl6 = this.w3.getPhaseInfo();
        boolean bl7 = this.w3.getOneRow();
        boolean bl8 = false;
        boolean bl9 = this.w4.getPheno();
        boolean bl10 = this.w3.getRecessiveAllele();
        boolean bl11 = this.w4.getLocData();
        String string4 = this.w4.getExtraCols();
        Object[] objectArray2 = "";
        int n = 0;
        if (string4 == null) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                string = string + new String("\n* Input in \"Extra Column\" Field is not an Integer");
            }
        }
        String string5 = this.w2.getNumInds();
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\n* Input in \"Number of Individuals\" Field is not an Integer");
        }
        String string6 = this.w2.getPloidy();
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\n* Input in \"Number of Ploidy\" Field is not an Integer");
        }
        String string7 = this.w2.getNumLoci();
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string7);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\n* Input in \"Number of Loci\" Field is not an Integer");
        }
        String string8 = this.w2.getMissingVal();
        String string9 = this.w1.getDataFile();
        if (string9 != null && !((File)(object = new File(string9))).exists()) {
            string = string + new String("\n* The Data Source does not exist");
        }
        if (string.compareTo("") != 0) {
            object = "Errors detected when building project:\n\n";
            string = ((String)object).concat(string);
            string = string + new String("\n\n");
            JOptionPane.showMessageDialog(this.w4, string, "Input errors", 0);
            return;
        }
        object = "You are about to build a Structure project with following settings:\n\n";
        object = (String)object + new String("Project Name:  " + string2);
        object = (String)object + new String("\nProject Path:  " + string3);
        object = string9 != null ? (String)object + new String("\nData Source:  " + string9 + "\n\n") : (String)object + new String("\nData Source: Manually Input\n\n");
        object = (String)object + new String("\n========================================\n");
        object = (String)object + new String("\nNumber of Individuals:  " + n2);
        object = (String)object + new String("\nNumber of Loci:  " + n4);
        object = (String)object + new String("\nNumber of Ploidy:  " + n3);
        object = (String)object + new String("\nMissing Value represented as:  " + string8 + "\n");
        object = (String)object + new String("\n========================================\n");
        if (bl4) {
            object = (String)object + new String("\nData File Contains Row of Marker Names");
        }
        if (bl5) {
            object = (String)object + new String("\nData File Contains Row of Map Distances between Loci");
        }
        if (bl6) {
            object = (String)object + new String("\nData File Contains Phase Information");
        }
        if (bl7) {
            object = (String)object + new String("\nData File Stores Data for Individuals in a Single Line");
        }
        if (bl) {
            object = (String)object + new String("\nData File Contains Individual Labels");
        }
        if (bl2) {
            object = (String)object + new String("\nData File Contains Population Identifiers");
        }
        if (bl11) {
            object = (String)object + new String("\nData File Contains Sampling Location Information");
        }
        if (bl3) {
            object = (String)object + new String("\nData File Contains USEPOPINFO Selection Flagn");
        }
        if (bl9) {
            object = (String)object + new String("\nData File Contains Phenotpye Information");
        }
        object = (String)object + new String("\nNumber of Other Extra Columns:  " + n + "\n");
        int n5 = JOptionPane.showOptionDialog(this.w4, object = (String)object + new String("\n========================================\n"), "Comfirmation", 0, 3, null, objectArray = new Object[]{"Proceed", "Go back"}, objectArray[0]);
        if (n5 == 1) {
            return;
        }
        if (n3 == 1) {
            bl8 = true;
        }
        if (n3 >= 3 && bl5 || n3 == 2 && !bl6 && bl5) {
            object = new Object[]{" Yes ", "  No "};
            int n6 = JOptionPane.showOptionDialog(null, "Are the data phased ?", "One more question", 0, 3, null, (Object[])object, null);
            bl8 = n6 == 0;
        }
        if (n3 >= 3 && bl10) {
            object = null;
            while (object == null) {
                object = JOptionPane.showInputDialog("Indicator code for locus without genotypic ambiguity");
                if (!((String)object).equals(string8)) continue;
                JOptionPane.showMessageDialog(null, "Indicator code must be different from missing value", "Error", 0);
                object = null;
            }
            objectArray2 = object;
        }
        this.projObj = new NProjObj(string2, string3, bl, bl2, n, n2, n3, n4, string8, string9, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11);
        if (n3 >= 3 && bl10) {
            this.projObj.setNAMBCode((String)objectArray2);
        }
        this.data = this.projObj.loadData();
        if (this.data == null) {
            object = new String("The data file is expected to have following format:\n\n");
            if (bl4) {
                object = (String)object + "1 row with " + n4 + " entries (marker name) \n";
            }
            if (bl10) {
                object = (String)object + "1 row with " + n4 + " entries (recessive allele) \n";
            }
            if (bl5) {
                object = (String)object + "1 row with " + n4 + " entries (map distance) \n";
            }
            if (bl6) {
                object = (String)object + "" + n2 + " rows with " + n4 + " entries (phase information)\n";
            }
            int n7 = n3;
            if (bl7) {
                n7 = 1;
            }
            n5 = n7 * n2;
            int n8 = n4;
            if (bl7) {
                n8 = n4 * n3;
            }
            if (bl) {
                ++n8;
            }
            if (bl2) {
                ++n8;
            }
            if (bl11) {
                ++n8;
            }
            if (bl3) {
                ++n8;
            }
            object = (String)object + "" + n5 + " rows with " + (n8 += n) + " entries (data)\n\n";
            JOptionPane.showMessageDialog(null, object, "Structure Wizard", 1);
            this.projObj = null;
        }
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public String[][] getData() {
        return this.data;
    }

    public NProjObj getProjObj() {
        return this.projObj;
    }

    private static InputStream OpenInputFile(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open input file.");
            fileInputStream = null;
        }
        return fileInputStream;
    }
}

