/*
 * Decompiled with CFR 0.152.
 */
package Obj;

import Obj.SimObj;
import Util.CopyFile;
import Util.DelDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ProjObj
implements Serializable {
    private String workingPath;
    private String projName;
    private String projPath;
    private Vector simList;
    private boolean useIndLabel;
    private boolean usePopId;
    private boolean usePopFlag;
    private boolean useGeneName;
    private boolean useLocusName;
    private boolean usePhaseInfo;
    private boolean usePhenoType;
    private boolean oneRow;
    private boolean phased;
    private int extraCol = 0;
    private int numInds;
    private int ploidy;
    private int numloci;
    private String missingVal;
    private String dataFile;

    public ProjObj(String string, String string2, boolean bl, boolean bl2, int n, int n2, int n3, int n4, String string3, String string4, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.projName = string;
        this.projPath = string2;
        this.useIndLabel = bl;
        this.usePopId = bl2;
        this.extraCol = n;
        this.numInds = n2;
        this.ploidy = n3;
        this.numloci = n4;
        this.missingVal = string3;
        this.dataFile = string4;
        this.usePopFlag = bl3;
        this.useGeneName = bl4;
        this.useLocusName = bl5;
        this.usePhaseInfo = bl6;
        this.oneRow = bl7;
        this.phased = bl8;
        this.usePhenoType = bl9;
        this.simList = new Vector();
    }

    public ProjObj() {
        this.simList = new Vector();
    }

    public void setName(String string) {
        this.projName = string;
    }

    public String getName() {
        return this.projName;
    }

    public void setPath(String string) {
        this.projPath = string;
    }

    public String getPath() {
        return this.projPath;
    }

    public void setIndLabel(boolean bl) {
        this.useIndLabel = bl;
    }

    public boolean isIndLabel() {
        return this.useIndLabel;
    }

    public void setPopId(boolean bl) {
        this.useIndLabel = bl;
    }

    public boolean isPopId() {
        return this.useIndLabel;
    }

    public void setExtraCol(int n) {
        this.extraCol = n;
    }

    public int getExtraCol() {
        return this.extraCol;
    }

    public void setNumInds(int n) {
        this.numInds = n;
    }

    public int getNumInds() {
        return this.numInds;
    }

    public void setPloidy(int n) {
        this.ploidy = n;
    }

    public int getPloidy() {
        return this.ploidy;
    }

    public void setNumloci(int n) {
        this.numloci = n;
    }

    public int getNumloci() {
        return this.numloci;
    }

    public void setMissingVal(String string) {
        this.missingVal = string;
    }

    public String getMissingVal() {
        return this.missingVal;
    }

    public void setDataFile(String string) {
        this.dataFile = string;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public boolean getMapDistance() {
        return this.useLocusName;
    }

    public boolean getGeneName() {
        return this.useGeneName;
    }

    public boolean getOneRow() {
        return this.oneRow;
    }

    public boolean getPhaseInfo() {
        return this.usePhaseInfo;
    }

    public boolean getPhased() {
        return this.phased;
    }

    public void writeProjectFile() {
        String string = this.projName.concat(".spj");
        File file = new File(this.workingPath, string);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createProjectSpace() {
        File file = new File(this.projPath, this.projName);
        file.mkdirs();
        this.workingPath = file.getAbsolutePath();
        File file2 = new File(this.workingPath, "project_data");
        CopyFile.copyFile(this.dataFile, file2.getAbsolutePath());
        this.dataFile = file2.getAbsolutePath();
        this.writeProjectFile();
    }

    private void setWorkingPath(String string) {
        this.workingPath = string;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    private void setSimVector() {
        this.simList = new Vector();
        File file = new File(this.workingPath);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2;
            if (!fileArray[i].isDirectory() || !(file2 = new File(fileArray[i], ".sim")).exists()) continue;
            this.simList.addElement(fileArray[i].getName());
        }
    }

    public static ProjObj loadProjObj(File file) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            ProjObj projObj = (ProjObj)objectInputStream.readObject();
            objectInputStream.close();
            File file2 = new File(file.getParent());
            projObj.setWorkingPath(file2.getAbsolutePath());
            File file3 = new File(file.getParent(), "project_data");
            projObj.setDataFile(file3.getAbsolutePath());
            projObj.setSimVector();
            return projObj;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Can not Read Project File", "Error", 0);
            System.err.println(iOException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "Fail to Open Project File", "Error", 0);
            return null;
        }
    }

    public String getConfig() {
        String string = "";
        string = string + new String("#define INFILE " + this.dataFile + "\n");
        string = string + new String("#define NUMINDS " + this.numInds + "\n");
        string = string + new String("#define NUMLOCI " + this.numloci + "\n");
        string = this.useIndLabel ? string + new String("#define LABEL 1 \n") : string + new String("#define LABEL 0 \n");
        string = this.usePopId ? string + new String("#define POPDATA 1 \n") : string + new String("#define POPDATA 0 \n");
        string = this.usePopFlag ? string + new String("#define POPFLAG 1 \n") : string + new String("#define POPFLAG 0 \n");
        string = this.usePhenoType ? string + new String("#define PHENOTYPE 1 \n") : string + new String("#define PHENOTYPE 0 \n");
        string = this.useGeneName ? string + new String("#define MARKERNAMES 1 \n") : string + new String("#define MARKERNAMES 0 \n");
        string = this.useLocusName ? string + new String("#define MAPDISTANCES 1 \n") : string + new String("#define MAPDISTANCES 0 \n");
        string = this.oneRow ? string + new String("#define ONEROWPERIND 1 \n") : string + new String("#define ONEROWPERIND 0 \n");
        string = this.usePhaseInfo ? string + new String("#define PHASEINFO 1 \n") : string + new String("#define PHASEINFO 0 \n");
        string = this.phased ? string + new String("#define PHASED 1 \n") : string + new String("#define PHASED 0 \n");
        string = string + new String("#define EXTRACOLS " + this.extraCol + "\n");
        string = string + new String("#define MISSING " + this.missingVal + "\n");
        string = string + new String("#define PLOIDY " + this.ploidy + "\n");
        return string;
    }

    public String printProjInfo() {
        String string = new String("\n");
        string = string + new String("         =============== Project Information ============== \n\n");
        string = string + new String("                  Project Name: " + this.projName + "\n");
        string = string + new String("                  Project Path: " + this.workingPath + "\n");
        string = string + new String("                  Data File: " + this.dataFile + "\n\n\n");
        string = string + new String("                         Data Information\n\n");
        string = string + new String("                  Number of Individuals: " + this.numInds + "\n");
        string = string + new String("                  Number of Loci: " + this.numloci + "\n");
        string = string + new String("                  Ploidy: " + this.ploidy + "\n");
        string = string + new String("                  Missing Data is Represented by: " + this.missingVal + "\n\n\n");
        string = string + new String("                         Data Format\n\n");
        if (this.useIndLabel) {
            string = string + new String("                  Data Contains Individual Labels \n");
        }
        if (this.usePopId) {
            string = string + new String("                  Data Contains Population Identifiers \n");
        }
        if (this.usePopFlag) {
            string = string + new String("                  Data Contains USEPOPINFO Selection Flags \n");
        }
        if (this.useGeneName) {
            string = string + new String("                  Data Contains Row of Marker Names \n");
        }
        if (this.useLocusName) {
            string = string + new String("                  Data Contains Map Distances between Loci \n");
        }
        if (this.usePhaseInfo) {
            string = string + new String("                  Data Contains Phase Information \n");
        }
        if (this.usePhenoType) {
            string = string + new String("                  Data Contains Phenotype \n");
        }
        if (this.oneRow) {
            string = string + new String("                  Data File Strores Data for Individuals in a Single Line \n");
        }
        if (this.phased) {
            string = string + new String("                  Data are phased \n");
        }
        if (this.extraCol > 0) {
            string = string + new String("                  Total Number of Extra Columns: " + this.extraCol + "\n");
        }
        return string;
    }

    public int getColNum() {
        return this.numloci + this.extraCol;
    }

    public String[] getDataTitle() {
        int n;
        int n2;
        int n3 = this.numloci;
        if (this.oneRow) {
            n3 = this.numloci * this.ploidy;
        }
        int n4 = this.extraCol;
        if (this.useIndLabel) {
            ++n4;
        }
        if (this.usePopId) {
            ++n4;
        }
        if (this.usePopFlag) {
            ++n4;
        }
        if (this.usePhenoType) {
            ++n4;
        }
        String[] stringArray = new String[n3 + n4];
        int n5 = 0;
        if (this.useIndLabel) {
            stringArray[n5++] = "Label";
        }
        if (this.usePopId) {
            stringArray[n5++] = "Pop ID";
        }
        if (this.usePopFlag) {
            stringArray[n5++] = "Flag";
        }
        if (this.usePhenoType) {
            stringArray[n5++] = "Phenotype";
        }
        for (n2 = 0; n2 < this.extraCol; ++n2) {
            stringArray[n5 + n2] = "Extra " + (n2 + 1);
        }
        n5 += this.extraCol;
        n2 = 1;
        if (this.oneRow) {
            n2 = this.ploidy;
        }
        int n6 = 1;
        int n7 = n5;
        for (n = n5; n < stringArray.length; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.numloci; ++n) {
            stringArray[n7] = "Locus " + n6;
            n7 += n2;
            ++n6;
        }
        return stringArray;
    }

    public String[][] loadData() {
        int n;
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = this.ploidy;
        if (this.oneRow) {
            n3 = 1;
        }
        if (this.usePhaseInfo) {
            ++n3;
        }
        n2 = n3 * this.numInds;
        int n4 = 0;
        if (this.useGeneName) {
            ++n4;
        }
        if (this.useLocusName) {
            ++n4;
        }
        n2 += n4;
        int n5 = this.numloci;
        if (this.oneRow) {
            n5 = this.numloci * this.ploidy;
        }
        int n6 = this.extraCol;
        if (this.useIndLabel) {
            ++n6;
        }
        if (this.usePopId) {
            ++n6;
        }
        if (this.usePopFlag) {
            ++n6;
        }
        if (this.usePhenoType) {
            ++n6;
        }
        String[][] stringArray = new String[n2][n5 += n6];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n5; ++j) {
                stringArray[i][j] = "  ";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        try {
            object2 = new FileInputStream(this.dataFile);
            object = new InputStreamReader((InputStream)object2, "UTF8");
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            while ((n = ((Reader)bufferedReader).read()) > -1) {
                stringBuffer.append((char)n);
            }
            ((Reader)bufferedReader).close();
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            System.out.println(stringBuffer);
            JOptionPane.showMessageDialog(null, "Can not Read Data Source", "Error", 0);
            return null;
        }
        object2 = new StringTokenizer(string, "\n");
        object = new String();
        int n7 = 0;
        n = 0;
        int n8 = this.ploidy;
        int n9 = 0;
        if (this.oneRow) {
            n8 = 1;
            n9 = this.ploidy - 1;
        }
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            if (!stringTokenizer.hasMoreTokens()) continue;
            if (n7 < n4) {
                if (!this.parseData(stringArray, n7, (String)object, n6, 0, n9)) {
                    return null;
                }
                ++n7;
                continue;
            }
            if (this.usePhaseInfo && n == n8) {
                if (!this.parseData(stringArray, n7, (String)object, n6, 0, n9)) {
                    return null;
                }
                n = 0;
                ++n7;
                continue;
            }
            if (!this.parseData(stringArray, n7, (String)object, n6, 1, 0)) {
                return null;
            }
            ++n7;
            ++n;
        }
        if (n7 < stringArray.length) {
            JOptionPane.showMessageDialog(null, "Bad Format in Data Source: \nExpect " + stringArray.length + " rows, currently have " + n7 + " rows", "Error", 0);
            return null;
        }
        return stringArray;
    }

    private boolean parseData(String[][] stringArray, int n, String string, int n2, int n3, int n4) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n5 = 0;
        if (n3 == 0) {
            n5 = n2;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                stringArray[n][n5] = string3;
                n5 += n4 + 1;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = n >= stringArray.length ? "Number of rows are more than expected (" + stringArray.length + ")" : "Data entries are more than expected (" + stringArray[n].length + ") at line " + (n + 1);
                JOptionPane.showMessageDialog(null, "Bad Format in Data Source: \n" + string2, "Error", 0);
                return false;
            }
        }
        if (n5 != stringArray[0].length) {
            string2 = "Expect " + stringArray[0].length + " data entries at line " + (n + 1);
            JOptionPane.showMessageDialog(null, "Bad Format in Data Source: \n" + string2, "Error", 0);
            return false;
        }
        return true;
    }

    public boolean checkSimName(String string) {
        if (string == null) {
            return false;
        }
        if (this.simList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.simList.size(); ++i) {
            String string2 = (String)this.simList.elementAt(i);
            if (!string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    public boolean addSimObj(String string) {
        if (this.checkSimName(string)) {
            this.simList.add(string);
            return true;
        }
        return false;
    }

    public boolean removeSimObj(String string) {
        for (int i = 0; i < this.simList.size(); ++i) {
            String string2 = (String)this.simList.elementAt(i);
            if (string2.compareTo(string) != 0) continue;
            this.simList.remove(i);
            --i;
            File file = new File(this.workingPath, string);
            DelDir.removeDir(file);
            return true;
        }
        return false;
    }

    public SimObj getSimObj(String string) {
        for (int i = 0; i < this.simList.size(); ++i) {
            String string2 = (String)this.simList.elementAt(i);
            if (string2.compareTo(string) != 0) continue;
            File file = new File(this.workingPath, string);
            String string3 = file.getAbsolutePath();
            File file2 = new File(string3, ".sim");
            SimObj simObj = SimObj.loadSimObj(file2);
            if (simObj != null) {
                simObj.setProjObj(this);
            }
            return simObj;
        }
        return null;
    }

    public String[] getSimList() {
        String[] stringArray = new String[this.simList.size()];
        for (int i = 0; i < this.simList.size(); ++i) {
            stringArray[i] = (String)this.simList.elementAt(i);
        }
        return stringArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private static InputStream OpenInputFile(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open input file.");
            fileInputStream = null;
        }
        return fileInputStream;
    }
}

