/*
 * Decompiled with CFR 0.152.
 */
package Postscript;

import Util.GeneralFileFilter;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import interpreter.PAContext;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PostscriptViewer
extends JApplet
implements ActionListener,
Runnable {
    static String[] postscriptFiles = new String[]{"plotfile"};
    static JComboBox combo;
    static URL url;
    JPanel p1;
    Demo demo;
    private static Graphics2D g2;

    public void init() {
        this.p1 = new JPanel(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 20, 10, 20);
        this.p1.setBorder(emptyBorder);
        this.p1.setBackground(Color.gray);
        this.p1.setToolTipText("click to start/stop iterating");
        this.p1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (PostscriptViewer.this.demo.thread == null) {
                    PostscriptViewer.this.demo.start();
                } else {
                    PostscriptViewer.this.demo.stop();
                }
            }
        });
        this.getContentPane().add("South", this.p1);
        JPanel jPanel = new JPanel(new BorderLayout());
        emptyBorder = new EmptyBorder(20, 20, 5, 20);
        BevelBorder bevelBorder = new BevelBorder(1);
        jPanel.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        jPanel.setBackground(Color.gray);
        this.demo = new Demo();
        jPanel.add(this.demo);
        this.getContentPane().add("Center", jPanel);
        url = PostscriptViewer.class.getResource("../library/neighbor/plots/plotfile");
        JButton jButton = new JButton("Save Image");
        jButton.addActionListener(this);
        jButton.setActionCommand("save");
        jButton.setEnabled(true);
        this.p1.add("West", jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("close");
        jButton2.setEnabled(true);
        this.p1.add("East", jButton2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        System.out.println(string);
        if (string.equals("save")) {
            JFileChooser jFileChooser = new JFileChooser();
            GeneralFileFilter generalFileFilter = new GeneralFileFilter("jpg", "JPEG image files");
            jFileChooser.addChoosableFileFilter(generalFileFilter);
            int n = jFileChooser.showDialog(this, "Save");
            if (n == 0) {
                Object[] objectArray;
                File file = jFileChooser.getSelectedFile();
                String string2 = file.getAbsolutePath();
                if (!string2.endsWith(".jpg") && !string2.endsWith(".jpeg")) {
                    file = new File(new String(string2 + ".jpg"));
                }
                if (file.exists()) {
                    objectArray = new Object[]{"Yes", "No "};
                    int n2 = JOptionPane.showOptionDialog(this, "Target file " + file.getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                    if (n2 == 1) {
                        return;
                    }
                }
                if (!(objectArray = file.getParentFile()).canWrite()) {
                    JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                    return;
                }
                BufferedImage bufferedImage = new BufferedImage(420, 380, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                this.paint(graphics2D);
                try {
                    File file2 = new File(file.getAbsolutePath());
                    JimiRasterImage jimiRasterImage = Jimi.createRasterImage(bufferedImage.getSource());
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fileOutputStream != null) {
                        Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
                    }
                }
                catch (JimiException jimiException) {
                    jimiException.printStackTrace();
                }
            }
        }
        if (string.equals("close")) {
            // empty if block
        }
        new Thread(this).start();
    }

    public void run() {
        this.demo.repaint();
    }

    static class Demo
    extends Canvas
    implements Runnable {
        Thread thread;

        public Demo() {
            this.setBackground(Color.white);
        }

        public void paint(Graphics graphics) {
            Object object;
            Dimension dimension = this.getSize();
            g2 = (Graphics2D)graphics;
            System.out.println(dimension);
            double d = (double)Math.min(dimension.width, dimension.height) / 700.0;
            PAContext pAContext = new PAContext(g2, dimension);
            if (d != 1.0) {
                object = new AffineTransform();
                ((AffineTransform)object).scale(d * 1.2, d * 0.9);
                g2.transform((AffineTransform)object);
            }
            try {
                object = url.openStream();
                pAContext.draw((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void start() {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 0; i < postscriptFiles.length; ++i) {
                    combo.setSelectedIndex(i);
                    try {
                        Thread.sleep(6000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

