/*
 * Decompiled with CFR 0.152.
 */
package Tree;

import Controller.StructureApp;
import Util.GeneralFileFilter;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import interpreter.PAContext;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TreePlotManager
extends JApplet
implements ActionListener,
Runnable {
    private StructureApp app;
    private String datafile;
    private JComboBox[] palettelist;
    private Hashtable colormap;
    private Vector idVec;
    private int leftindex;
    private int rightindex;
    private double[][] data;
    private int[] id;
    private File[] runlist;
    private String[] simlist;
    private Color[] colorlist;
    private int simlist_select;
    private int filelist_select;
    private int bleft_select;
    private int bright_select;
    private Frame frame;
    private int K;
    private Process proc;
    private String parameterSetName;
    private String plotFile;
    private String plotFileName;
    private String[] pieces;
    static String[] postscriptFiles = new String[]{"test-parameter-set_run_5_f"};
    static JComboBox combo;
    static URL url;
    JPanel p1;
    Demo demo;

    public TreePlotManager(StructureApp structureApp, String[] stringArray, String string, String string2, String string3) {
        string3 = string3.replaceFirst(string, "");
        string3 = string3.replace("(", "");
        this.plotFileName = string3 = string3.replace(")", "");
        this.parameterSetName = string;
        this.plotFile = "library/neighbor/plots/" + string3;
        this.app = structureApp;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.simlist = new String[stringArray.length + 1];
        this.simlist[0] = "Select one";
        for (int i = 0; i < stringArray.length; ++i) {
            this.simlist[i + 1] = stringArray[i];
        }
    }

    public TreePlotManager() {
    }

    public Integer getK(String string, String string2) {
        try {
            String string3;
            FileInputStream fileInputStream = new FileInputStream(string2);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            this.K = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("populations assumed") < 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                this.K = Integer.valueOf(stringTokenizer.nextToken());
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        return this.K;
    }

    public void parseDistanceMatrix(String string, String string2) {
        String string3 = System.getProperty("user.dir");
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            int n = 0;
            boolean bl = false;
            try {
                String string4;
                FileWriter fileWriter = new FileWriter(string3 + "/library/neighbor/plots/infile");
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.indexOf("populations assumed") >= 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string4);
                        this.K = Integer.valueOf(stringTokenizer.nextToken());
                        bufferedWriter.write("    " + this.K);
                        bufferedWriter.newLine();
                    }
                    if (string4.indexOf("Net nucleotide distance") >= 0) {
                        bl = true;
                    }
                    if (n > 3 && n < 3 + this.K + 1) {
                        string4 = string4.replace("   -  ", "0.0000");
                        string4 = string4.replace("   ", "            ");
                        bufferedWriter.write(string4);
                        bufferedWriter.newLine();
                    }
                    if (!bl) continue;
                    ++n;
                }
                bufferedWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
    }

    public void runNeighborAlgorithm(String string, String string2) {
        String string3 = string;
        try {
            this.proc = Runtime.getRuntime().exec("library/neighbor/neighbor " + this.plotFileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            try {
                String string4;
                while ((string4 = bufferedReader.readLine()) != null) {
                }
            }
            catch (IOException iOException) {
                System.exit(0);
                return;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void createTreePlot(String string, String string2) {
        JLabel jLabel = new JLabel("Parameter set:");
        JLabel jLabel2 = new JLabel("    Result file:");
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{this.plotFileName};
        String string3 = this.plotFileName;
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        jComboBox.disable();
        jComboBox2.disable();
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBackground(Color.gray);
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        jPanel.add(jLabel2);
        jPanel.add(jComboBox2);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 20, 10, 20);
        jPanel2.setBorder(emptyBorder);
        jPanel2.setBackground(Color.gray);
        jPanel2.setToolTipText("click to start/stop iterating");
        jPanel2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (TreePlotManager.this.demo.thread == null) {
                    TreePlotManager.this.demo.start();
                } else {
                    TreePlotManager.this.demo.stop();
                }
            }
        });
        this.getContentPane().add("South", jPanel2);
        this.getContentPane().add("North", jPanel);
        emptyBorder = new EmptyBorder(20, 20, 5, 20);
        BevelBorder bevelBorder = new BevelBorder(1);
        jPanel3.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        jPanel3.setBackground(Color.gray);
        this.demo = new Demo();
        jPanel3.add(this.demo);
        this.getContentPane().add("Center", jPanel3);
        File file = new File(this.plotFile);
        try {
            url = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        JButton jButton = new JButton("Save");
        JButton jButton2 = new JButton("Close");
        jButton.addActionListener(this);
        jButton.setActionCommand("save");
        jButton.setEnabled(true);
        jButton2.addActionListener(this);
        jButton2.setActionCommand("close");
        jButton2.setEnabled(true);
        jPanel2.add((Component)jButton, "Center");
        this.frame = new Frame("Neighbor Joining Tree - Structure");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TreePlotManager.this.frame.dispose();
                TreePlotManager.this.deletefile(TreePlotManager.this.plotFile);
            }
        };
        this.frame.addWindowListener(windowAdapter);
        this.frame.add("Center", this);
        this.frame.pack();
        int n = 800;
        int n2 = 800;
        this.frame.setSize(new Dimension(n, n2));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        this.frame.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("save")) {
            JFileChooser jFileChooser = new JFileChooser();
            GeneralFileFilter generalFileFilter = new GeneralFileFilter("ps", "POSTSCRIPT image files");
            jFileChooser.addChoosableFileFilter(generalFileFilter);
            int n = jFileChooser.showDialog(this.frame, "Save");
            if (n == 0) {
                Object[] objectArray;
                File file = jFileChooser.getSelectedFile();
                String string2 = file.getAbsolutePath();
                if (!string2.endsWith(".jpg") && !string2.endsWith(".ps")) {
                    file = new File(new String(string2 + ".ps"));
                }
                if (file.exists()) {
                    objectArray = new Object[]{"Yes", "No "};
                    int n2 = JOptionPane.showOptionDialog(this.frame, "Target file " + file.getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                    if (n2 == 1) {
                        return;
                    }
                }
                if (!(objectArray = file.getParentFile()).canWrite()) {
                    JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                    return;
                }
                this.demo.saveImagePlotFile(file.getAbsolutePath(), this.plotFile);
            }
        }
        if (string.equals("close")) {
            this.frame.dispose();
        }
    }

    public void deletefile(String string) {
        File file = new File(string);
        boolean bl = file.delete();
        if (!bl) {
            System.out.println("Deletion failed.");
            System.exit(0);
        }
    }

    public void run() {
        this.demo.repaint();
    }

    static class Demo
    extends Canvas
    implements Runnable {
        Thread thread;
        Graphics2D g2;
        BufferedImage image;
        Graphics fg;

        public Demo() {
            this.setBackground(Color.white);
        }

        public void paint(Graphics graphics) {
            Object object;
            Dimension dimension = this.getSize();
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = (double)Math.min(dimension.width, dimension.height) / 700.0;
            PAContext pAContext = new PAContext(graphics2D, dimension);
            if (d != 1.0) {
                object = new AffineTransform();
                ((AffineTransform)object).scale(d * 1.2, d * 0.9);
                graphics2D.transform((AffineTransform)object);
            }
            try {
                object = url.openStream();
                pAContext.draw((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void saveImage(String string) {
            BufferedImage bufferedImage = new BufferedImage(420, 380, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.paint(graphics2D);
            try {
                File file = new File(string);
                JimiRasterImage jimiRasterImage = Jimi.createRasterImage(bufferedImage.getSource());
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fileOutputStream != null) {
                    Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
                }
            }
            catch (JimiException jimiException) {
                jimiException.printStackTrace();
            }
        }

        public void saveImagePlotFile(String string, String string2) {
            String string3 = string;
            String string4 = string2;
            try {
                int n;
                File file = new File(string4);
                File file2 = new File(string3);
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage() + " in the specified directory.");
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }

        public void start() {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 0; i < postscriptFiles.length; ++i) {
                    combo.setSelectedIndex(i);
                    try {
                        Thread.sleep(6000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

