/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Graph.Axis;
import Graph.DataSet;
import Graph.Gin;
import Graph.Graph2D;
import Graph.Range;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;

public class G2Dint
extends Graph2D {
    protected boolean drag = false;
    protected boolean userlimits = false;
    private Gin cpgin = null;
    private Gin dpgin = null;
    private Range range = null;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    private int x1old;
    private int y1old;
    protected Axis xaxis;
    protected Axis yaxis;

    public Axis createXAxis() {
        this.xaxis = super.createAxis(5);
        return this.xaxis;
    }

    public Axis createYAxis() {
        this.yaxis = super.createAxis(2);
        return this.yaxis;
    }

    public void attachAxis(Axis axis) {
        if (axis == null) {
            return;
        }
        super.attachAxis(axis);
        if (axis.getAxisPos() == 5 || axis.getAxisPos() == 4) {
            this.xaxis = axis;
        } else {
            this.yaxis = axis;
        }
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Color color = graphics.getColor();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.drag) {
            graphics.setColor(this.DataBackground);
            float[] fArray = Color.RGBtoHSB(this.DataBackground.getRed(), this.DataBackground.getGreen(), this.DataBackground.getBlue(), null);
            if ((double)fArray[2] < 0.5) {
                graphics.setXORMode(Color.white);
            } else {
                graphics.setXORMode(Color.black);
            }
            graphics.drawLine(this.x0, this.y0, this.x1old, this.y0);
            graphics.drawLine(this.x1old, this.y0, this.x1old, this.y1old);
            graphics.drawLine(this.x1old, this.y1old, this.x0, this.y1old);
            graphics.drawLine(this.x0, this.y1old, this.x0, this.y0);
            graphics.drawLine(this.x0, this.y0, this.x1, this.y0);
            graphics.drawLine(this.x1, this.y0, this.x1, this.y1);
            graphics.drawLine(this.x1, this.y1, this.x0, this.y1);
            graphics.drawLine(this.x0, this.y1, this.x0, this.y0);
            graphics.setColor(color);
            this.x1old = this.x1;
            this.y1old = this.y1;
            return;
        }
        if (this.clearAll) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        if (this.paintAll) {
            this.paint(graphics);
        }
    }

    public boolean keyDown(Event event, int n) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        switch (n) {
            case 82: {
                this.xaxis.resetRange();
                this.yaxis.resetRange();
                this.userlimits = false;
                this.repaint();
                return true;
            }
            case 114: {
                this.repaint();
                return true;
            }
            case 99: {
                if (this.cpgin == null) {
                    this.cpgin = new Gin("Position");
                }
                if (this.cpgin.isVisible()) {
                    this.cpgin.hide();
                } else {
                    this.cpgin.show();
                }
                return true;
            }
            case 68: {
                if (this.dpgin != null) {
                    this.dpgin.hide();
                }
                return true;
            }
            case 100: {
                if (this.dpgin == null) {
                    this.dpgin = new Gin("Data Point");
                }
                this.dpgin.show();
                double[] dArray = this.getClosestPoint(event.x, event.y);
                this.dpgin.setXlabel(dArray[0]);
                this.dpgin.setYlabel(dArray[1]);
                int n2 = this.xaxis.getInteger(dArray[0]);
                int n3 = this.yaxis.getInteger(dArray[1]);
                if (n2 >= this.datarect.x && n2 <= this.datarect.x + this.datarect.width && n3 >= this.datarect.y && n3 <= this.datarect.y + this.datarect.height) {
                    Graphics graphics = this.getGraphics();
                    graphics.fillOval(n2 - 4, n3 - 4, 8, 8);
                }
                return true;
            }
            case 109: {
                if (this.range == null) {
                    this.range = new Range(this);
                }
                this.range.show();
                this.range.requestFocus();
                this.userlimits = true;
                return true;
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.requestFocus();
        this.x0 = n;
        this.y0 = n2;
        this.drag = true;
        this.x1old = this.x0;
        this.y1old = this.y0;
        if (this.x0 < this.datarect.x) {
            this.x0 = this.datarect.x;
        } else if (this.x0 > this.datarect.x + this.datarect.width) {
            this.x0 = this.datarect.x + this.datarect.width;
        }
        if (this.y0 < this.datarect.y) {
            this.y0 = this.datarect.y;
        } else if (this.y0 > this.datarect.y + this.datarect.height) {
            this.y0 = this.datarect.y + this.datarect.height;
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.x1 = n;
        this.y1 = n2;
        if (this.drag) {
            this.userlimits = true;
        }
        this.drag = false;
        if (this.x1 < this.datarect.x) {
            this.x1 = this.datarect.x;
        } else if (this.x1 > this.datarect.x + this.datarect.width) {
            this.x1 = this.datarect.x + this.datarect.width;
        }
        if (this.y1 < this.datarect.y) {
            this.y1 = this.datarect.y;
        } else if (this.y1 > this.datarect.y + this.datarect.height) {
            this.y1 = this.datarect.y + this.datarect.height;
        }
        if (Math.abs(this.x0 - this.x1) > 5 && Math.abs(this.y0 - this.y1) > 5) {
            if (this.x0 < this.x1) {
                this.xaxis.minimum = this.xaxis.getDouble(this.x0);
                this.xaxis.maximum = this.xaxis.getDouble(this.x1);
            } else {
                this.xaxis.maximum = this.xaxis.getDouble(this.x0);
                this.xaxis.minimum = this.xaxis.getDouble(this.x1);
            }
            if (this.y0 > this.y1) {
                this.yaxis.minimum = this.yaxis.getDouble(this.y0);
                this.yaxis.maximum = this.yaxis.getDouble(this.y1);
            } else {
                this.yaxis.maximum = this.yaxis.getDouble(this.y0);
                this.yaxis.minimum = this.yaxis.getDouble(this.y1);
            }
            this.repaint();
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.x1 = n;
        this.y1 = n2;
        if (this.drag) {
            if (this.x1 < this.datarect.x) {
                this.x1 = this.datarect.x;
            } else if (this.x1 > this.datarect.x + this.datarect.width) {
                this.x1 = this.datarect.x + this.datarect.width;
            }
            if (this.y1 < this.datarect.y) {
                this.y1 = this.datarect.y;
            } else if (this.y1 > this.datarect.y + this.datarect.height) {
                this.y1 = this.datarect.y + this.datarect.height;
            }
        }
        if (this.cpgin != null && this.cpgin.isVisible()) {
            this.cpgin.setXlabel(this.xaxis.getDouble(this.x1));
            this.cpgin.setYlabel(this.yaxis.getDouble(this.y1));
        }
        this.repaint();
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.x1 = event.x;
        this.y1 = event.y;
        if (this.cpgin != null && this.cpgin.isVisible()) {
            this.cpgin.setXlabel(this.xaxis.getDouble(this.x1));
            this.cpgin.setYlabel(this.yaxis.getDouble(this.y1));
        }
        return true;
    }

    public boolean action(Event event, Object object) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        if (event.target instanceof Range && this.range != null) {
            double d = this.xaxis.minimum;
            double d2 = this.xaxis.maximum;
            double d3 = this.yaxis.minimum;
            double d4 = this.yaxis.maximum;
            Double d5 = this.range.getXmin();
            if (d5 != null) {
                d = d5;
            }
            if ((d5 = this.range.getXmax()) != null) {
                d2 = d5;
            }
            if ((d5 = this.range.getYmin()) != null) {
                d3 = d5;
            }
            if ((d5 = this.range.getYmax()) != null) {
                d4 = d5;
            }
            if (d2 > d && d4 > d3) {
                this.xaxis.minimum = d;
                this.xaxis.maximum = d2;
                this.yaxis.minimum = d3;
                this.yaxis.maximum = d4;
            }
            this.repaint();
            return true;
        }
        return false;
    }

    protected double[] getClosestPoint(int n, int n2) {
        double[] dArray = new double[3];
        double d = -1.0;
        double[] dArray2 = new double[]{0.0, 0.0};
        double d2 = this.xaxis.getDouble(n);
        double d3 = this.yaxis.getDouble(n2);
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(i);
            dArray = dataSet.getClosestPoint(d2, d3);
            if (!(d < 0.0) && !(d > dArray[2])) continue;
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            d = dArray[2];
        }
        return dArray2;
    }
}

