/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import Controller.StructureApp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ProjTree
implements ActionListener {
    private JTree projTree;
    private Vector simFolder;
    private StructureApp app;
    private String selectedSim;
    private JPopupMenu popup;
    private JMenuItem popup_active;
    private JMenuItem popup_load;

    public ProjTree(StructureApp structureApp) {
        this.app = structureApp;
        this.popup = new JPopupMenu();
        this.popup_active = new JMenuItem("Activate");
        this.popup_active.addActionListener(this);
        this.popup.add(this.popup_active);
    }

    public JTree getTree() {
        return this.projTree;
    }

    public void initProjTree() {
        RootNode rootNode = new RootNode(new String("Project (No Data Available)"));
        this.projTree = new JTree(rootNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(rootNode);
        this.projTree.getSelectionModel().setSelectionMode(1);
        this.projTree.putClientProperty("JTree.lineStyle", "Angled");
        defaultTreeModel.reload();
        this.projTree.addMouseListener(new PopupListener());
    }

    public void emptyProjTree() {
        RootNode rootNode = (RootNode)this.projTree.getModel().getRoot();
        this.projTree.scrollPathToVisible(new TreePath(rootNode.getPath()));
        rootNode.setUserObject(new String("Project (No Data Available)"));
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.projTree.getModel();
        for (int i = 3; i >= 0; --i) {
            defaultTreeModel.removeNodeFromParent((DefaultMutableTreeNode)this.projTree.getModel().getChild(rootNode, i));
        }
        defaultTreeModel.reload();
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        this.simFolder = null;
    }

    public void loadProjTree(String string, String[] stringArray) {
        this.projTree.addTreeSelectionListener(new ProjTreeListener());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new String("Project Information"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new String("Project Data"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new String("Simulation Summary"));
        RootNode rootNode = new RootNode(new String("Parameter Sets"));
        for (int i = 0; i < stringArray.length; ++i) {
            rootNode.add(this.createSimNode(stringArray[i], false));
        }
        RootNode rootNode2 = (RootNode)this.projTree.getModel().getRoot();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.projTree.getModel();
        rootNode2.setUserObject(new String("Project - " + string));
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, rootNode2, rootNode2.getChildCount());
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, rootNode2, rootNode2.getChildCount());
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, rootNode2, rootNode2.getChildCount());
        defaultTreeModel.insertNodeInto(rootNode, rootNode2, rootNode2.getChildCount());
        defaultTreeModel.reload();
        this.projTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
    }

    private DefaultMutableTreeNode createSimNode(String string, boolean bl) {
        String string2 = string;
        if (bl) {
            string2 = string2 + new String(" (Active) ");
        }
        if (this.simFolder == null) {
            this.simFolder = new Vector();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new String("Settings"));
        RootNode rootNode = new RootNode("Results");
        String[] stringArray = this.app.getRstFiles(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                rootNode.add(new DefaultMutableTreeNode(stringArray[i]));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(rootNode);
        this.simFolder.add(defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    public void resetSimNodeFlag(String[] stringArray) {
        if (this.simFolder == null) {
            return;
        }
        for (int i = 0; i < this.simFolder.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.simFolder.elementAt(i);
            defaultMutableTreeNode.setUserObject(stringArray[i]);
        }
    }

    public void appendProjTree(String string, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.createSimNode(string, bl);
        RootNode rootNode = (RootNode)this.projTree.getModel().getRoot();
        RootNode rootNode2 = (RootNode)this.projTree.getModel().getChild(rootNode, 3);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.projTree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, rootNode2, rootNode2.getChildCount());
        defaultTreeModel.reload(rootNode2);
        this.projTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void appendRstNode(String string, String string2, int n) {
        String string3 = string + " (Active)";
        for (int i = 0; i < this.simFolder.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.simFolder.elementAt(i);
            String string4 = (String)defaultMutableTreeNode.getUserObject();
            if (!string4.equals(string) && !string4.equals(string3)) continue;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.projTree.getModel();
            RootNode rootNode = (RootNode)defaultTreeModel.getChild(defaultMutableTreeNode, 1);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2 + " ( K=" + n + " )");
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, rootNode, rootNode.getChildCount());
            defaultTreeModel.reload(rootNode);
            this.projTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
            return;
        }
    }

    public void updateProjTree(String string) {
        for (int i = 0; i < this.simFolder.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.simFolder.elementAt(i);
            String string2 = (String)defaultMutableTreeNode.getUserObject();
            if (!string2.equals(string)) continue;
            defaultMutableTreeNode.setUserObject(string2 + " (Active)");
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.projTree.getModel();
            defaultTreeModel.reload();
            this.projTree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            return;
        }
    }

    public void removeSimNode(String string) {
        for (int i = 0; i < this.simFolder.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.simFolder.elementAt(i);
            String string2 = (String)defaultMutableTreeNode.getUserObject();
            if (!string2.equals(string)) continue;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.projTree.getModel();
            RootNode rootNode = (RootNode)this.projTree.getModel().getRoot();
            RootNode rootNode2 = (RootNode)this.projTree.getModel().getChild(rootNode, 3);
            defaultTreeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultTreeModel.getChild(rootNode2, i));
            defaultTreeModel.reload();
            this.simFolder.remove(i);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.selectedSim == null) {
            return;
        }
        this.app.loadSimObj(this.selectedSim);
        this.selectedSim = null;
    }

    class RootNode
    extends DefaultMutableTreeNode {
        public RootNode(Object object) {
            super(object);
        }

        public boolean isLeaf() {
            return false;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handle(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handle(mouseEvent);
        }

        private void handle(MouseEvent mouseEvent) {
            String string;
            TreePath treePath;
            DefaultMutableTreeNode defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2;
            int n;
            if ((mouseEvent.isPopupTrigger() || mouseEvent.getClickCount() == 2) && (n = ProjTree.this.projTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY())) != -1 && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)(treePath = ProjTree.this.projTree.getPathForRow(n)).getLastPathComponent()).getParent()) != null && (string = (String)defaultMutableTreeNode2.getUserObject()) != null && string.equals("Parameter Sets")) {
                String string2 = (String)defaultMutableTreeNode.getUserObject();
                if (string2.endsWith(" (Active)")) {
                    return;
                }
                ProjTree.this.selectedSim = string2;
                int n2 = ProjTree.this.app.getCurrState();
                if (n2 == 3 || n2 == 4) {
                    ProjTree.this.popup_active.setEnabled(false);
                } else {
                    ProjTree.this.popup_active.setEnabled(true);
                }
                if (mouseEvent.isPopupTrigger()) {
                    ProjTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    if (ProjTree.this.selectedSim == null) {
                        return;
                    }
                    ProjTree.this.app.loadSimObj(ProjTree.this.selectedSim);
                    ProjTree.this.selectedSim = null;
                    return;
                }
            }
        }
    }

    class ProjTreeListener
    implements TreeSelectionListener {
        ProjTreeListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            ProjTree.this.app.setCurrentSelection(null, null);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)ProjTree.this.projTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode2 == null) {
                return;
            }
            String string = (String)defaultMutableTreeNode2.getUserObject();
            if (string.equals("Project Information")) {
                ProjTree.this.app.loadDataFrame("proj", null);
                return;
            }
            if (string.equals("Project Data")) {
                ProjTree.this.app.loadDataFrame("data", null);
                return;
            }
            if (string.equals("Settings")) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                String string2 = (String)defaultMutableTreeNode3.getUserObject();
                int n = string2.indexOf(40);
                if (n >= 0) {
                    string2 = string2.substring(0, n - 1);
                }
                ProjTree.this.app.loadDataFrame("sim", string2);
                return;
            }
            if (string.equals("Simulation Summary")) {
                ProjTree.this.app.loadSummary();
            }
            if ((defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) == null) {
                return;
            }
            String string3 = (String)defaultMutableTreeNode.getUserObject();
            if (string3.equals("Results")) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                String string4 = (String)defaultMutableTreeNode4.getUserObject();
                if (string4.endsWith(" (Active)")) {
                    string4 = string4.substring(0, string4.length() - 9);
                }
                string = string.substring(0, string.indexOf(" ("));
                ProjTree.this.app.showResults(string4, string);
            }
        }
    }
}

