/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SchedulerDlg
extends JDialog
implements ActionListener {
    private String[] list;
    private int buttonHit;
    private JList simList;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField iterField;
    private JTextField fromKField;
    private JTextField toKField;
    private JTextField seedField;
    private JCheckBox seedBox;
    private int iteration;
    private int fromK;
    private int toK;
    private boolean requireSeed;
    private int seed;
    private DefaultListModel listModel;

    public SchedulerDlg(String[] stringArray) {
        this.setTitle("Structure Scheduler");
        this.setLocationRelativeTo(null);
        this.list = stringArray;
        this.simList = new JList<String>(stringArray);
        this.simList.setToolTipText("Hold 'Ctrl' to select multiple simulations");
        JScrollPane jScrollPane = new JScrollPane(this.simList);
        jScrollPane.setPreferredSize(new Dimension(300, 150));
        JPanel jPanel = new JPanel();
        jPanel.add((Component)jScrollPane, "Center");
        JLabel jLabel = new JLabel("Select Simulations to Run");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.setPreferredSize(new Dimension(400, 20));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jPanel, "Center");
        JLabel jLabel2 = new JLabel("Number of Iterations: ");
        this.iterField = new JTextField(3);
        this.iterField.setText("1");
        this.iteration = 1;
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jLabel2);
        jPanel4.add(this.iterField);
        JLabel jLabel3 = new JLabel("Set K from ");
        this.fromKField = new JTextField(3);
        JLabel jLabel4 = new JLabel(" to ");
        this.toKField = new JTextField(3);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jLabel3);
        jPanel5.add(this.fromKField);
        jPanel5.add(jLabel4);
        jPanel5.add(this.toKField);
        this.seedBox = new JCheckBox("Use sequential integer random seeds starting at  ");
        this.seedField = new JTextField(4);
        this.seedBox.setActionCommand("seed");
        this.seedBox.addActionListener(this);
        this.requireSeed = false;
        this.seedField.setEnabled(false);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.seedBox);
        jPanel6.add(this.seedField);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(0, 1));
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        jPanel7.add(jPanel4);
        this.okButton = new JButton("Start ");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel ");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.okButton);
        jPanel8.add(this.cancelButton);
        jPanel7.setPreferredSize(new Dimension(400, 90));
        jPanel8.setPreferredSize(new Dimension(400, 50));
        this.getContentPane().add("North", jPanel3);
        this.getContentPane().add("Center", jPanel7);
        this.getContentPane().add("South", jPanel8);
    }

    private boolean validateInput() {
        int[] nArray = this.simList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            JOptionPane.showMessageDialog(null, "Please select at least one simulation to run", "Error", 0);
            return false;
        }
        String string = this.iterField.getText();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Interation number must be an Integer", "Error", 0);
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(null, "Interation number must be greater than 0", "Error", 0);
            return false;
        }
        this.iteration = n;
        string = this.fromKField.getText();
        n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "K must be an Integer", "Error", 0);
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(null, "K must be greater than 0", "Error", 0);
            return false;
        }
        this.fromK = n;
        string = this.toKField.getText();
        n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "K must be an Integer", "Error", 0);
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(null, "K must be greater than 0", "Error", 0);
            return false;
        }
        if (n < this.fromK) {
            JOptionPane.showMessageDialog(null, "Invalid Range for K: from " + this.fromK + " to " + n, "Error", 0);
            return false;
        }
        this.toK = n;
        if (this.requireSeed) {
            String string2 = this.seedField.getText();
            try {
                this.seed = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Random seed input is invalid", "Error", 0);
                return false;
            }
        }
        return true;
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            if (this.validateInput()) {
                this.buttonHit = 0;
                this.setVisible(false);
                return;
            }
            return;
        }
        if (string.equals("cancel")) {
            this.buttonHit = 2;
            this.setVisible(false);
            return;
        }
        if (string.equals("seed")) {
            this.requireSeed = !this.requireSeed;
            this.seedField.setEnabled(this.requireSeed);
        }
    }

    public int getIterationNum() {
        return this.iteration;
    }

    public int getFromK() {
        return this.fromK;
    }

    public int getToK() {
        return this.toK;
    }

    public boolean isSeedRequired() {
        return this.requireSeed;
    }

    public int getSeed() {
        return this.seed;
    }

    public String[] getSelectedList() {
        int[] nArray = this.simList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.list[nArray[i]];
        }
        return stringArray;
    }
}

