/*
 * Decompiled with CFR 0.152.
 */
package Triangle;

import Controller.StructureApp;
import Triangle.ColorRenderer;
import Triangle.DataParser;
import Triangle.TriPlotFm;
import Triangle.TrianglePlot;
import Util.GeneralFileFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TrianglePlotManager
implements ActionListener {
    private StructureApp app;
    private String datafile;
    private TrianglePlot tplot;
    private DataParser parser;
    private TriPlotFm frame;
    private int popsize;
    private JComboBox[] palettelist;
    private Hashtable colormap;
    private Vector idVec;
    private int leftindex;
    private int rightindex;
    private double[][] data;
    private int[] id;
    private File[] runlist;
    private String[] simlist;
    private Color[] colorlist;
    private int simlist_select;
    private int filelist_select;
    private int bleft_select;
    private int bright_select;

    public TrianglePlotManager(StructureApp structureApp, String[] stringArray) {
        this.app = structureApp;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.simlist = new String[stringArray.length + 1];
        this.simlist[0] = "Select one";
        for (int i = 0; i < stringArray.length; ++i) {
            this.simlist[i + 1] = stringArray[i];
        }
    }

    public TrianglePlotManager() {
    }

    public void showFrame(String string, String string2) {
        this.frame = new TriPlotFm(this);
        this.tplot = new TrianglePlot();
        File file = new File(string2);
        this.frame.initState(string, file.getName());
        this.frame.setTitle("Triangle Plot - Structure");
        if (!this.parseFile(string2)) {
            return;
        }
        if (this.frame.v1list.getItemCount() >= 3) {
            this.frame.v1list.setSelectedIndex(1);
            this.leftindex = 1;
            this.bleft_select = 1;
            this.frame.v2list.setSelectedIndex(2);
            this.rightindex = 2;
            this.bright_select = 2;
            this.updatePlot();
        }
        this.frame.setLocation(300, 200);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void showFrame() {
        this.frame = new TriPlotFm(this);
        this.tplot = new TrianglePlot();
        this.frame.initState(this.simlist);
        this.frame.setTitle("Triangle Plot - Structure");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public JScrollPane createPalette() {
        int n;
        this.palettelist = new JComboBox[this.popsize];
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        Object[] objectArray = new Object[this.popsize];
        for (n = 0; n < this.popsize; ++n) {
            objectArray[n] = new Object[]{this.colorlist[n]};
        }
        for (n = 0; n < this.popsize; ++n) {
            String string = this.popsize == 1 ? "" : new String("Pop " + this.idVec.elementAt(n));
            JLabel jLabel = new JLabel(string);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jLabel);
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
            jComboBox.setRenderer(new ColorRenderer());
            jComboBox.setSelectedIndex(n);
            jComboBox.setActionCommand("mcolor" + n);
            jComboBox.addActionListener(this);
            this.palettelist[n] = jComboBox;
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jComboBox);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            jPanel.add(jPanel4);
        }
        jPanel.setPreferredSize(new Dimension(250, 40 * this.popsize));
        return new JScrollPane(jPanel);
    }

    public boolean parseFile(String string) {
        int n;
        this.parser = new DataParser(string);
        int n2 = this.parser.getK();
        this.data = this.parser.getData();
        if (this.data == null) {
            JOptionPane.showMessageDialog(null, "Data file is not in expected format", "Error", 0);
            return false;
        }
        this.id = this.parser.getId();
        this.frame.v1list.removeActionListener(this);
        this.frame.v2list.removeActionListener(this);
        this.frame.v1list.setEnabled(true);
        this.frame.v1list.removeAllItems();
        this.frame.v1list.addItem("Select one");
        this.frame.v2list.setEnabled(true);
        this.frame.v2list.removeAllItems();
        this.frame.v2list.addItem("Select one");
        for (int i = 0; i < n2; ++i) {
            this.frame.v1list.addItem("cluster " + (i + 1));
            this.frame.v2list.addItem("cluster " + (i + 1));
        }
        this.frame.v1list.addActionListener(this);
        this.frame.v2list.addActionListener(this);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        this.idVec = new Vector();
        if (this.id != null) {
            for (n = 0; n < this.id.length; ++n) {
                Integer n3 = new Integer(this.id[n]);
                if (hashtable.containsKey(n3)) continue;
                hashtable.put(n3, new Integer(1));
                this.idVec.add(n3);
            }
            this.popsize = hashtable.size();
        } else {
            this.popsize = 1;
        }
        this.colorlist = new Color[this.popsize];
        for (n = 0; n < this.popsize; ++n) {
            this.colorlist[n] = null;
        }
        for (n = 0; n < this.popsize; ++n) {
            if (n == 0) {
                this.colorlist[n] = new Color(1.0f, 0.0f, 0.0f);
            }
            if (n == 1) {
                this.colorlist[n] = new Color(0.0f, 1.0f, 0.0f);
            }
            if (n == 2) {
                this.colorlist[n] = new Color(0.0f, 0.0f, 1.0f);
            }
            if (n == 3) {
                this.colorlist[n] = new Color(1.0f, 1.0f, 0.0f);
            }
            if (n == 4) {
                this.colorlist[n] = new Color(1.0f, 0.0f, 1.0f);
            }
            if (n == 5) {
                this.colorlist[n] = new Color(0.0f, 1.0f, 1.0f);
            }
            if (n == 6) {
                this.colorlist[n] = new Color(0.98f, 0.6f, 0.0f);
            }
            if (n == 7) {
                this.colorlist[n] = new Color(0.5f, 0.25f, 0.37f);
            }
            if (n == 8) {
                this.colorlist[n] = new Color(0.98f, 0.6f, 0.37f);
            }
            if (n == 9) {
                this.colorlist[n] = new Color(0.1f, 0.6f, 0.75f);
            }
            if (n <= 9) continue;
            this.colorlist[n] = this.randomize_color();
        }
        this.colormap = new Hashtable();
        if (this.popsize > 1) {
            Collections.sort(this.idVec);
            for (n = 0; n < this.idVec.size(); ++n) {
                this.colormap.put(this.idVec.elementAt(n), this.colorlist[n]);
            }
        } else {
            this.colormap.put(new Integer(0), this.colorlist[0]);
        }
        this.frame.updateGui(this.createPalette());
        return true;
    }

    public void setRunList(String string) {
        this.runlist = this.app.getRunFiles(string);
        this.frame.rlist.removeActionListener(this);
        this.frame.rlist.setEnabled(true);
        this.frame.rlist.removeAllItems();
        this.frame.rlist.addItem("Select one");
        if (this.runlist == null || this.runlist.length == 0) {
            this.frame.rlist.setEnabled(false);
            return;
        }
        for (int i = 0; i < this.runlist.length; ++i) {
            String string2 = this.runlist[i].getName();
            this.frame.rlist.addItem(string2.substring(0, string2.length() - 2));
        }
        this.frame.rlist.addActionListener(this);
    }

    private Color randomize_color() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Random random = new Random();
        while (this.exist_in_colormap(f = random.nextFloat(), f2 = random.nextFloat(), f3 = random.nextFloat())) {
        }
        return new Color(f, f2, f3);
    }

    private boolean exist_in_colormap(float f, float f2, float f3) {
        for (int i = 0; i < this.colorlist.length; ++i) {
            float f4;
            float f5;
            if (this.colorlist[i] == null) {
                return false;
            }
            float f6 = (float)this.colorlist[i].getRed() / 255.0f;
            float f7 = (f6 - f) * (f6 - f) + ((f5 = (float)this.colorlist[i].getGreen() / 255.0f) - f2) * (f5 - f2) + ((f4 = (float)this.colorlist[i].getBlue() / 255.0f) - f3) * (f4 - f3);
            if (!((double)f7 <= 0.02)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals("simlist")) {
            int n2 = this.frame.plist.getSelectedIndex();
            if (n2 == 0) {
                this.frame.plist.setSelectedIndex(this.simlist_select);
                return;
            }
            this.simlist_select = n2;
            this.frame.plist.setSelectedIndex(n2);
            this.setRunList(this.simlist[n2]);
            this.frame.resetGui();
            this.tplot.resetData();
            this.tplot.repaint();
            return;
        }
        if (string.equals("filelist")) {
            n = this.frame.rlist.getSelectedIndex();
            if (n == 0) {
                this.frame.rlist.setSelectedIndex(this.filelist_select);
                return;
            }
            this.filelist_select = n;
            this.resetAll();
            this.parseFile(this.runlist[n - 1].getAbsolutePath());
            if (this.frame.v1list.getItemCount() >= 3) {
                this.frame.v1list.setSelectedIndex(1);
                this.leftindex = 1;
                this.bleft_select = 1;
                this.frame.v2list.setSelectedIndex(2);
                this.rightindex = 2;
                this.bright_select = 2;
                this.updatePlot();
            }
        }
        if (string.equals("bottomleft")) {
            n = this.frame.v1list.getSelectedIndex();
            if (n == 0) {
                this.frame.v1list.setSelectedIndex(this.bleft_select);
                return;
            }
            this.leftindex = n;
            if (!this.updatePlot()) {
                this.frame.v1list.setSelectedIndex(this.bleft_select);
                this.leftindex = this.bleft_select;
            } else {
                this.bleft_select = this.leftindex;
            }
            return;
        }
        if (string.equals("bottomright")) {
            n = this.frame.v2list.getSelectedIndex();
            if (n == 0) {
                this.frame.v2list.setSelectedIndex(this.bright_select);
                return;
            }
            this.rightindex = n;
            if (!this.updatePlot()) {
                this.frame.v2list.setSelectedIndex(this.bright_select);
                this.rightindex = this.bright_select;
            } else {
                this.bright_select = this.rightindex;
            }
            return;
        }
        if (string.equals("save")) {
            JFileChooser jFileChooser = new JFileChooser();
            GeneralFileFilter generalFileFilter = new GeneralFileFilter("jpg", "JPEG image files");
            jFileChooser.addChoosableFileFilter(generalFileFilter);
            int n3 = jFileChooser.showDialog(this.frame, "Save");
            if (n3 == 0) {
                Object[] objectArray;
                File file = jFileChooser.getSelectedFile();
                String string2 = file.getAbsolutePath();
                if (!string2.endsWith(".jpg") && !string2.endsWith(".jpeg")) {
                    file = new File(new String(string2 + ".jpg"));
                }
                if (file.exists()) {
                    objectArray = new Object[]{"Yes", "No "};
                    int n4 = JOptionPane.showOptionDialog(this.frame, "Target file " + file.getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                    if (n4 == 1) {
                        return;
                    }
                }
                if (!(objectArray = file.getParentFile()).canWrite()) {
                    JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                    return;
                }
                this.tplot.saveImage(file.getAbsolutePath());
            }
        }
        if (string.equals("close")) {
            this.frame.dispose();
        }
        if (string.startsWith("mcolor")) {
            for (int i = 0; i < this.popsize; ++i) {
                if (!string.equals(new String("mcolor" + i))) continue;
                int n5 = this.palettelist[i].getSelectedIndex();
                if (this.popsize <= 1) {
                    this.colormap.put(new Integer(0), this.colorlist[n5]);
                } else {
                    this.colormap.put(this.idVec.elementAt(i), this.colorlist[n5]);
                }
                this.updatePlot();
                return;
            }
        }
    }

    private boolean updatePlot() {
        if (this.rightindex == 0 || this.leftindex == 0) {
            return true;
        }
        if (this.rightindex == this.leftindex) {
            return false;
        }
        this.tplot.loadData(this.data, this.id, this.colormap, this.leftindex, this.rightindex);
        this.tplot.repaint();
        this.frame.updatePlot(this.tplot);
        return true;
    }

    private void resetAll() {
        this.palettelist = null;
        this.colormap = null;
        this.rightindex = 0;
        this.leftindex = 0;
        this.data = null;
        this.id = null;
        this.tplot.resetData();
        this.tplot.repaint();
    }
}

