/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.psd;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.psd.EncodeImageIfc;
import com.sun.jimi.core.encoder.psd.PSDColorMode;
import com.sun.jimi.core.encoder.psd.PSDFileHeader;
import com.sun.jimi.util.ArrayEnumeration;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class PSDEncoder
extends JimiEncoderBase
implements OptionsObject {
    private OutputStream out_;
    private DataOutputStream dOut_;
    private int state_;
    static final int NO_COMPRESSION = 0;
    static final int RLE_COMPRESSION = 1;
    static final int DEFAULT_COMPRESSION = 0;
    int compression_ = 0;
    static final String COMPRESSION_OPTION_NAME = "compression";
    static final String NO_COMPRESSION_OPTION = "none";
    static final String RLE_COMPRESSION_OPTION = "rle";
    static final String[] POSSIBLE_COMPRESSION_OPTIONS = new String[]{"none", "rle"};
    static final String[] PROPERTY_NAMES = new String[]{"compression"};

    public void clearProperties() {
        this.compression_ = 0;
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            this.encodePSD(adaptiveRasterImage, this.dOut_);
            this.state_ |= 2;
            this.dOut_.flush();
            this.dOut_.close();
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.getMessage());
        }
        return false;
    }

    public void encodePSD(AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        PSDFileHeader pSDFileHeader = new PSDFileHeader(this, adaptiveRasterImage, dataOutputStream);
        pSDFileHeader.write();
        PSDColorMode pSDColorMode = new PSDColorMode(adaptiveRasterImage, dataOutputStream);
        pSDColorMode.write();
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        EncodeImageIfc encodeImageIfc = pSDFileHeader.createEncodeImage();
        encodeImageIfc.encodeImage(adaptiveRasterImage, dataOutputStream, this.compression_);
    }

    public void freeEncoder() throws JimiException {
        this.out_ = null;
        this.dOut_ = null;
        super.freeEncoder();
    }

    public OptionsObject getOptionsObject() {
        return this;
    }

    public Object getPossibleValuesForProperty(String string) throws InvalidOptionException {
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return POSSIBLE_COMPRESSION_OPTIONS;
        }
        throw new InvalidOptionException("No such option");
    }

    public Object getProperty(String string) {
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            if (this.compression_ == 0) {
                return NO_COMPRESSION_OPTION;
            }
            return RLE_COMPRESSION_OPTION;
        }
        return null;
    }

    public String getPropertyDescription(String string) throws InvalidOptionException {
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return "RLE compression tends to be smaller than not using compression";
        }
        throw new InvalidOptionException("No such option");
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(PROPERTY_NAMES);
    }

    public int getState() {
        return this.state_;
    }

    protected void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.out_ = outputStream;
        this.dOut_ = new DataOutputStream(outputStream);
        this.state_ = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws InvalidOptionException {
        if (!string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) throw new InvalidOptionException("No such option");
        String string2 = object.toString();
        if (string2.equalsIgnoreCase(NO_COMPRESSION_OPTION)) {
            this.compression_ = 0;
            return;
        } else {
            if (!string2.equalsIgnoreCase(RLE_COMPRESSION_OPTION)) throw new InvalidOptionException("Not a valid value");
            this.compression_ = 1;
        }
    }
}

