/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.util.xml.HasXMLRepresentation;
import jas.util.xml.XMLWriter;
import java.util.Observable;

public class Gauss
extends Observable
implements Rebinnable1DHistogramData,
HasStyle,
HasStatistics,
HasXMLRepresentation {
    double[] m_tuple;
    int m_entries;
    double m_max;
    double m_min;
    double m_offset;
    String m_name;
    protected static final int MAXSIZE = 10000;
    private JASHist1DHistogramStyle style;
    private Statistics stats = new GaussStatistics();
    private Statistics paulstats = new PaulStatistics();
    private static final String[] statNames = new String[]{"Entries", "Mean", "RMS"};
    private static final String[] statNames2 = new String[]{"Entries", "Mean", "RMS", "10Entries"};

    public Gauss() {
        this("Gaussian", 1000, 1.0, 0.0, 0.0);
    }

    public void writeAsXML(XMLWriter xMLWriter) {
        xMLWriter.println("<datasource name=\"" + this.getClass().getName() + "\">");
        xMLWriter.println("<param type=\"String\" value=\"" + this.m_name + "\"/>");
        xMLWriter.println("<param type=\"int\" value=\"" + this.m_entries + "\"/>");
        xMLWriter.println("<param type=\"double\" value=\"" + (this.m_max - this.m_min) + "\"/>");
        xMLWriter.println("<param type=\"double\" value=\"" + this.m_min + "\"/>");
        xMLWriter.println("<param type=\"double\" value=\"" + this.m_offset + "\"/>");
        xMLWriter.println("</datasource>");
    }

    public Gauss(String string, int n, double d, double d2, double d3) {
        if (n > 10000) {
            throw new IllegalArgumentException("Gauss: Size too big");
        }
        this.m_tuple = new double[10000];
        this.m_entries = n;
        this.m_min = d2;
        this.m_max = d2 + d;
        this.m_offset = d3;
        this.m_name = string;
        int n2 = 0;
        while (n2 < 10000) {
            double d4 = Math.random() + Math.random() + Math.random() + Math.random() + Math.random() + Math.random();
            this.m_tuple[n2] = d4 = d2 + d * d4 / 6.0;
            ++n2;
        }
    }

    public void setStyle(JASHist1DHistogramStyle jASHist1DHistogramStyle) {
        this.style = jASHist1DHistogramStyle;
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.m_name;
    }

    public double getMin() {
        return this.m_min;
    }

    public double getMax() {
        return this.m_max;
    }

    public boolean isRebinnable() {
        return true;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public int getBins() {
        return 40;
    }

    public int getAxisType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        Gauss gauss = this;
        synchronized (gauss) {
            this.setChanged();
        }
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.m_offset;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.m_entries) {
            int n4;
            double d4 = this.m_tuple[n3];
            if (!(d4 < d) && (n4 = (int)((d4 - d) / d3)) < n) {
                int n5 = n4;
                dArray[n5] = dArray[n5] + 1.0;
            }
            ++n3;
        }
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public int getSize() {
        return this.m_entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int n) {
        if (n > 10000) {
            throw new IllegalArgumentException("Gauss: Size too big");
        }
        this.m_entries = n;
        Gauss gauss = this;
        synchronized (gauss) {
            this.notifyObservers(new HistogramUpdate(2, true));
        }
    }

    public double getData(int n) {
        return this.m_tuple[n];
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public void setStats() {
        this.stats = this.paulstats;
    }

    public class PaulStatistics
    implements Statistics {
        public String[] getStatisticNames() {
            return statNames2;
        }

        public double getStatistic(String string) {
            if (string == statNames2[0]) {
                return Gauss.this.m_entries;
            }
            if (string == statNames2[1]) {
                return (Gauss.this.m_max + Gauss.this.m_min) / 2.0;
            }
            if (string == statNames2[2]) {
                return Gauss.this.m_max - Gauss.this.m_min;
            }
            if (string == statNames2[3]) {
                return Gauss.this.m_entries * 10;
            }
            return 0.0;
        }
    }

    private class GaussStatistics
    implements Statistics {
        private GaussStatistics() {
        }

        public String[] getStatisticNames() {
            return statNames;
        }

        public double getStatistic(String string) {
            if (string == statNames[0]) {
                return Gauss.this.m_entries;
            }
            if (string == statNames[1]) {
                return (Gauss.this.m_max + Gauss.this.m_min) / 2.0;
            }
            if (string == statNames[2]) {
                return Gauss.this.m_max - Gauss.this.m_min;
            }
            return 0.0;
        }
    }
}

