/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.util;

import java.util.Observable;
import java.util.Observer;

public class ObserverAdapter
extends Observable
implements Observer {
    private Observable obs;
    private boolean observing = false;

    public ObserverAdapter(Observable observable) {
        this.obs = observable;
    }

    public ObserverAdapter() {
    }

    public synchronized void setObservable(Observable observable) {
        if (this.observing && this.obs != null) {
            this.obs.deleteObserver(this);
        }
        this.obs = observable;
        if (this.observing && this.obs != null) {
            this.obs.addObserver(this);
        }
    }

    public synchronized void clearObservable() {
        this.setObservable(null);
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    private void observe(boolean bl) {
        if (bl != this.observing) {
            if (this.obs != null) {
                if (bl) {
                    this.obs.addObserver(this);
                } else {
                    this.obs.deleteObserver(this);
                }
            }
            this.observing = bl;
        }
    }

    public synchronized void addObserver(Observer observer) {
        super.addObserver(observer);
        this.observe(true);
    }

    public synchronized void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        if (this.countObservers() == 0) {
            this.observe(false);
        }
    }

    public synchronized void deleteObservers() {
        super.deleteObservers();
        this.observe(false);
    }
}

