/*
 * Decompiled with CFR 0.152.
 */
package Controller;

import Controller.RunData;
import Controller.SimData;
import Obj.NProjObj;
import Obj.NSimObj;
import Obj.ObjIO;
import Util.InFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class SummaryGenerator {
    private NProjObj proj;
    private String workingPath;
    private String[] simList;
    private String[][] tableData;
    private String[] header;
    private JInternalFrame currFrame;
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SummaryGenerator.this.saveSummary();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public SummaryGenerator(NProjObj nProjObj) {
        int n;
        this.proj = nProjObj;
        this.workingPath = nProjObj.getWorkingPath();
        this.simList = nProjObj.getSimList();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.simList.length; ++n) {
            if (ObjIO.loadSimObj(nProjObj, this.simList[n]) == null) continue;
            vector.addElement(this.simList[n]);
        }
        this.simList = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.simList[n] = (String)vector.elementAt(n);
        }
    }

    public JInternalFrame getSummary() {
        Object[] objectArray;
        int n;
        int n2;
        if (this.simList == null || this.simList.length == 0) {
            return null;
        }
        SimData[] simDataArray = new SimData[this.simList.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.simList.length; ++n2) {
            simDataArray[n2] = this.getSimSummary(ObjIO.loadSimObj(this.proj, this.simList[n2]));
            simDataArray[n2].simName = this.simList[n2];
            simDataArray[n2].sortData();
            n5 += simDataArray[n2].data.length;
            if (simDataArray[n2].alphacol > n3) {
                n3 = simDataArray[n2].alphacol;
            }
            if (simDataArray[n2].fstcol <= n4) continue;
            n4 = simDataArray[n2].fstcol;
        }
        this.tableData = new String[n5 += this.simList.length][];
        n2 = 0;
        for (n = 0; n < this.simList.length; ++n) {
            for (int i = 0; i < simDataArray[n].data.length; ++i) {
                this.tableData[n2++] = simDataArray[n].data[i].getStringArray(n3, n4);
            }
            objectArray = new String[n3 + n4 + 5];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[n] = new String();
            }
            this.tableData[n2++] = objectArray;
        }
        this.header = new String[5 + n3 + n4];
        this.header[0] = "Parameter Set";
        this.header[1] = "Run Name";
        this.header[2] = "K";
        this.header[3] = "Ln P(D)";
        this.header[4] = "Var[LnP(D)]";
        for (n = 0; n < n3; ++n) {
            this.header[n + 5] = " \u03b1" + (n + 1);
        }
        for (n = 0; n < n4; ++n) {
            this.header[n + 5 + n3] = "Fst_" + (n + 1);
        }
        final Object[][] objectArray2 = this.tableData;
        objectArray = this.header;
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 5;
            }

            public int getRowCount() {
                return objectArray2.length;
            }

            public String getColumnName(int n) {
                return (String)objectArray[n];
            }

            public Object getValueAt(int n, int n2) {
                return objectArray2[n][n2];
            }
        };
        AbstractTableModel abstractTableModel2 = new AbstractTableModel(){

            public int getColumnCount() {
                return objectArray.length - 5;
            }

            public int getRowCount() {
                return objectArray2.length;
            }

            public String getColumnName(int n) {
                return (String)objectArray[n + 5];
            }

            public Object getValueAt(int n, int n2) {
                return objectArray2[n][n2 + 5];
            }

            public void setValueAt(Object object, int n, int n2) {
                objectArray2[n][n2 + 5] = object;
            }

            public boolean CellEditable(int n, int n2) {
                return true;
            }
        };
        JTable jTable = new JTable(abstractTableModel);
        JTable jTable2 = new JTable(abstractTableModel2);
        jTable.setAutoResizeMode(0);
        jTable2.setAutoResizeMode(0);
        jTable.setSelectionMode(0);
        jTable2.setSelectionMode(0);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        tableColumnModel.getColumn(2).setPreferredWidth(30);
        JScrollPane jScrollPane = new JScrollPane(jTable2);
        JViewport jViewport = new JViewport();
        jViewport.setView(jTable);
        jViewport.setPreferredSize(jTable.getPreferredSize());
        jScrollPane.setRowHeaderView(jViewport);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jTable.getTableHeader());
        JLabel jLabel = new JLabel("  Summary of Simulations");
        JPanel jPanel = new JPanel();
        jPanel.add((Component)jLabel, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("save as text file ...");
        jMenuItem.addActionListener(this.listener);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jPanel.setPreferredSize(new Dimension(400, 30));
        JInternalFrame jInternalFrame = new JInternalFrame("", true, true, true, true);
        jInternalFrame.setJMenuBar(jMenuBar);
        this.currFrame = jInternalFrame;
        jInternalFrame.getContentPane().add((Component)jPanel, "North");
        jInternalFrame.getContentPane().add((Component)jScrollPane, "Center");
        return jInternalFrame;
    }

    private void saveSummary() {
        int n;
        Object[] objectArray;
        File file;
        if (this.tableData == null || this.header == null) {
            return;
        }
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        int n2 = jFileChooser.showDialog(this.currFrame, "Save");
        if (n2 == 0) {
            file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                objectArray = new Object[]{"Yes", "No "};
                n = JOptionPane.showOptionDialog(this.currFrame, "Target file " + file.getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                if (n == 1) {
                    return;
                }
            }
            if (!(objectArray = file.getParentFile()).canWrite()) {
                JOptionPane.showMessageDialog(this.currFrame, "Can not write image file: permission denied", "Error", 0);
                return;
            }
            string = file.getAbsolutePath();
        }
        file = new File(string);
        objectArray = SummaryGenerator.OpenOutputFile(file);
        for (n = 0; n < this.header.length; ++n) {
            objectArray.print("" + this.header[n] + "   ");
        }
        objectArray.println("\n");
        for (n = 0; n < this.tableData.length; ++n) {
            if (this.tableData[n][this.tableData[n].length - 1] == null) {
                objectArray.print("\n");
                continue;
            }
            for (int i = 0; i < this.tableData[n].length; ++i) {
                objectArray.print("" + this.tableData[n][i] + "  ");
            }
            objectArray.print("\n");
        }
    }

    private static PrintStream OpenOutputFile(File file) {
        PrintStream printStream;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open output file.");
            printStream = null;
        }
        catch (SecurityException securityException) {
            System.err.println("**Error: no permission to write output file.");
            printStream = null;
        }
        catch (IOException iOException) {
            System.err.println("**Error: unknown error opening output file.");
            printStream = null;
        }
        return printStream;
    }

    private SimData getSimSummary(NSimObj nSimObj) {
        String string = nSimObj.getSimName();
        int n = nSimObj.BURNIN;
        int n2 = nSimObj.NUMREPS;
        String string2 = new String();
        String string3 = new String();
        string2 = nSimObj.USEPOPINFO ? "USEPOPINFO" : (nSimObj.RECOMBINE ? "RECOMBINE" : (!nSimObj.NOADMIX ? "ADMIXTURE" : "NO ADMIXTURE"));
        string3 = nSimObj.FREQSCORR ? "FREQ CORRELATE" : (nSimObj.INFERLAMBDA ? "INFERLAMBDA" : "FREQ INDEPENDENT");
        File file = new File(this.workingPath, nSimObj.getSimName());
        File file2 = new File(file.getAbsolutePath(), "Results");
        File[] fileArray = file2.listFiles();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string4 = fileArray[i].getName();
            if (!string4.endsWith("_f")) continue;
            vector.addElement(fileArray[i]);
        }
        RunData[] runDataArray = new RunData[vector.size()];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            runDataArray[i] = this.readFile((File)vector.elementAt(i));
            runDataArray[i].modelname = nSimObj.getSimName();
            int n5 = runDataArray[i].alpha.size();
            int n6 = runDataArray[i].fst.size();
            if (n5 > n3) {
                n3 = runDataArray[i].alpha.size();
            }
            if (n6 <= n4) continue;
            n4 = n6;
        }
        SimData simData = new SimData();
        simData.alphacol = n3;
        simData.fstcol = n4;
        simData.data = runDataArray;
        return simData;
    }

    private RunData readFile(File file) {
        RunData runData = new RunData();
        String string = file.getName();
        runData.name = string.substring(0, string.length() - 2);
        InFile inFile = null;
        try {
            inFile = new InFile(file.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        String string2 = "";
        StringTokenizer stringTokenizer = null;
        while (true) {
            try {
                string2 = inFile.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) break;
            String string3 = null;
            if (string2.startsWith("Estimated Ln Prob of Data")) {
                stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                runData.lnpd = string3;
                continue;
            }
            if (string2.startsWith("Variance of ln likelihood")) {
                stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                runData.varld = string3;
                continue;
            }
            if (string2.startsWith("Mean value of alpha")) {
                stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                runData.alpha.addElement(string3);
                continue;
            }
            if (string2.startsWith("Mean value of Fst")) {
                stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                runData.fst.addElement(string3);
                continue;
            }
            if (!string2.endsWith("populations assumed")) continue;
            stringTokenizer = new StringTokenizer(string2);
            String string4 = stringTokenizer.nextToken();
            try {
                runData.K = Integer.parseInt(string4);
            }
            catch (Exception exception) {}
        }
        return runData;
    }
}

