/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

class RotateTextFilter
extends ImageFilter {
    private int angle = 0;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private int width;
    private int height;
    private double cos = 1.0;
    private double sin = 0.0;
    private int[] ipixels;
    private byte[] bpixels;
    private ColorModel colorModel;

    public RotateTextFilter(int n) {
        this.angle = n % 360 / 90 * 90;
        this.cos = Math.cos((double)n * Math.PI / 180.0);
        this.sin = Math.sin((double)n * Math.PI / 180.0);
    }

    public void setProperties(Hashtable hashtable) {
        hashtable = (Hashtable)hashtable.clone();
        hashtable.put("rotAngle", new Integer(this.angle));
        super.setProperties(hashtable);
    }

    public void setDimensions(int n, int n2) {
        int[] nArray = new int[]{0, n - 1, n - 1, 0};
        int[] nArray2 = new int[]{0, 0, n2 - 1, n2 - 1};
        for (int i = 0; i < 4; ++i) {
            int n3 = (int)Math.round((double)nArray[i] * this.cos + (double)nArray2[i] * this.sin);
            int n4 = (int)Math.round((double)(-nArray[i]) * this.sin + (double)nArray2[i] * this.cos);
            this.xmin = Math.min(this.xmin, n3);
            this.xmax = Math.max(this.xmax, n3);
            this.ymin = Math.min(this.ymin, n4);
            this.ymax = Math.max(this.ymax, n4);
        }
        this.width = this.xmax - this.xmin + 1;
        this.height = this.ymax - this.ymin + 1;
        this.consumer.setDimensions(this.width, this.height);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.bpixels == null) {
            this.colorModel = colorModel;
            this.bpixels = new byte[this.width * this.height];
        }
        int n7 = n2;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = (int)Math.round((double)n9 * this.cos + (double)n7 * this.sin) - this.xmin;
                int n12 = (int)Math.round((double)(-n9) * this.sin + (double)n7 * this.cos) - this.ymin;
                int n13 = n11 + n12 * this.width;
                this.bpixels[n13] = byArray[(n7 - n2) * n6 + (n9 - n) + n5];
                ++n10;
                ++n9;
            }
            ++n8;
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.ipixels == null) {
            this.colorModel = colorModel;
            this.ipixels = new int[this.width * this.height];
        }
        int n7 = n2;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = (int)Math.round((double)n9 * this.cos + (double)n7 * this.sin) - this.xmin;
                int n12 = (int)Math.round((double)(-n9) * this.sin + (double)n7 * this.cos) - this.ymin;
                int n13 = n11 + n12 * this.width;
                this.ipixels[n13] = nArray[(n7 - n2) * n6 + (n9 - n) + n5];
                ++n10;
                ++n9;
            }
            ++n8;
            ++n7;
        }
    }

    public void imageComplete(int n) {
        if (n == 4 || n == 1) {
            this.consumer.imageComplete(n);
            this.ipixels = null;
            this.bpixels = null;
            return;
        }
        if (this.bpixels != null) {
            for (int i = 0; i < this.height; ++i) {
                this.consumer.setPixels(0, i, this.width, 1, this.colorModel, this.bpixels, i * this.width, this.width);
            }
            this.consumer.imageComplete(n);
        } else if (this.ipixels != null) {
            for (int i = 0; i < this.height; ++i) {
                this.consumer.setPixels(0, i, this.width, 1, this.colorModel, this.ipixels, i * this.width, this.width);
            }
            this.consumer.imageComplete(n);
        } else {
            this.consumer.imageComplete(4);
        }
        this.ipixels = null;
        this.bpixels = null;
    }
}

