/*
 * Decompiled with CFR 0.152.
 */
package Gui.Param;

import Obj.NProjObj;
import Obj.NSimObj;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RecombineDlg
extends JDialog
implements ActionListener {
    private int buttonHit;
    JTextField rstartField;
    JTextField rstepField;
    JTextField rmaxField;
    JTextField rminField;
    JTextField rstdField;
    JCheckBox noqsBox;
    JCheckBox markovBox;
    JRadioButton defaultburninBox;
    JRadioButton specifyburninBox;
    JTextField burninField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton defaultButton;
    private float rstart = -2.0f;
    private float rstep;
    private float rmax = 2.0f;
    private float rmin = -4.0f;
    private float rstd = 0.1f;
    private boolean sitebysite;
    private boolean markovphase;
    private boolean defaultburnin = true;
    private int admburnin;
    private NSimObj sim;

    public RecombineDlg(Component component, NSimObj nSimObj, boolean bl) {
        this.sim = nSimObj;
        JLabel jLabel = new JLabel("      LOG10(RMIN):");
        JLabel jLabel2 = new JLabel("      LOG10(RMAX):");
        JLabel jLabel3 = new JLabel("      LOG10(RPROPSD):");
        JLabel jLabel4 = new JLabel("      LOG10(RSTART):");
        JLabel jLabel5 = new JLabel("      RSTEP:    ");
        this.rstartField = new JTextField(10);
        this.rstartField.setText("-2");
        this.rmaxField = new JTextField(10);
        this.rmaxField.setText("2");
        this.rminField = new JTextField(10);
        this.rminField.setText("-4");
        this.rstdField = new JTextField(10);
        this.rstdField.setText("0.1");
        this.rstepField = new JTextField(10);
        this.rstepField.setText("1.05");
        jLabel4.setLabelFor(this.rstartField);
        jLabel5.setLabelFor(this.rstepField);
        jLabel.setLabelFor(this.rminField);
        jLabel2.setLabelFor(this.rmaxField);
        jLabel3.setLabelFor(this.rstdField);
        this.okButton = new JButton("   OK  ");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel ");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(this);
        JLabel jLabel6 = new JLabel("Admixture Burnin Length   ");
        this.defaultburninBox = new JRadioButton("  Use default admixture burnin length:");
        this.defaultburninBox.setSelected(true);
        this.defaultburninBox.setActionCommand("dburnin");
        this.defaultburninBox.addActionListener(this);
        this.specifyburninBox = new JRadioButton("  Specify admixture burnin length ");
        this.specifyburninBox.setSelected(true);
        this.specifyburninBox.setActionCommand("sburnin");
        this.specifyburninBox.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultburninBox);
        buttonGroup.add(this.specifyburninBox);
        this.burninField = new JTextField(5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(jLabel6);
        jPanel.add(this.defaultburninBox);
        jPanel.add(this.specifyburninBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(new JLabel("               "));
        jPanel2.add(new JLabel("      BURNIN/2 "));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.burninField);
        jPanel2.add(jPanel3);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.noqsBox = new JCheckBox("  Print Site-by-Site Results ");
        this.noqsBox.addItemListener(checkBoxListener);
        this.markovBox = new JCheckBox("  Phase info follows a Markov model ");
        this.markovBox.addItemListener(checkBoxListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 1));
        jPanel4.add(jLabel);
        jPanel4.add(jLabel2);
        jPanel4.add(jLabel3);
        jPanel4.add(jLabel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 1));
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.rstartField);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.rstepField);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.rminField);
        JPanel jPanel9 = new JPanel();
        jPanel9.add(this.rmaxField);
        JPanel jPanel10 = new JPanel();
        jPanel10.add(this.rstdField);
        jPanel5.add(jPanel8);
        jPanel5.add(jPanel9);
        jPanel5.add(jPanel10);
        jPanel5.add(jPanel6);
        JPanel jPanel11 = new JPanel();
        jPanel11.add(this.cancelButton);
        jPanel11.add(this.defaultButton);
        jPanel11.add(this.okButton);
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createEmptyBorder(20, 20, 4, 20));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel12.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel12.add(jPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel12.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel12.add(jPanel4);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel12.add(jPanel5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.noqsBox, gridBagConstraints);
        jPanel12.add(this.noqsBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.markovBox, gridBagConstraints);
        jPanel12.add(this.markovBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(25, 20, 20, 20);
        gridBagLayout.setConstraints(jPanel11, gridBagConstraints);
        jPanel12.add(jPanel11);
        this.setContentPane(jPanel12);
        this.setLocationRelativeTo(component);
        NProjObj nProjObj = nSimObj.getProjObj();
        if (!nProjObj.getPhaseInfo()) {
            this.markovBox.setEnabled(false);
            this.markovphase = false;
        }
        if (!nSimObj.isNew() && !bl) {
            this.rstart = nSimObj.RSTART;
            this.rstep = nSimObj.RSTEP;
            this.sitebysite = nSimObj.SITEBYSITE;
            this.markovphase = nSimObj.MARKOVPHASE;
            this.noqsBox.setSelected(this.sitebysite);
            this.markovBox.setSelected(this.markovphase);
            this.rstartField.setText("" + this.rstart);
            this.rmaxField.setText("" + this.rmax);
            this.rminField.setText("" + this.rmin);
            this.rstdField.setText("" + this.rstd);
            this.defaultburnin = nSimObj.USEDEFAULTADMBURNIN;
            this.admburnin = nSimObj.ADMBURNIN;
        }
        if (this.defaultburnin) {
            this.defaultburninBox.setSelected(true);
            this.burninField.setText("");
            this.burninField.setEnabled(false);
        } else {
            this.specifyburninBox.setSelected(true);
            this.burninField.setText("" + this.admburnin);
            this.burninField.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Default")) {
            this.reset();
            return;
        }
        if (string.equals("ok")) {
            if (!this.validateData()) {
                return;
            }
            this.buttonHit = 0;
            this.setVisible(false);
        }
        if (string.equals("cancel")) {
            this.buttonHit = 2;
            this.reset();
            this.setVisible(false);
        }
        if (string.equals("sburnin")) {
            this.burninField.setEnabled(true);
            this.defaultburnin = false;
        }
        if (string.equals("dburnin")) {
            this.burninField.setText("");
            this.burninField.setEnabled(false);
            this.defaultburnin = true;
        }
    }

    public void reset() {
        this.rstartField.setText("-2");
        this.rstart = -2.0f;
        this.rmaxField.setText("2");
        this.rmax = 2.0f;
        this.rminField.setText("-4");
        this.rmin = -4.0f;
        this.rstdField.setText("0.1");
        this.rstd = 0.1f;
        this.burninField.setText("");
        this.burninField.setEnabled(false);
        this.defaultburnin = true;
        this.defaultburninBox.setSelected(true);
        this.noqsBox.setSelected(false);
        this.markovBox.setSelected(false);
        this.markovphase = false;
        this.sitebysite = false;
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    public boolean validateData() {
        String string = "";
        String string2 = this.rstartField.getText();
        try {
            this.rstart = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\nLOG10(RSTART) Must be a Real Number");
        }
        string2 = this.rmaxField.getText();
        try {
            this.rmax = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\nLOG10(RMAX) Must be a Real Number");
        }
        string2 = this.rminField.getText();
        try {
            this.rmin = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\nLOG10(RMIN) Must be a Real Number");
        }
        string2 = this.rstdField.getText();
        try {
            this.rstd = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string + new String("\nLOG10(RPROPSTD) Must be a Real Number");
        }
        if (!this.defaultburnin) {
            string2 = this.burninField.getText();
            try {
                this.admburnin = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string = string + new String("\nAdmixture Burnin Length  Must be an Integer");
            }
        }
        if (string.compareTo("") != 0) {
            String string3 = "Errors:\n";
            string = string3.concat(string);
            string = string + new String("\n\n");
            JOptionPane.showMessageDialog(this, string, "errors", 0);
            return false;
        }
        return true;
    }

    public void updateData() {
        this.sim.USEDEFAULTADMBURNIN = this.defaultburnin;
        if (!this.defaultburnin) {
            this.sim.ADMBURNIN = this.admburnin;
        }
        this.sim.SITEBYSITE = this.sitebysite;
        this.sim.MARKOVPHASE = this.markovphase;
        this.sim.RMAX = this.rmax;
        this.sim.RSTD = this.rstd;
        this.sim.RMIN = this.rmin;
        this.sim.RSTART = this.rstart;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = true;
            if (itemEvent.getStateChange() == 2) {
                bl = false;
            }
            if (itemSelectable == RecombineDlg.this.noqsBox) {
                RecombineDlg.this.sitebysite = bl;
            }
            if (itemSelectable == RecombineDlg.this.markovBox) {
                RecombineDlg.this.markovphase = bl;
            }
        }
    }
}

