/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.RstDraw;
import Plot.RstPlot;
import Util.GeneralFileFilter;
import jas.plot.PrintHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class RstPlotManager
extends JDialog
implements ActionListener {
    private double[][] data;
    private int[] labels;
    private int[] popid;
    private JScrollPane sp;
    private RstPlot rp;
    private RstDraw rd;
    private JRadioButton sortButton;
    private JRadioButton groupButton;
    private JRadioButton origButton;
    private JRadioButton singleButton;
    private JRadioButton multiButton;
    private JPanel contentPane;
    private JPanel optionPane;
    private JPanel buttonPane;
    private int currPlot;
    private boolean single_line = true;

    public RstPlotManager(JFrame jFrame, String string, String string2) {
        super((Frame)jFrame, false);
        this.rp = new RstPlot(string);
        this.data = this.rp.getData();
        if (this.data == null) {
            JOptionPane.showMessageDialog(null, "Result data file is not in expected format", "Error", 0);
            return;
        }
        this.labels = this.rp.getLabel();
        this.popid = this.rp.getPopId();
        this.currPlot = 0;
        this.rd = new RstDraw(this.data, this.labels, this.popid);
        this.sp = new JScrollPane(this.rd);
        this.sp.setPreferredSize(new Dimension(700, 230));
        JButton jButton = new JButton("Print");
        jButton.setActionCommand("print");
        JButton jButton2 = new JButton(" Save");
        jButton2.setActionCommand("save");
        JButton jButton3 = new JButton("Close");
        jButton3.setActionCommand("close");
        this.sortButton = new JRadioButton("Sort by Q    ");
        this.sortButton.setActionCommand("sort");
        this.groupButton = new JRadioButton("Group by POP Id");
        this.groupButton.setActionCommand("group");
        if (this.popid == null) {
            this.groupButton.setEnabled(false);
        }
        this.origButton = new JRadioButton("Original order");
        this.origButton.setActionCommand("orig");
        this.singleButton = new JRadioButton("Plot in single line");
        this.singleButton.setActionCommand("single");
        this.multiButton = new JRadioButton("Plot in multiple lines");
        this.multiButton.setActionCommand("multi");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        this.sortButton.addActionListener(this);
        this.groupButton.addActionListener(this);
        this.origButton.addActionListener(this);
        this.singleButton.addActionListener(this);
        this.multiButton.addActionListener(this);
        this.origButton.setSelected(true);
        this.singleButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.origButton);
        jPanel.add(this.groupButton);
        jPanel.add(this.sortButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.origButton);
        buttonGroup.add(this.sortButton);
        buttonGroup.add(this.groupButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(this.singleButton);
        jPanel2.add(this.multiButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.singleButton);
        buttonGroup2.add(this.multiButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.optionPane = new JPanel();
        this.optionPane.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.optionPane.add(jPanel);
        gridBagConstraints.insets = new Insets(5, 10, 5, 20);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.optionPane.add(jPanel2);
        this.buttonPane = new JPanel();
        this.buttonPane.add(jButton);
        this.buttonPane.add(jButton2);
        this.buttonPane.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.optionPane, "Center");
        jPanel3.add((Component)this.buttonPane, "South");
        jPanel3.setPreferredSize(new Dimension(700, 130));
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.sp, "Center");
        this.contentPane.add((Component)jPanel3, "South");
        this.getContentPane().add(this.contentPane);
        this.setTitle(string2);
        this.setLocation(300, 200);
        this.data = null;
        this.setSize(700, 360);
        this.setVisible(true);
    }

    public void updatePlot(int n) {
        if (n == 0) {
            this.data = this.rp.getData();
        } else if (n == 1) {
            this.data = this.rp.sortData();
        } else if (n == 2) {
            this.data = this.rp.groupData();
        } else {
            return;
        }
        this.labels = this.rp.getLabel();
        this.popid = this.rp.getPopId();
        if (this.popid == null && n == 2) {
            JOptionPane.showMessageDialog(null, "No population information available", "Error", 0);
            return;
        }
        if (this.data == null) {
            return;
        }
        int n2 = this.data.length;
        if (n2 == 0) {
            return;
        }
        this.sp.remove(this.rd);
        this.contentPane.remove(this.sp);
        this.sp = new JScrollPane(this.rd);
        if (n == 2 && this.single_line) {
            this.rd.setPoplabel(true);
        } else {
            this.rd.setPoplabel(false);
        }
        this.rd.reLoadData(this.data, this.labels, this.popid, this.single_line);
        if (this.single_line) {
            this.sp.setPreferredSize(new Dimension(700, 230));
        } else {
            this.sp.setPreferredSize(new Dimension(700, 480));
        }
        this.contentPane.add((Component)this.sp, "Center");
        this.pack();
        this.currPlot = n;
        this.data = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("print")) {
            try {
                PrintHelper printHelper = PrintHelper.instance();
                printHelper.printTarget(this.rd);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (string.equals("save")) {
            JFileChooser jFileChooser = new JFileChooser();
            GeneralFileFilter generalFileFilter = new GeneralFileFilter("jpg", "JPEG image files");
            jFileChooser.addChoosableFileFilter(generalFileFilter);
            int n = jFileChooser.showDialog(this, "Save");
            if (n == 0) {
                Object[] objectArray;
                File file = jFileChooser.getSelectedFile();
                String string2 = file.getAbsolutePath();
                if (!string2.endsWith(".jpg") && !string2.endsWith(".jpeg")) {
                    file = new File(new String(string2 + ".jpg"));
                }
                if (file.exists()) {
                    objectArray = new Object[]{"Yes", "No "};
                    int n2 = JOptionPane.showOptionDialog(this, "Target file " + file.getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                    if (n2 == 1) {
                        return;
                    }
                }
                if (!(objectArray = file.getParentFile()).canWrite()) {
                    JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                    return;
                }
                this.rd.saveImage(file.getAbsolutePath());
            }
        }
        if (string.equals("sort")) {
            this.updatePlot(1);
            return;
        }
        if (string.equals("group")) {
            this.updatePlot(2);
            return;
        }
        if (string.equals("orig")) {
            this.updatePlot(0);
            return;
        }
        if (string.equals("single") && !this.single_line) {
            this.single_line = true;
            this.updatePlot(this.currPlot);
            return;
        }
        if (string.equals("multi") && this.single_line) {
            this.single_line = false;
            this.updatePlot(this.currPlot);
            return;
        }
        if (string.equals("close")) {
            this.dispose();
        }
    }
}

