/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.CommandTargetManager;
import jas.util.ErrorBox;
import jas.util.GetOptions;
import jas.util.HelpInterface;
import jas.util.UserProperties;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class Application
extends JPanel {
    private CommandTargetManager m_commandTargetManager = new CommandTargetManager();
    private Vector theHelpLocations = new Vector();
    private static Application app = null;
    private boolean debugHelp = false;
    private JFrame m_parent;
    private final UserProperties m_prop = new UserProperties();
    private GetOptions gopt = new GetOptions();
    private HelpInterface hi = null;

    public Application() {
        super(new BorderLayout());
        if (app != null) {
            throw new RuntimeException("Cannot make two applications.");
        }
        app = this;
        this.gopt.addOption("debug", 'd', false, "Takes a : separated list of debug modes to set");
        this.gopt.addOption("help", 'h', true, "Print this message");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.showHelpContents();
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(156, 0), 2);
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(112, 0), 2);
    }

    protected int parseArgs(String[] stringArray) {
        try {
            this.gopt.parseArgs(stringArray);
        }
        catch (GetOptions.BadArguments badArguments) {
            this.doHelp();
            System.out.println("The command line options you specified had the following problem:\n" + badArguments.getMessage());
            System.exit(0);
        }
        if (this.gopt.hasOption("help")) {
            this.doHelp();
            System.exit(0);
        }
        this.setDebugFlags();
        return this.gopt.numParams();
    }

    protected void doHelp() {
        this.gopt.dumpOptions();
    }

    private void initializeHelpSystem() throws Exception {
        if (this.debugHelp) {
            System.err.println("Initializing help system...");
        }
        try {
            this.hi = (HelpInterface)Class.forName("jas.util.HelpInterfaceImpl").newInstance();
            if (this.debugHelp) {
                System.err.println("Help system initialized successfully");
            }
        }
        catch (Exception exception) {
            if (this.debugHelp) {
                System.err.println("Failed: " + exception.getMessage());
            }
            throw exception;
        }
    }

    public void addHelpLocation(Class clazz, String string) {
        this.addHelpLocation(clazz.getResource(string));
    }

    public void addHelpLocation(URL uRL) {
        if (this.debugHelp) {
            System.err.println("addHelpLocation: " + uRL);
        }
        if (uRL != null) {
            this.theHelpLocations.addElement(uRL);
        }
    }

    public void addHelpLocation(String string) {
        try {
            if (this.debugHelp) {
                System.err.println("addHelpLocation: " + string);
            }
            this.theHelpLocations.addElement(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL for addHelpLocation - ignored: " + string);
            malformedURLException.printStackTrace();
        }
    }

    Enumeration getHelpLocations() {
        return this.theHelpLocations.elements();
    }

    private void setDebugFlags() {
        if (this.gopt.hasOption("debug")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.gopt.getOption("debug"), ":");
            while (stringTokenizer.hasMoreTokens()) {
                this.setDebugFlag(stringTokenizer.nextToken());
            }
        }
    }

    protected void setDebugFlag(String string) {
        String string2 = "debug" + string.substring(0, 1).toUpperCase() + string.substring(1);
        System.getProperties().put(string2, "true");
        System.out.println("Set debug flag " + string2);
        if (string.equals("help")) {
            this.debugHelp = true;
        }
    }

    public static final Application getApplication() {
        return app;
    }

    public final UserProperties getUserProperties() {
        return this.m_prop;
    }

    public final JFrame getFrame() {
        if (this.m_parent == null) {
            Container container = this;
            while (container != null && !(container instanceof JFrame)) {
                container = container.getParent();
            }
            this.m_parent = (JFrame)container;
        }
        return this.m_parent;
    }

    public final void showHelpContents() {
        this.showHelpTopic("top");
    }

    public final void showHelpIndex() {
        this.showHelpTopic("top", "Index");
    }

    public final void showHelpSearch() {
        this.showHelpTopic("top", "Search");
    }

    public final void error(String string, Throwable throwable) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), string, throwable).doModal();
        } else {
            System.err.println("Error: " + string + " " + throwable);
        }
    }

    public final void error(String string) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), string).doModal();
        } else {
            System.err.println("Error: " + string);
        }
    }

    public final void error(String string, Throwable throwable, String string2) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), string, throwable, string2).doModal();
        } else {
            System.err.println("Error: " + string + " " + throwable);
        }
    }

    public final void error(String string, String string2) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), string, string2).doModal();
        } else {
            System.err.println("Error: " + string);
        }
    }

    public final void showHelpTopic(String string) {
        this.showHelpTopic(string, this.getFrame());
    }

    public final void showHelpTopic(String string, Window window) {
        try {
            if (this.hi == null) {
                this.initializeHelpSystem();
            }
            this.hi.showHelpTopic(string, window);
        }
        catch (Throwable throwable) {
            this.whine(throwable);
        }
    }

    private final void showHelpTopic(String string, String string2) {
        try {
            if (this.hi == null) {
                this.initializeHelpSystem();
            }
            this.hi.showHelpTopic(string, string2, this.getFrame());
        }
        catch (Throwable throwable) {
            this.whine(throwable);
        }
    }

    private final void whine(Throwable throwable) {
        app.error("Could not initialize help system!", throwable);
    }

    public GetOptions getGetOptions() {
        return this.gopt;
    }

    public CommandTargetManager getCommandManager() {
        return this.m_commandTargetManager;
    }

    void modalDialogOpening(Dialog dialog) {
        if (this.hi != null) {
            this.hi.modalDialogOpening(dialog);
        }
    }

    void modalDialogClosing(Dialog dialog) {
        if (this.hi != null) {
            this.hi.modalDialogClosing(dialog);
        }
    }
}

