/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.ColorEvent;
import jas.util.ColorListener;
import jas.util.UserProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooser
extends JButton {
    private UserProperties m_prop;
    private String m_key;
    private Color m_color;
    private Vector m_listeners = new Vector();

    public ColorChooser() {
        this(Color.black);
    }

    public ColorChooser(Color color) {
        this.setColor(color);
        this.setOpaque(true);
    }

    public ColorChooser(String string) {
        this.m_prop = Application.getApplication().getUserProperties();
        this.m_key = string;
        this.setOpaque(true);
        this.setColor(this.m_prop.getColor(string, Color.black));
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    public void setColor(Color color) {
        this.m_color = color;
        this.setBackground(color);
        this.repaint();
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ColorListener colorListener = (ColorListener)enumeration.nextElement();
            colorListener.colorChanged(new ColorEvent((Object)this, color));
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    public void addColorListener(ColorListener colorListener) {
        this.m_listeners.addElement(colorListener);
    }

    public void removeColorListener(ColorListener colorListener) {
        this.m_listeners.removeElement(colorListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Choose color...", this.m_color);
        if (color != null) {
            this.setColor(color);
            if (this.m_key != null) {
                this.m_prop.setColor(this.m_key, color);
            }
        }
    }
}

