/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RstDlg
extends JDialog
implements ActionListener {
    private JTextField rstField;
    private JTextField outField;
    private String rstfile;
    private String rtmfile;
    private File dirCache;
    int buttonHit;

    public RstDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle("Select results files");
        this.setLocation(600, 500);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("   Result file     ");
        this.rstField = new JTextField(9);
        JButton jButton = new JButton("Browse...");
        jButton.setActionCommand("rst");
        jButton.addActionListener(this);
        jPanel.add(jLabel);
        jPanel.add(this.rstField);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel("Runtime output ");
        this.outField = new JTextField(9);
        JButton jButton2 = new JButton("Browse...");
        jButton2.setActionCommand("rtm");
        jButton2.addActionListener(this);
        jPanel2.add(jLabel2);
        jPanel2.add(this.outField);
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton("   OK   ");
        jButton3.setActionCommand("ok");
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton("  Cancel ");
        jButton4.setActionCommand("cancel");
        jButton4.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.setPreferredSize(new Dimension(400, 80));
        JPanel jPanel5 = new JPanel();
        JLabel jLabel3 = new JLabel(" ");
        jPanel5.add(jLabel3);
        jPanel5.setPreferredSize(new Dimension(400, 30));
        jPanel3.setPreferredSize(new Dimension(400, 50));
        this.getContentPane().add("North", jPanel5);
        this.getContentPane().add("Center", jPanel4);
        this.getContentPane().add("South", jPanel3);
        this.setSize(400, 160);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RstDlg.this.buttonHit = 2;
            }
        });
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    private boolean validateInput() {
        String string = this.rstField.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            JOptionPane.showMessageDialog(null, "Result file can not be empty", "Error", 0);
            return false;
        }
        File file = new File(string);
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, "Can not open result file " + string, "Error", 0);
            return false;
        }
        this.rstfile = string;
        string = this.outField.getText();
        stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens() && !(file = new File(string)).canRead()) {
            JOptionPane.showMessageDialog(null, "Can not open runtime output file " + string, "Error", 0);
            return false;
        }
        this.rtmfile = string;
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        int n;
        JFileChooser jFileChooser;
        String string = actionEvent.getActionCommand();
        if (string.equals("rst")) {
            jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.dirCache);
            jFileChooser.setApproveButtonText("Select");
            n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
                this.rstField.setText(file.getAbsolutePath());
                this.dirCache = file.getParentFile();
            }
        }
        if (string.equals("rtm")) {
            jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.dirCache);
            jFileChooser.setApproveButtonText("Select");
            n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
                this.outField.setText(file.getAbsolutePath());
                this.dirCache = file.getParentFile();
            }
        }
        if (string.equals("ok")) {
            if (this.validateInput()) {
                this.setVisible(false);
                this.buttonHit = 0;
            } else {
                return;
            }
        }
        if (string.equals("cancel")) {
            this.setVisible(false);
            this.buttonHit = 2;
            return;
        }
    }

    public String getRstFile() {
        return this.rstfile;
    }

    public String getRtmFile() {
        return this.rtmfile;
    }
}

