/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StartRunDlg
extends JDialog
implements ActionListener {
    private int buttonHit;
    private JTextField inputArea;
    private JButton okButton;
    private JButton seedButton;
    private JButton cancelButton;
    public int seed;
    public int K;
    public int seed_flag = 0;

    public StartRunDlg() {
        this.setTitle("Run Structure Simulation");
        this.setLocationRelativeTo(null);
        this.inputArea = new JTextField(5);
        JLabel jLabel = new JLabel("       Set number of populations assumed  ");
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(this.inputArea);
        this.okButton = new JButton("        OK        ");
        this.seedButton = new JButton("Set random seed ...");
        this.cancelButton = new JButton("       Cancel      ");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.seedButton.setActionCommand("seed");
        this.seedButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.okButton);
        jPanel2.add(this.seedButton);
        jPanel2.add(this.cancelButton);
        jPanel2.setPreferredSize(new Dimension(500, 50));
        this.getContentPane().add("North", new JLabel("           "));
        this.getContentPane().add("Center", jPanel);
        this.getContentPane().add("South", jPanel2);
    }

    public int showDialog() {
        this.setModal(true);
        this.pack();
        super.show();
        return this.buttonHit;
    }

    private boolean validateInput() {
        String string = this.inputArea.getText();
        if (string == null) {
            return false;
        }
        try {
            this.K = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return this.K > 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            if (!this.validateInput()) {
                JOptionPane.showMessageDialog(null, "The input for K is invalid", "Error", 0);
                return;
            }
            this.buttonHit = 1;
            this.setVisible(false);
            return;
        }
        if (string.equals("seed")) {
            while (true) {
                String string2;
                if ((string2 = JOptionPane.showInputDialog("Set user defined random seed")) == null) {
                    return;
                }
                try {
                    this.seed = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Current input is not a valid integer random seed", "Error", 0);
                    continue;
                }
                break;
            }
            this.seed_flag = 1;
        }
        if (string.equals("cancel")) {
            this.buttonHit = -1;
            this.setVisible(false);
        }
    }
}

