/*
 * Decompiled with CFR 0.152.
 */
package Obj;

import Obj.ProjObj;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class SimObj
implements Serializable {
    private ProjObj projObj;
    private String simPath;
    private String simFilePath;
    private String extFilePath;
    private boolean isNew = true;
    private String OUTFILE;
    private String simName;
    private int MAXPOPS;
    public int BURNIN;
    public int NUMREPS;
    public boolean FREQSCORR;
    public boolean ONEFST;
    public float FPRIORMEAN;
    public float FPRIORSD;
    public boolean FQSETLAMBDA;
    public boolean FQINFERLAMBDA;
    public boolean INDIFQSETLAMBDA;
    public boolean INDIFQINFERLAMBDA;
    public boolean NOADMIX;
    public boolean USEDEFAULTADMBURNIN;
    public int ADMBURNIN;
    public boolean INFERALPHA;
    public float ALPHA;
    public boolean POPALPHAS;
    public boolean UNIFPRIORALPHA;
    public float ALPHAMAX;
    public float ALPHAPROPSD;
    public float ALPHAPRIORA;
    public float ALPHAPRIORB;
    public boolean RECOMBINE;
    public boolean SITEBYSITE;
    public float RSTART;
    public float RSTEP;
    public float RMAX;
    public float RMIN;
    public float RSTD;
    public boolean MARKOVPHASE;
    public boolean USEPOPINFO;
    public int GENSBACK;
    public float MIGRPRIOR;
    public boolean POPNOADMIX;
    public boolean POPRECOMBINE;
    public boolean INFERLAMBDA;
    public boolean POPSPECIFICLAMBDA;
    public float LAMBDA;
    public boolean COMPUTEPROB;
    public boolean ANCESTDIST;
    public boolean PRINTQ;
    public int NUMBOXES;
    public float ANCESTPINT;
    public boolean STARTPOPINFO;
    public int METROFREQ;

    public SimObj(ProjObj projObj) {
        this.projObj = projObj;
    }

    public String getConfig() {
        String string = new String("#define OUTFILE " + this.OUTFILE + "\n");
        string = string + this.projObj.getConfig();
        string = string + new String("#define MAXPOPS " + this.MAXPOPS + "\n");
        string = string + new String("#define BURNIN " + this.BURNIN + "\n");
        string = string + new String("#define NUMREPS " + this.NUMREPS + "\n\n");
        if (this.USEPOPINFO) {
            string = string + new String("\n\n#define USEPOPINFO 1 \n");
            if (!this.POPRECOMBINE) {
                string = string + new String("#define GENSBACK " + this.GENSBACK + "\n");
                string = string + new String("#define MIGRPRIOR " + this.MIGRPRIOR + "\n");
            } else {
                string = string + new String("#define GENSBACK  0 \n");
                string = string + new String("#define MIGRPRIOR  0 \n");
            }
            if (this.POPRECOMBINE) {
                string = string + new String("\n#define LINKAGE 1 \n");
                string = string + new String("#define NOADMIX 0 \n");
                string = this.SITEBYSITE ? string + new String("#define SITEBYSITE 1 \n") : string + new String("#define SITEBYSITE 0 \n");
                string = this.MARKOVPHASE ? string + new String("#define MARKOVPHASE 1 \n") : string + new String("#define MARKOVPHASE 0 \n");
                string = string + new String("#define LOG10RSTART " + this.RSTART + "\n");
                string = string + new String("#define LOG10RMAX " + this.RMAX + "\n");
                string = string + new String("#define LOG10RMIN " + this.RMIN + "\n");
                string = string + new String("#define LOG10RPROPSD " + this.RSTD + "\n");
                string = this.USEDEFAULTADMBURNIN ? string + new String("#define ADMBURNIN " + this.BURNIN / 2 + "\n") : string + new String("#define ADMBURNIN " + this.ADMBURNIN + "\n");
            } else if (!this.POPNOADMIX) {
                string = string + new String("\n#define NOADMIX 0\n");
                string = string + new String("\n#define LINKAGE 0\n");
                if (this.INFERALPHA) {
                    string = string + new String("#define INFERALPHA 1\n");
                    string = string + new String("#define ALPHA " + this.ALPHA + "\n");
                    string = this.POPALPHAS ? string + new String("#define POPALPHAS 1 \n") : string + new String("#define POPALPHAS 0 \n");
                    if (this.UNIFPRIORALPHA) {
                        string = string + new String("#define UNIFPRIORALPHA 1 \n");
                        string = string + new String("#define ALPHAMAX " + this.ALPHAMAX + "\n");
                        string = string + new String("#define ALPHAPROPSD " + this.ALPHAPROPSD + "\n");
                    } else {
                        string = string + new String("#define UNIFPRIORALPHA 0 \n");
                        string = string + new String("#define ALPHAPRIORA " + this.ALPHAPRIORA + "\n");
                        string = string + new String("#define ALPHAPRIORB " + this.ALPHAPRIORB + "\n");
                    }
                } else {
                    string = string + new String("#define INFERALPHA 0\n");
                    string = string + new String("#define ALPHA " + this.ALPHA + "\n");
                }
            } else {
                string = string + new String("\n#define LINKAGE 0\n");
                string = string + new String("#define NOADMIX 1\n");
                string = string + new String("#define ADMBURNIN " + this.BURNIN / 2 + "  \n");
            }
        } else if (this.RECOMBINE) {
            string = string + new String("\n#define LINKAGE 1 \n");
            string = string + new String("#define NOADMIX 0 \n");
            string = string + new String("#define USEPOPINFO 0 \n");
            string = this.SITEBYSITE ? string + new String("#define SITEBYSITE 1 \n") : string + new String("#define SITEBYSITE 0 \n");
            string = this.MARKOVPHASE ? string + new String("#define MARKOVPHASE 1 \n") : string + new String("#define MARKOVPHASE 0 \n");
            string = string + new String("#define LOG10RSTART " + this.RSTART + "\n");
            string = string + new String("#define LOG10RMAX " + this.RMAX + "\n");
            string = string + new String("#define LOG10RMIN " + this.RMIN + "\n");
            string = string + new String("#define LOG10RPROPSD " + this.RSTD + "\n");
            string = this.USEDEFAULTADMBURNIN ? string + new String("#define ADMBURNIN " + this.BURNIN / 2 + "\n") : string + new String("#define ADMBURNIN " + this.ADMBURNIN + "\n");
        } else if (!this.NOADMIX) {
            string = string + new String("\n#define NOADMIX 0\n");
            string = string + new String("#define LINKAGE 0\n");
            string = string + new String("#define USEPOPINFO 0\n");
            if (this.INFERALPHA) {
                string = string + new String("#define INFERALPHA 1\n");
                string = string + new String("#define ALPHA " + this.ALPHA + "\n");
                string = this.POPALPHAS ? string + new String("#define POPALPHAS 1 \n") : string + new String("#define POPALPHAS 0 \n");
                if (this.UNIFPRIORALPHA) {
                    string = string + new String("#define UNIFPRIORALPHA 1 \n");
                    string = string + new String("#define ALPHAMAX " + this.ALPHAMAX + "\n");
                    string = string + new String("#define ALPHAPROPSD " + this.ALPHAPROPSD + "\n");
                } else {
                    string = string + new String("#define UNIFPRIORALPHA 0 \n");
                    string = string + new String("#define ALPHAPRIORA " + this.ALPHAPRIORA + "\n");
                    string = string + new String("#define ALPHAPRIORB " + this.ALPHAPRIORB + "\n");
                }
            } else {
                string = string + new String("#define INFERALPHA 0\n");
                string = string + new String("#define ALPHA " + this.ALPHA + "\n");
            }
        } else {
            string = string + new String("\n#define LINKAGE 0\n");
            string = string + new String("#define NOADMIX 1\n");
            string = string + new String("#define ADMBURNIN " + this.BURNIN / 2 + "  \n");
            string = string + new String("#define USEPOPINFO 0\n");
        }
        if (this.INFERLAMBDA) {
            string = string + new String("\n\n#define INFERLAMBDA 1 \n");
            string = string + new String("\n#define FREQSCORR 0\n");
            string = this.POPSPECIFICLAMBDA ? string + new String("#define POPSPECIFICLAMBDA 1 \n") : string + new String("#define POPSPECIFICLAMBDA 0 \n");
            string = string + new String("#define LAMBDA " + this.LAMBDA + "\n");
        } else if (this.FREQSCORR) {
            string = string + new String("\n\n#define FREQSCORR 1 \n");
            string = this.ONEFST ? string + new String("#define ONEFST 1\n") : string + new String("#define ONEFST 0\n");
            string = string + new String("#define FPRIORMEAN " + this.FPRIORMEAN + "\n");
            string = string + new String("#define FPRIORSD " + this.FPRIORSD + "\n");
            if (this.FQINFERLAMBDA) {
                string = string + new String("\n\n#define INFERLAMBDA 1 \n");
                string = this.POPSPECIFICLAMBDA ? string + new String("#define POPSPECIFICLAMBDA 1 \n") : string + new String("#define POPSPECIFICLAMBDA 0 \n");
                string = string + new String("#define LAMBDA " + this.LAMBDA + "\n");
            } else if (this.FQSETLAMBDA) {
                string = string + new String("\n\n#define INFERLAMBDA 0 \n");
                string = string + new String("#define LAMBDA " + this.LAMBDA + "\n");
            }
        } else {
            string = string + new String("\n#define FREQSCORR 0\n");
            if (this.INDIFQINFERLAMBDA) {
                string = string + new String("\n\n#define INFERLAMBDA 1 \n");
                string = this.POPSPECIFICLAMBDA ? string + new String("#define POPSPECIFICLAMBDA 1 \n") : string + new String("#define POPSPECIFICLAMBDA 0 \n");
                string = string + new String("#define LAMBDA " + this.LAMBDA + "\n");
            } else if (this.INDIFQSETLAMBDA) {
                string = string + new String("#define LAMBDA " + this.LAMBDA + "\n");
            }
        }
        string = this.COMPUTEPROB ? string + new String("#define COMPUTEPROB 1 \n") : string + new String("#define COMPUTEPROB 0 \n");
        if (this.ANCESTDIST) {
            string = string + new String("#define ANCESTDIST 1 \n");
            string = string + new String("#define NUMBOXES " + this.NUMBOXES + "\n");
            string = string + new String("#define ANCESTPINT " + this.ANCESTPINT + "\n");
        } else {
            string = string + new String("#define ANCESTDIST 0 \n");
        }
        string = this.STARTPOPINFO ? string + new String("#define STARTATPOPINFO 1 \n") : string + new String("#define STARTATPOPINFO 0 \n");
        string = string + new String("#define METROFREQ " + this.METROFREQ + "\n\n\n");
        string = string + new String("#define UPDATEFREQ 1 \n");
        if (this.PRINTQ) {
            string = string + new String("#define PRINTQHAT 1\n");
        }
        return string;
    }

    public String printSimInfo() {
        String string = new String("");
        string = string + "\n";
        string = string + "         ====================  Parameter Set: " + this.getSimName() + "  ====================     \n\n\n";
        string = string + "                                    Running Length          \n\n";
        string = string + "                     Length of Burnin Period: " + this.BURNIN + "\n";
        string = string + "                     Number of MCMC Reps after Burnin: " + this.NUMREPS + "\n\n\n";
        string = string + "                                    Ancestry Model Info          \n\n";
        if (this.USEPOPINFO) {
            string = string + "                   Use Prior Population Information to Assist Clustering           \n";
            if (!this.POPRECOMBINE) {
                string = string + "                     * GENSBACK  = " + this.GENSBACK + "\n";
                string = string + "                     * MIGRPRIOR = " + this.MIGRPRIOR + "\n";
            }
            string = string + "                     * For Individuals without population information data, use    \n";
            if (this.POPRECOMBINE) {
                string = string + "                          LinkageModel          \n";
                if (this.SITEBYSITE) {
                    string = string + "                            ** Print site-by-site information     \n";
                }
                if (this.MARKOVPHASE) {
                    string = string + "                            ** The phase info follows a Markov model";
                }
                string = string + "                            ** LOG10(RSTART) = " + this.RSTART + "\n";
                string = string + "                            ** LOG10(RMAX) = " + this.RMAX + "\n";
                string = string + "                            ** LOG10(RMIN) = " + this.RMIN + "\n";
                string = string + "                            ** LOG10(RPROPSD) = " + this.RSTD + "\n";
                string = this.USEDEFAULTADMBURNIN ? string + "                            ** Admixture burnin length: " + this.BURNIN / 2 + "\n" : string + "                            ** Admixture burnin length: " + this.ADMBURNIN + "\n";
            } else if (!this.POPNOADMIX) {
                string = string + "                          Admixture Model            \n";
                if (this.INFERALPHA) {
                    string = string + "                                ** Infer Alpha\n";
                    string = string + "                                ** Initial Value of ALPHA (Dirichlet Parameter for Degree of Admixture):  " + this.ALPHA + "\n";
                    string = this.POPALPHAS ? string + "                                ** Use Individual Alpha for Each Population\n" : string + "                                ** Use Same Alpha for all Populations\n";
                    if (this.UNIFPRIORALPHA) {
                        string = string + "                                ** Use a Uniform Prior for Alpha\n";
                        string = string + "                                  *** Maximum Value for Alpha: " + this.ALPHAMAX + "\n";
                        string = string + "                                  *** SD of Proposal for Updating Alpha: " + this.ALPHAPROPSD + "\n";
                    } else {
                        string = string + "                                ** Use a Gamma Prior for Alpha \n";
                        string = string + "                                  *** A: " + this.ALPHAPRIORA + "\n";
                        string = string + "                                  *** B: " + this.ALPHAPRIORB + "\n";
                    }
                } else {
                    string = string + "                                ** Use Constant Alpha Value\n";
                    string = string + "                                ** Value of Alpha (Dirichlet Parameter for Defree of Admixture): " + this.ALPHA + "\n";
                }
            } else {
                string = string + "                          No Admixture Model                 \n\n";
            }
        } else if (this.RECOMBINE) {
            string = string + "                    Use Linkage Model   \n";
            if (this.SITEBYSITE) {
                string = string + "                      * Print site-by-site information     \n";
            }
            if (this.MARKOVPHASE) {
                string = string + "                      * The phase info follows a Markov model   \n";
            }
            string = string + "                      * LOG10(RSTART) = " + this.RSTART + "\n";
            string = string + "                      * LOG10(RMAX) = " + this.RMAX + "\n";
            string = string + "                      * LOG10(RMIN) = " + this.RMIN + "\n";
            string = string + "                      * LOG10(RPROPSD) = " + this.RSTD + "\n";
            string = this.USEDEFAULTADMBURNIN ? string + "                      * Admixture burnin length: " + this.BURNIN / 2 + "\n" : string + "                      * Admixture burnin length: " + this.ADMBURNIN + "\n";
        } else if (!this.NOADMIX) {
            string = string + "                    Use Admixture Model       \n";
            if (this.INFERALPHA) {
                string = string + "                      * Infer Alpha\n";
                string = string + "                      * Initial Value of ALPHA (Dirichlet Parameter for Degree of Admixture):  " + this.ALPHA + "\n";
                string = this.POPALPHAS ? string + "                      * Use Individual Alpha for Each Population\n" : string + "                      * Use Same Alpha for all Populations\n";
                if (this.UNIFPRIORALPHA) {
                    string = string + "                      * Use a Uniform Prior for Alpha\n";
                    string = string + "                         ** Maximum Value for Alpha: " + this.ALPHAMAX + "\n";
                    string = string + "                         ** SD of Proposal for Updating Alpha: " + this.ALPHAPROPSD + "\n";
                } else {
                    string = string + "                      * Use a Gamma Prior for Alpha \n";
                    string = string + "                         ** A: " + this.ALPHAPRIORA + "\n";
                    string = string + "                         ** B: " + this.ALPHAPRIORB + "\n";
                }
            } else {
                string = string + "                      * Use Constant Alpha Value\n";
                string = string + "                      * Value of Alpha (Dirichlet Parameter for Defree of Admixture): " + this.ALPHA + "\n";
            }
        } else {
            string = string + "                  Use No Admixture Model       \n\n";
        }
        string = string + "\n\n";
        string = string + "                                    Frequency Model Info   \n\n";
        if (this.INFERLAMBDA) {
            string = string + "                     Infer Lambda (Allele Frequencies Parameter) \n";
            string = this.POPSPECIFICLAMBDA ? string + "                       * Infer a Separate Lambda for each Population\n" : string + "                       * Use a Uniform Lambda for All Population\n";
            string = string + "                       * Initial Value of Lambda: " + this.LAMBDA + "\n";
        } else if (this.FREQSCORR) {
            string = string + "                     Allele Frequencies are Correlated among Pops\n";
            string = this.ONEFST ? string + "                       * Assume Same Value of Fst for All Subpopulations\n" : string + "                       * Assume Different Values of Fst for Different Subpopulations\n";
            string = string + "                       * Prior Mean of Fst for Pops: " + this.FPRIORMEAN + "\n";
            string = string + "                       * Prior SD   of Fst for Pops: " + this.FPRIORSD + "\n";
            if (this.FQINFERLAMBDA) {
                string = string + "                       * Infer LAMBDA  \n";
                string = this.POPSPECIFICLAMBDA ? string + "                         ** Infer a Separate Lambda for each Population\n" : string + "                         ** Use a Uniform Lambda for All Population\n";
                string = string + "                         ** Initial Value of Lambda: " + this.LAMBDA + "\n";
            } else if (this.FQSETLAMBDA) {
                string = string + "                       * Use Constant Lambda (Allele Frequencies Parameter) \n";
                string = string + "                       * Value of Lambda: " + this.LAMBDA + "\n";
            }
        } else {
            string = string + "                     Allele Frequencies are Independent among Pops\n";
            if (this.INDIFQINFERLAMBDA) {
                string = string + "                       * Infer LAMBDA  \n";
                string = this.POPSPECIFICLAMBDA ? string + "                         ** Infer a Separate Lambda for each Population\n" : string + "                         ** Use a Uniform Lambda for All Population\n";
                string = string + "                         ** Initial Value of Lambda: " + this.LAMBDA + "\n";
            } else if (this.INDIFQSETLAMBDA) {
                string = string + "                       * Use Constant Lambda (Allele Frequencies Parameter) \n";
                string = string + "                       * Value of Lambda: " + this.LAMBDA + "\n";
            }
        }
        string = string + "\n\n";
        string = string + "                                    Advanced Options   \n\n";
        if (this.COMPUTEPROB) {
            string = string + "                      Estimate the Probability of the Data Under the Model \n";
        }
        if (this.ANCESTDIST) {
            string = string + "                      Collect Data About the Distribution of Ancestry Coefficients Q for each Individual\n";
            string = string + "                        * Distribution of Q values is Stored as a Histogram with " + this.NUMBOXES + " Boxes\n";
            string = string + "                        * Size of the Displayed Probability Interval on Q: " + this.ANCESTPINT + "\n";
        }
        if (this.PRINTQ) {
            string = string + "                      Print Q-hat\n";
        }
        if (this.STARTPOPINFO) {
            string = string + "                      Initialize at POPINFO \n";
        }
        string = string + "                      Frequency of Metropolis update for Q: " + this.METROFREQ + "\n\n\n";
        return string;
    }

    public String getRstName() {
        File file = new File(this.OUTFILE);
        return file.getName();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean createSimSpace() {
        File file;
        Object object;
        String string = this.projObj.getWorkingPath();
        while (true) {
            this.simName = JOptionPane.showInputDialog("Please name the new parameter set ");
            if (this.simName == null) {
                return false;
            }
            object = new StringTokenizer(this.simName);
            if (!((StringTokenizer)object).hasMoreTokens()) continue;
            if (this.projObj.checkSimName(this.simName)) break;
            JOptionPane.showMessageDialog(null, "The parameter set with name " + this.simName + " already exists ", "Structure", 0);
        }
        object = new File(string, this.simName);
        ((File)object).mkdirs();
        this.simPath = ((File)object).getAbsolutePath();
        File file2 = new File(this.simPath, "Results");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!(file = new File(this.simPath, "PlotData")).exists()) {
            file.mkdirs();
        }
        this.isNew = false;
        return true;
    }

    public String getSimName() {
        return this.simName;
    }

    public String getSimPath() {
        return this.simPath;
    }

    public void setSimPath(String string) {
        this.simPath = string;
    }

    public boolean setOutFile(String string) {
        File file = new File(this.simPath, "Results");
        String string2 = string + "_f";
        File file2 = new File(file.getAbsolutePath(), string2);
        if (file2.exists()) {
            return false;
        }
        this.OUTFILE = new File(file.getAbsolutePath(), string).getAbsolutePath();
        return true;
    }

    public void setMAXPOPS(int n) {
        this.MAXPOPS = n;
    }

    public int getMAXPOPS() {
        return this.MAXPOPS;
    }

    public void writeParamFile() {
        File file = new File(this.simPath, "mainparams");
        PrintStream printStream = SimObj.OpenOutputFile(file);
        printStream.println(this.getConfig());
        this.simFilePath = file.getAbsolutePath();
        File file2 = new File(this.simPath, "extraparams");
        PrintStream printStream2 = SimObj.OpenOutputFile(file2);
        printStream2.println(" ");
        this.extFilePath = file2.getAbsolutePath();
    }

    public void writeSimFile() {
        String string = ".sim";
        File file = new File(this.simPath, string);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SimObj loadSimObj(File file) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            SimObj simObj = (SimObj)objectInputStream.readObject();
            objectInputStream.close();
            File file2 = new File(file.getParent());
            simObj.setSimPath(file2.getAbsolutePath());
            return simObj;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Simulation data corrupted", "Error", 0);
            System.err.println(iOException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "Simulation data corrupted", "Error", 0);
            return null;
        }
    }

    public String getParamFile() {
        return this.simFilePath;
    }

    public String getExtraFile() {
        return this.extFilePath;
    }

    private static PrintStream OpenOutputFile(File file) {
        PrintStream printStream;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("**Error: unable to open output file.");
            printStream = null;
        }
        catch (SecurityException securityException) {
            System.err.println("**Error: no permission to write output file.");
            printStream = null;
        }
        catch (IOException iOException) {
            System.err.println("**Error: unknown error opening output file.");
            printStream = null;
        }
        return printStream;
    }

    public boolean equals(SimObj simObj) {
        return this.BURNIN == simObj.BURNIN && this.NUMREPS == simObj.NUMREPS && this.FREQSCORR == simObj.FREQSCORR && this.ONEFST == simObj.ONEFST && this.FPRIORMEAN == simObj.FPRIORMEAN && this.FPRIORSD == simObj.FPRIORSD && this.NOADMIX == simObj.NOADMIX && this.ADMBURNIN == simObj.ADMBURNIN && this.INFERALPHA == simObj.INFERALPHA && this.ALPHA == simObj.ALPHA && this.POPALPHAS == simObj.POPALPHAS && this.UNIFPRIORALPHA == simObj.UNIFPRIORALPHA && this.ALPHAMAX == simObj.ALPHAMAX && this.ALPHAPROPSD == simObj.ALPHAPROPSD && this.ALPHAPRIORA == simObj.ALPHAPRIORA && this.ALPHAPRIORB == simObj.ALPHAPRIORB && this.RECOMBINE == simObj.RECOMBINE && this.SITEBYSITE == simObj.SITEBYSITE && this.RSTART == simObj.RSTART && this.RMAX == simObj.RMAX && this.RMIN == simObj.RMIN && this.RSTD == simObj.RSTD && this.USEPOPINFO == simObj.USEPOPINFO && this.GENSBACK == simObj.GENSBACK && this.MIGRPRIOR == simObj.MIGRPRIOR && this.INFERLAMBDA == simObj.INFERLAMBDA && this.POPSPECIFICLAMBDA == simObj.POPSPECIFICLAMBDA && this.LAMBDA == simObj.LAMBDA && this.COMPUTEPROB == simObj.COMPUTEPROB && this.ANCESTDIST == simObj.ANCESTDIST && this.NUMBOXES == simObj.NUMBOXES && this.ANCESTPINT == simObj.ANCESTPINT && this.STARTPOPINFO == simObj.STARTPOPINFO && this.METROFREQ == simObj.METROFREQ && this.INDIFQSETLAMBDA == simObj.INDIFQSETLAMBDA && this.INDIFQINFERLAMBDA == simObj.INDIFQINFERLAMBDA && this.FQSETLAMBDA == simObj.FQSETLAMBDA && this.FQINFERLAMBDA == simObj.FQINFERLAMBDA && this.USEDEFAULTADMBURNIN == simObj.USEDEFAULTADMBURNIN && this.POPNOADMIX == simObj.POPNOADMIX && this.POPRECOMBINE == simObj.POPRECOMBINE && this.PRINTQ == simObj.PRINTQ;
    }

    public void setProjObj(ProjObj projObj) {
        this.projObj = projObj;
    }

    public ProjObj getProjObj() {
        return this.projObj;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

