/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.HistPlot;
import Plot.Plot;
import Proc.AppProc;
import Util.GeneralFileFilter;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import jas.hist.JASHist;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RecmbPlotManager {
    private JFrame target;
    private int dataset;
    private AppProc proc;
    Plot stg;
    JASHist sth;
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                RecmbPlotManager.this.saveCurveImage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private ActionListener hlistener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                RecmbPlotManager.this.saveHistImage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public void plot(double[][] dArray, String string) {
        this.stg = new Plot(dArray[0], "Rec", "Recombination Rate Vs. Iterations");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.stg, "Center");
        JButton jButton = new JButton("Save image");
        jButton.addActionListener(this.listener);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add(jPanel2);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(500, 350));
        if (this.target != null) {
            this.target.dispose();
        }
        this.target = new JFrame("Structure Plotting: Recombination Rate - " + string);
        this.target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RecmbPlotManager.this.target.setVisible(false);
            }
        });
        this.target.setLocation(300, 200);
        this.target.getContentPane().add(jScrollPane);
        this.target.pack();
        this.target.setVisible(true);
    }

    public void plot(AppProc appProc) {
        this.proc = appProc;
        final Plot plot = new Plot(appProc, "Rec", 0, "Recombination Rate Vs. Iterations");
        plot.start();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(plot);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(500, 350));
        if (this.target != null) {
            this.target.dispose();
        }
        this.target = new JFrame("Structure Plotting: Recombination Rate");
        this.target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (plot != null) {
                    plot.stop();
                }
                RecmbPlotManager.this.target.setVisible(false);
            }
        });
        this.target.setLocation(300, 200);
        this.target.getContentPane().add(jScrollPane);
        this.target.pack();
        this.target.setVisible(true);
    }

    public void plotHist(double[][] dArray, String string) {
        HistPlot histPlot = new HistPlot(dArray[0], "Recombination rate", "Histogram");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBackground(Color.white);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        this.sth = histPlot.draw();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.sth, "Center");
        JButton jButton = new JButton("Save image");
        jButton.addActionListener(this.hlistener);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
        jPanel2.setPreferredSize(new Dimension(550, 350));
        jPanel.add(jPanel2);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(550, 360));
        if (this.target != null) {
            this.target.dispose();
        }
        this.target = new JFrame("Histogram of distribution of recombination rate - " + string);
        this.target.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RecmbPlotManager.this.target.setVisible(false);
            }
        });
        this.target.setLocation(300, 200);
        this.target.getContentPane().add(jScrollPane);
        this.target.pack();
        this.target.setVisible(true);
    }

    protected void saveCurveImage() {
        Object[] objectArray;
        Object object;
        Serializable serializable;
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        GeneralFileFilter generalFileFilter = new GeneralFileFilter("jpg", "JPEG image files");
        jFileChooser.addChoosableFileFilter(generalFileFilter);
        int n = jFileChooser.showDialog(this.target, "Save");
        if (n == 0) {
            serializable = jFileChooser.getSelectedFile();
            object = ((File)serializable).getAbsolutePath();
            if (!((String)object).endsWith(".jpg") && !((String)object).endsWith(".jpeg")) {
                serializable = new File(new String((String)object + ".jpg"));
            }
            if (((File)serializable).exists()) {
                objectArray = new Object[]{"Yes", "No "};
                int n2 = JOptionPane.showOptionDialog(this.target, "Target file " + ((File)serializable).getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                if (n2 == 1) {
                    return;
                }
            }
            if (!(objectArray = ((File)serializable).getParentFile()).canWrite()) {
                JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                return;
            }
            string = ((File)serializable).getAbsolutePath();
        }
        serializable = this.stg.getBounds();
        object = new BufferedImage(((Rectangle)serializable).width, ((Rectangle)serializable).height, 1);
        objectArray = (Graphics2D)((BufferedImage)object).getGraphics();
        objectArray.setBackground(Color.white);
        objectArray.setPaint(Color.white);
        objectArray.fill((Shape)((Object)serializable));
        this.stg.getComponent(0).paint((Graphics)objectArray);
        try {
            File file = new File(string);
            JimiRasterImage jimiRasterImage = Jimi.createRasterImage(((BufferedImage)object).getSource());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
            }
        }
        catch (JimiException jimiException) {
            jimiException.printStackTrace();
        }
    }

    protected void saveHistImage() {
        Object[] objectArray;
        Object object;
        Serializable serializable;
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showDialog(this.target, "Save");
        if (n == 0) {
            serializable = jFileChooser.getSelectedFile();
            object = ((File)serializable).getAbsolutePath();
            if (!((String)object).endsWith(".jpg") && !((String)object).endsWith(".jpeg")) {
                serializable = new File(new String((String)object + ".jpg"));
            }
            if (((File)serializable).exists()) {
                objectArray = new Object[]{"Yes", "No "};
                int n2 = JOptionPane.showOptionDialog(this.target, "Target file " + ((File)serializable).getName() + " already exists, Overwrite it?", "Save image", 0, 3, null, objectArray, objectArray[1]);
                if (n2 == 1) {
                    return;
                }
            }
            if (!(objectArray = ((File)serializable).getParentFile()).canWrite()) {
                JOptionPane.showMessageDialog(null, "Can not write image file: permission denied", "Error", 0);
                return;
            }
            string = ((File)serializable).getAbsolutePath();
        }
        serializable = this.sth.getBounds();
        object = new BufferedImage(((Rectangle)serializable).width, ((Rectangle)serializable).height, 1);
        objectArray = (Graphics2D)((BufferedImage)object).getGraphics();
        objectArray.setBackground(Color.white);
        this.sth.paint((Graphics)objectArray);
        try {
            File file = new File(string);
            JimiRasterImage jimiRasterImage = Jimi.createRasterImage(((BufferedImage)object).getSource());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                Jimi.putImage("image/jpeg", (JimiImage)jimiRasterImage, (OutputStream)fileOutputStream);
            }
        }
        catch (JimiException jimiException) {
            jimiException.printStackTrace();
        }
    }
}

