/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RstPlot {
    private boolean isInited = false;
    private Vector[] odata;
    private double[][] tdata;
    private int[] label;
    private String filename;
    private int[] popid;
    private Vector idvector;

    public RstPlot(String string) {
        this.filename = string;
    }

    private void initStorage(int n) {
        this.odata = new Vector[n];
        for (int i = 0; i < n; ++i) {
            this.odata[i] = new Vector();
        }
        this.tdata = new double[n][];
        this.idvector = new Vector();
        this.isInited = true;
        this.label = null;
        this.popid = null;
    }

    private void parseData() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            object2 = new InputStreamReader((InputStream)fileInputStream, "UTF8");
            object = new BufferedReader((Reader)object2);
            while ((n = ((Reader)object).read()) > -1) {
                stringBuffer.append((char)n);
            }
            ((Reader)object).close();
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = false;
        object2 = new String();
        object = new StringTokenizer(string, "\n");
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2 = ((StringTokenizer)object).nextToken();
            if (((String)object2).indexOf("Rep#") >= 0) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
            if (!stringTokenizer.hasMoreTokens() && bl) break;
            String string2 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (!string2.equals("") && string2.equals("Label") && stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equals("") && (string2.equals("(%Miss)") || string2.equals("(Miss)"))) {
                bl = true;
                continue;
            }
            if (!string2.equals("") && string2.equals("(%Miss)")) {
                bl = true;
                continue;
            }
            if (bl && string2.equals("Estimated")) break;
            if (!bl) continue;
            if (((String)object2).indexOf("|") < 0) {
                this.storeData((String)object2);
                continue;
            }
            this.storePopData((String)object2);
        }
    }

    private void storePopData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = false;
        if (!this.isInited) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            this.initStorage(n - 1);
            stringTokenizer = new StringTokenizer(string, "|");
        }
        double d = 1.0;
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf(":");
            if (n3 < 0) {
                this.odata[n - 1].addElement(Double.toString(d));
                return;
            }
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1, string2.length());
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
            String string5 = null;
            int n4 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
            }
            try {
                n4 = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (++n2 == 1) {
                this.idvector.addElement(string5);
                n = n4;
                continue;
            }
            stringTokenizer2 = new StringTokenizer(string4);
            double d2 = 0.0;
            int n5 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
                try {
                    double d3 = Double.parseDouble(string5);
                    d2 += d3 * Math.exp(Math.log(0.5) * (double)n5);
                    ++n5;
                }
                catch (Exception exception) {}
            }
            d -= d2;
            this.odata[n4 - 1].addElement(Double.toString(d2));
        }
    }

    private void storeData(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        int n2 = string.indexOf(":");
        String string3 = string.substring(n2 + 1, string.length());
        stringTokenizer = new StringTokenizer(string3);
        if (!this.isInited) {
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            stringTokenizer = new StringTokenizer(string3);
            this.initStorage(n);
        }
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            this.odata[n].addElement(string2);
            ++n;
        }
        String string4 = string.substring(0, n2);
        stringTokenizer = new StringTokenizer(string4);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        try {
            int n3 = Integer.parseInt(string2);
            this.idvector.addElement(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void analyzeData() {
        if (this.odata == null) {
            return;
        }
        int n = this.odata.length;
        if (n == 0) {
            return;
        }
        int n2 = this.odata[0].size();
        for (int i = 0; i < n; ++i) {
            this.tdata[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                try {
                    this.tdata[i][j] = Double.parseDouble((String)this.odata[i].elementAt(j));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public double[][] getData() {
        int n;
        this.odata = null;
        this.tdata = null;
        this.label = null;
        this.isInited = false;
        this.parseData();
        this.analyzeData();
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        int n2 = this.tdata.length;
        int n3 = this.tdata[0].length;
        double[][] dArrayArray = new double[n2][];
        for (n = 0; n < n2; ++n) {
            dArrayArray[n] = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArrayArray[n][i] = 1.0;
                if (n == 0) continue;
                for (int j = 0; j < n; ++j) {
                    double[] dArray = dArrayArray[n];
                    int n4 = i;
                    dArray[n4] = dArray[n4] - this.tdata[j][i];
                }
            }
        }
        this.label = new int[n3];
        for (n = 0; n < n3; ++n) {
            this.label[n] = n + 1;
        }
        if (this.tdata[0].length == this.idvector.size()) {
            this.popid = new int[this.idvector.size()];
            for (n = 0; n < this.popid.length; ++n) {
                try {
                    this.popid[n] = Integer.parseInt((String)this.idvector.elementAt(n));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return dArrayArray;
    }

    private void findPrimary(int[] nArray, int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(this.tdata[i][n] > d)) continue;
            d = this.tdata[i][n];
            n3 = i;
        }
        nArray[n] = n3;
    }

    private void sort(int n, int n2, Vector vector) {
        double d = this.tdata[n2][n];
        if (vector.size() == 0) {
            vector.addElement(new Integer(n));
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Integer n3 = (Integer)vector.elementAt(i);
            int n4 = n3;
            double d2 = this.tdata[n2][n4];
            if (!(d > d2)) continue;
            vector.insertElementAt(new Integer(n), i);
            return;
        }
        vector.addElement(new Integer(n));
    }

    public int[] getLabel() {
        return this.label;
    }

    public int[] getPopId() {
        return this.popid;
    }

    public double[][] sortData() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        int n5 = this.tdata.length;
        int n6 = this.tdata[0].length;
        boolean bl = false;
        if (this.idvector.size() == this.tdata[0].length) {
            this.popid = new int[this.tdata[0].length];
            bl = true;
        }
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            this.findPrimary(nArray, i, n5);
        }
        Vector[] vectorArray = new Vector[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            vectorArray[n4] = new Vector();
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                if (nArray[n3] != n4) continue;
                this.sort(n3, n4, vectorArray[n4]);
            }
        }
        double[][] dArrayArray = new double[n5][];
        for (n3 = 0; n3 < n5; ++n3) {
            dArrayArray[n3] = new double[n6];
        }
        n3 = 0;
        for (int i = 0; i < n5; ++i) {
            for (n2 = 0; n2 < vectorArray[i].size(); ++n2) {
                Integer n7 = (Integer)vectorArray[i].elementAt(n2);
                n = n7;
                for (int j = 0; j < n5; ++j) {
                    dArrayArray[j][n3] = this.tdata[j][n];
                }
                this.label[n3] = n + 1;
                if (bl) {
                    try {
                        this.popid[n3] = Integer.parseInt((String)this.idvector.elementAt(n));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n3;
            }
        }
        double[][] dArrayArray2 = new double[n5][];
        for (n2 = 0; n2 < n5; ++n2) {
            dArrayArray2[n2] = new double[n6];
            for (int i = 0; i < n6; ++i) {
                dArrayArray2[n2][i] = 1.0;
                if (n2 == 0) continue;
                for (n = 0; n < n2; ++n) {
                    double[] dArray = dArrayArray2[n2];
                    int n8 = i;
                    dArray[n8] = dArray[n8] - dArrayArray[n][i];
                }
            }
        }
        return dArrayArray2;
    }

    public double[][] groupData() {
        int n;
        Vector vector;
        Integer n2;
        int n3;
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        int n4 = this.tdata.length;
        int n5 = this.tdata[0].length;
        boolean bl = false;
        if (this.idvector.size() != this.tdata[0].length) {
            return this.getData();
        }
        Hashtable<Integer, Vector> hashtable = new Hashtable<Integer, Vector>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n3 = 0; n3 < this.idvector.size(); ++n3) {
            int n6 = -1;
            try {
                n6 = Integer.parseInt((String)this.idvector.elementAt(n3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer n7 = new Integer(n6);
            n2 = new Integer(n3);
            if (hashtable.containsKey(n7)) {
                vector = (Vector)hashtable.get(n7);
                vector.add(n2);
                continue;
            }
            vector = new Vector();
            vector.add(n2);
            hashtable.put(n7, vector);
            vector2.add(n7);
        }
        n3 = 0;
        this.popid = new int[n5];
        this.label = new int[n5];
        int[] nArray = new int[n5];
        Collections.sort(vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            n2 = (Integer)vector2.elementAt(i);
            vector = (Vector)hashtable.get(n2);
            for (n = 0; n < vector.size(); ++n) {
                nArray[n3] = (Integer)vector.elementAt(n);
                this.label[n3] = nArray[n3] + 1;
                this.popid[n3] = n2;
                ++n3;
            }
        }
        double[][] dArrayArray = new double[n4][];
        for (int i = 0; i < n4; ++i) {
            dArrayArray[i] = new double[n5];
            for (int j = 0; j < n5; ++j) {
                dArrayArray[i][j] = 1.0;
                if (i == 0) continue;
                for (n = 0; n < i; ++n) {
                    double[] dArray = dArrayArray[i];
                    int n8 = j;
                    dArray[n8] = dArray[n8] - this.tdata[n][nArray[j]];
                }
            }
        }
        return dArrayArray;
    }
}

