/*
 * Decompiled with CFR 0.152.
 */
package Triangle;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;

public class DataParser {
    private boolean isInited = false;
    private Vector[] odata;
    private double[][] tdata;
    private int[] id;
    private Vector idvector;
    private int[] label;
    private String filename;
    private boolean data_process;
    private int K;

    public DataParser(String string) {
        this.filename = string;
        this.data_process = false;
    }

    private void initStorage(int n) {
        this.odata = new Vector[n];
        for (int i = 0; i < n; ++i) {
            this.odata[i] = new Vector();
        }
        this.tdata = new double[n][];
        this.idvector = new Vector();
        this.isInited = true;
    }

    private void parseData() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            object2 = new InputStreamReader((InputStream)fileInputStream, "UTF8");
            object = new BufferedReader((Reader)object2);
            while ((n = ((Reader)object).read()) > -1) {
                stringBuffer.append((char)n);
            }
            ((Reader)object).close();
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = false;
        object2 = new String();
        object = new StringTokenizer(string, "\n");
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2 = ((StringTokenizer)object).nextToken();
            if (((String)object2).indexOf("Rep#") >= 0) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
            if (!stringTokenizer.hasMoreTokens() && bl) break;
            String string2 = "";
            if (((String)object2).indexOf("populations assumed") > 0) {
                string2 = stringTokenizer.nextToken();
                try {
                    this.K = Integer.parseInt(string2);
                }
                catch (Exception exception) {}
                continue;
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (!string2.equals("") && (string2.equals("(%Miss)") || string2.equals("(Miss)"))) {
                bl = true;
                continue;
            }
            if (!string2.equals("") && string2.equals("Label") && stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equals("") && (string2.equals("(%Miss)") || string2.equals("(Miss)"))) {
                bl = true;
                continue;
            }
            if (bl && (string2.equals("") || string2.equals("Estimated"))) break;
            if (!bl) continue;
            if (((String)object2).indexOf("|") < 0) {
                this.storeData((String)object2);
                continue;
            }
            this.storePopData((String)object2);
        }
    }

    private void storePopData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = false;
        if (!this.isInited) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            this.initStorage(n - 1);
            stringTokenizer = new StringTokenizer(string, "|");
        }
        double d = 1.0;
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf(":");
            if (n3 < 0) {
                this.odata[n - 1].addElement(Double.toString(d));
                return;
            }
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1, string2.length());
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
            String string5 = null;
            int n4 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
            }
            try {
                n4 = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (++n2 == 1) {
                this.idvector.addElement(string5);
                n = n4;
                continue;
            }
            stringTokenizer2 = new StringTokenizer(string4);
            double d2 = 0.0;
            int n5 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
                try {
                    double d3 = Double.parseDouble(string5);
                    d2 += d3 * Math.exp(Math.log(0.5) * (double)n5);
                    ++n5;
                }
                catch (Exception exception) {}
            }
            d -= d2;
            this.odata[n4 - 1].addElement(Double.toString(d2));
        }
    }

    private void storeData(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        int n2 = string.indexOf(":");
        String string3 = string.substring(n2 + 1, string.length());
        stringTokenizer = new StringTokenizer(string3);
        if (!this.isInited) {
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            stringTokenizer = new StringTokenizer(string3);
            this.initStorage(n);
        }
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            this.odata[n].addElement(string2);
            ++n;
        }
        String string4 = string.substring(0, n2);
        stringTokenizer = new StringTokenizer(string4);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        try {
            int n3 = Integer.parseInt(string2);
            this.idvector.addElement(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void analyzeData() {
        if (this.odata == null) {
            return;
        }
        int n = this.odata.length;
        if (n == 0) {
            return;
        }
        int n2 = this.odata[0].size();
        for (int i = 0; i < n; ++i) {
            this.tdata[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                try {
                    this.tdata[i][j] = Double.parseDouble((String)this.odata[i].elementAt(j));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public double[][] getData() {
        if (!this.data_process) {
            this.odata = null;
            this.tdata = null;
            this.label = null;
            this.isInited = false;
            this.parseData();
            this.analyzeData();
            this.data_process = true;
        }
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        return this.tdata;
    }

    public int[] getId() {
        if (!this.data_process) {
            this.odata = null;
            this.tdata = null;
            this.label = null;
            this.isInited = false;
            this.parseData();
            this.analyzeData();
            this.data_process = true;
        }
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        if (this.tdata[0].length != this.idvector.size()) {
            if (this.idvector.size() != 0) {
                System.err.println(this.tdata[0].length + "  " + this.idvector.size());
            }
            return null;
        }
        this.id = new int[this.idvector.size()];
        for (int i = 0; i < this.id.length; ++i) {
            try {
                this.id[i] = Integer.parseInt((String)this.idvector.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.id;
    }

    public int getK() {
        if (!this.data_process) {
            this.odata = null;
            this.tdata = null;
            this.label = null;
            this.isInited = false;
            this.parseData();
            this.analyzeData();
            this.data_process = true;
        }
        return this.K;
    }
}

