/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.EditableLabel;
import jas.plot.FontMenuItem;
import jas.plot.LegendEntry;
import jas.plot.LegendLayout;
import jas.plot.MovableObject;
import jas.plot.MutableLegendEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;

public class Legend
extends MovableObject {
    private static final Dimension preferredIconSize = new Dimension(15, 15);

    public Legend() {
        super("Legend");
        this.setLayout(new LegendLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void add(final LegendEntry legendEntry) {
        super.add(new LegendComponent(legendEntry));
        EditableLabel editableLabel = new EditableLabel(legendEntry.getTitle(), "Legend Entry", 2){

            protected void fireActionPerformed() {
                super.fireActionPerformed();
                if (legendEntry instanceof MutableLegendEntry) {
                    ((MutableLegendEntry)legendEntry).setTitle(this.getText());
                }
            }
        };
        editableLabel.setShowFontMenuItem(false);
        super.add(editableLabel);
    }

    public void remove(LegendEntry legendEntry) {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof LegendComponent && ((LegendComponent)component).le == legendEntry) {
                this.remove(n2);
                this.remove(n2);
                return;
            }
            ++n2;
        }
    }

    public void clear() {
        this.removeAll();
    }

    public int getNEntries() {
        return this.getComponentCount() / 2;
    }

    public String getCurrentTitle(int n) {
        LegendEntry legendEntry = ((LegendComponent)this.getComponent((int)(2 * n))).le;
        return legendEntry.getTitle();
    }

    public boolean isTitleChanged(int n) {
        LegendEntry legendEntry = ((LegendComponent)this.getComponent((int)(2 * n))).le;
        if (legendEntry instanceof MutableLegendEntry) {
            return ((MutableLegendEntry)legendEntry).titleIsChanged();
        }
        return false;
    }

    public void setCurrentTitle(int n, String string) {
        LegendEntry legendEntry = ((LegendComponent)this.getComponent((int)(2 * n))).le;
        if (legendEntry instanceof MutableLegendEntry) {
            ((MutableLegendEntry)legendEntry).setTitle(string);
        }
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new FontMenuItem(this, this.getPrefix()));
        super.modifyPopupMenu(jPopupMenu, component);
    }

    public void setFont(Font font) {
        super.setFont(font);
        int n = this.getComponentCount();
        int n2 = 1;
        while (n2 < n) {
            this.getComponent(n2).setFont(font);
            n2 += 2;
        }
    }

    public void legendTextChanged() {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            LegendComponent legendComponent = (LegendComponent)this.getComponent(n2++);
            EditableLabel editableLabel = (EditableLabel)this.getComponent(n2++);
            editableLabel.setText(legendComponent.le.getTitle());
        }
    }

    private class LegendComponent
    extends Component {
        LegendEntry le;

        LegendComponent(LegendEntry legendEntry) {
            this.le = legendEntry;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.le.paintIcon(graphics, dimension.width, dimension.height);
        }

        public Dimension getPreferredSize() {
            return preferredIconSize;
        }
    }
}

