/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Finishable;
import jas.util.HasNextPages;
import jas.util.JASWizard;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;

public abstract class JASWizardPage
extends JPanel
implements KeyListener {
    private JASWizardPage m_prev = null;
    private JASWizard m_wizard;
    private JASWizardPage[] m_nextWizardPages = null;
    private final boolean m_isFinishable = this instanceof Finishable;
    private final boolean m_hasNextPages = this instanceof HasNextPages;
    static int pageNumber = 0;
    private String m_number;

    public JASWizardPage(LayoutManager layoutManager) {
        super(layoutManager);
    }

    final JASWizardPage getPrev() {
        return this.m_prev;
    }

    final void addTo(Container container, JASWizard jASWizard, JASWizardPage jASWizardPage) {
        this.m_number = String.valueOf(pageNumber++);
        container.add(this.m_number, this);
        if (this.m_hasNextPages) {
            this.m_nextWizardPages = ((HasNextPages)((Object)this)).getNextWizardPages();
            if (this.m_nextWizardPages != null) {
                int n = 0;
                while (n < this.m_nextWizardPages.length) {
                    if (this.m_nextWizardPages[n] != null) {
                        this.m_nextWizardPages[n].addTo(container, jASWizard, this);
                    }
                    ++n;
                }
            }
        }
        this.m_wizard = jASWizard;
        this.m_prev = jASWizardPage;
    }

    protected boolean getNextEnabled() {
        return this.m_hasNextPages;
    }

    protected boolean getFinishEnabled() {
        return this.m_isFinishable;
    }

    protected void doEnable() {
        this.m_wizard.setNextEnabled(this.getNextEnabled());
        this.m_wizard.setFinishEnabled(this.getFinishEnabled());
        this.m_wizard.doPrevEnabled();
        if (this.m_isFinishable && this.m_hasNextPages) {
            this.m_wizard.setDefaultButton();
        }
    }

    final void clear() {
        if (this.m_hasNextPages) {
            int n = 0;
            while (n < this.m_nextWizardPages.length) {
                if (this.m_nextWizardPages[n] != null) {
                    this.m_nextWizardPages[n].clear();
                }
                ++n;
            }
            this.m_nextWizardPages = null;
        }
        this.m_prev = null;
        this.m_wizard = null;
    }

    public String toString() {
        return this.m_number;
    }

    protected void dispose() {
        this.m_wizard.dispose();
    }

    final void doCancel() {
        if (this.m_nextWizardPages != null) {
            int n = 0;
            while (n < this.m_nextWizardPages.length) {
                if (this.m_nextWizardPages[n] != null) {
                    this.m_nextWizardPages[n].doCancel();
                }
                ++n;
            }
        }
        this.onCancel();
    }

    public void onCancel() {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 10) {
            this.doEnable();
        }
    }

    final boolean isFinishable() {
        return this.m_isFinishable;
    }

    final boolean hasNextPages() {
        return this.m_hasNextPages;
    }

    public void beforeShowing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBusy(Runnable runnable) {
        this.m_wizard.setToWaitCursor();
        try {
            runnable.run();
            Object var3_2 = null;
            this.m_wizard.setToDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_wizard.setToDefaultCursor();
            throw throwable;
        }
    }

    protected void handleError(String string, Throwable throwable) {
        this.m_wizard.handleError(string, throwable);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

