/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.util.pluginmanager.VersionNumberCompare;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AppVersionCheck
implements ActionListener {
    private JButton checknow;
    private JCheckBox checkdevelopers;
    private JCheckBox checknondevelopers;
    private JCheckBox checkstartno;
    private JCheckBox checkstartyes;
    private JOptionPane updatepane;
    private JPanel panel;
    private Container container;
    private String latestversion;
    private String appname;
    private String versionURL;
    private String currentversion;
    private Properties userprops;
    private int whichmessage;
    boolean developers;
    private static final String unknown = "unknown";

    public AppVersionCheck(String string, String string2, String string3, Properties properties) {
        this.userprops = properties;
        this.appname = string != null ? string : unknown;
        this.versionURL = string2 != null ? string2 : unknown;
        this.currentversion = string3 != null ? string3 : unknown;
    }

    public JPanel getVersionCheckOptionPane() {
        this.panel = new JPanel(new GridLayout(7, 0));
        this.checknow = new JButton("Check For New Version Now...");
        this.checknow.addActionListener(this);
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.checknow);
        box.add(Box.createGlue());
        JLabel jLabel = new JLabel("Would you like " + this.appname + " to check for a new application version each time the application starts?");
        JLabel jLabel2 = new JLabel("When checking for a new version would you like to check for production or development releases?");
        this.checknondevelopers = new JCheckBox("Only check for new " + this.appname + " production release versions.");
        this.checkdevelopers = new JCheckBox("Check for new development and production releases of " + this.appname + ".");
        this.checkstartno = new JCheckBox("No, do not check at start up.");
        this.checkstartno.addActionListener(this);
        this.checkstartyes = new JCheckBox("Yes, check at start up");
        this.checkstartyes.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkdevelopers);
        buttonGroup.add(this.checknondevelopers);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.checkstartno);
        buttonGroup2.add(this.checkstartyes);
        if (this.userprops.getProperty("DeveloperVersion", "false").equals("true")) {
            this.checkdevelopers.setSelected(true);
        } else {
            this.checknondevelopers.setSelected(true);
        }
        if (this.userprops.getProperty("UpdateOnStart", "true").equals("true")) {
            this.checkstartyes.setSelected(true);
        } else {
            this.checkstartno.setSelected(true);
        }
        this.panel.add(jLabel);
        this.panel.add(this.checkstartno);
        this.panel.add(this.checkstartyes);
        this.panel.add(jLabel2);
        this.panel.add(this.checknondevelopers);
        this.panel.add(this.checkdevelopers);
        this.panel.add(box);
        return this.panel;
    }

    private String getLatestVersion(boolean bl) {
        if (this.versionURL.equals(unknown)) {
            return unknown;
        }
        try {
            String string;
            URL uRL = new URL(this.versionURL);
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = unknown;
            String string3 = unknown;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                if (string2 == unknown) {
                    string2 = string;
                    continue;
                }
                string3 = string;
            }
            bufferedReader.close();
            return bl ? string3 : string2;
        }
        catch (Exception exception) {
            return unknown;
        }
    }

    public int testCurrentVersion() {
        this.developers = false;
        this.developers = this.checkdevelopers != null ? this.checkdevelopers.isSelected() : new Boolean(this.userprops.getProperty("DeveloperVersion")).booleanValue();
        this.latestversion = this.getLatestVersion(this.developers);
        VersionNumberCompare versionNumberCompare = new VersionNumberCompare();
        try {
            this.whichmessage = versionNumberCompare.compareVersions(this.currentversion, this.latestversion, true);
        }
        catch (VersionNumberCompare.VersionCompareException versionCompareException) {
            this.whichmessage = 0;
        }
        return this.whichmessage;
    }

    public void showUpdateDialog(Container container, boolean bl, boolean bl2) {
        this.container = container;
        if (this.latestversion.equals(unknown) && bl) {
            return;
        }
        String string = null;
        String string2 = "Application Version Check Dialog";
        if (this.whichmessage == 1 & this.developers) {
            int n;
            int n2;
            string = this.appname + " developement release version " + this.latestversion + " is available. You are currently running " + this.appname + " version " + this.currentversion + ". Would you like to update " + this.appname + "?";
            int n3 = JOptionPane.showConfirmDialog(this.container, string, string2, n2 = 1, n = 3);
            if (n3 == 0) {
                this.createDownloadUpdatesDialog();
            }
        } else if (this.whichmessage == 1 & !this.developers) {
            int n;
            int n4;
            string = this.appname + " production release version " + this.latestversion + " is available. You are currently running " + this.appname + " version " + this.currentversion + ". Would you like to update " + this.appname + "?";
            int n5 = JOptionPane.showConfirmDialog(this.container, string, string2, n4 = 1, n = 3);
            if (n5 == 0) {
                this.createDownloadUpdatesDialog();
            }
        } else if (this.whichmessage == 2 && !bl2) {
            string = this.developers ? "You are currently running " + this.appname + " version " + this.currentversion + ", which is the latest developers version." : "You are currently running " + this.appname + " version " + this.currentversion + ", which is the latest production release version.";
            int n = 2;
            int n6 = 1;
            int n7 = JOptionPane.showConfirmDialog(this.container, string, string2, n, n6);
        } else if (this.whichmessage == 0) {
            if (bl) {
                return;
            }
            string = "User version: " + this.currentversion + ". Newest version: " + this.latestversion + ". " + this.appname + " version comparison error!!";
            int n = 2;
            int n8 = 1;
            int n9 = JOptionPane.showConfirmDialog(this.container, string, string2, n, n8);
        }
    }

    private void createDownloadUpdatesDialog() {
        String string = "To update " + this.appname + " to version " + this.latestversion + " go to http://jas.freehep.org/downloads.htm.";
        String string2 = "Retrieving Updates Dialog";
        int n = 2;
        int n2 = 1;
        int n3 = JOptionPane.showConfirmDialog(this.container, string, string2, n, n2);
    }

    private void createCheckNowButtonPane() {
        String string = "Check Now Dialog";
        String string2 = "Before " + this.appname + " can check for new releases you need to select either the developer or production release version check box.";
        int n = 2;
        int n2 = 1;
        int n3 = JOptionPane.showConfirmDialog(this.container, string2, string, n, n2);
    }

    public void setUserProperties() {
        if (this.checkstartno.isSelected()) {
            this.userprops.put("UpdateOnStart", "false");
        } else if (this.checkstartyes.isSelected()) {
            this.userprops.put("UpdateOnStart", "true");
        }
        if (this.checknondevelopers.isSelected()) {
            this.userprops.put("DeveloperVersion", "false");
        } else if (this.checkdevelopers.isSelected()) {
            this.userprops.put("DeveloperVersion", "true");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.checknow)) {
            if (this.checkdevelopers.isSelected() | this.checknondevelopers.isSelected()) {
                this.testCurrentVersion();
                this.showUpdateDialog(this.checknow.getParent(), false, false);
            } else {
                this.createCheckNowButtonPane();
            }
        } else if (actionEvent.getSource().equals(this.checkstartyes) && !this.checkdevelopers.isSelected() && !this.checknondevelopers.isSelected()) {
            this.checknondevelopers.setSelected(true);
        }
    }
}

