/*
 * Decompiled with CFR 0.152.
 */
package jas.util.rmi;

import jas.util.rmi.Preemptable;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RemoteEventReceiver;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class RMIEventQueue
extends Thread {
    private RemoteEventReceiver receiver;
    private Vector m_obs = new Vector();

    public RMIEventQueue(RemoteEventReceiver remoteEventReceiver) {
        this.receiver = remoteEventReceiver;
        this.start();
    }

    public void dispose() {
        Enumeration enumeration = this.m_obs.elements();
        while (enumeration.hasMoreElements()) {
            RMIObserver rMIObserver = (RMIObserver)enumeration.nextElement();
            rMIObserver.stop();
        }
        this.interrupt();
    }

    public Observer setEventSource(RMIDestination rMIDestination) {
        RMIObserver rMIObserver = new RMIObserver(rMIDestination);
        this.m_obs.addElement(rMIObserver);
        return rMIObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                while (true) {
                    int n;
                    Serializable[] serializableArray;
                    Object object;
                    boolean bl = false;
                    RMIEventQueue rMIEventQueue = this;
                    synchronized (rMIEventQueue) {
                        Enumeration enumeration = this.m_obs.elements();
                        while (enumeration.hasMoreElements()) {
                            object = (RMIObserver)enumeration.nextElement();
                            bl = ((RMIObserver)object).hasMessages();
                            if (bl) break;
                        }
                        if (!bl) {
                            this.wait();
                        }
                    }
                    int n2 = 0;
                    object = this.m_obs.elements();
                    while (object.hasMoreElements()) {
                        serializableArray = (Serializable[])object.nextElement();
                        n = serializableArray.getNUpdates();
                        if (n <= 0) continue;
                        n2 += n + 1;
                    }
                    if (n2 == 0) continue;
                    serializableArray = new Serializable[n2];
                    n = 0;
                    object = this.m_obs.elements();
                    while (object.hasMoreElements()) {
                        RMIObserver rMIObserver = (RMIObserver)object.nextElement();
                        Vector vector = rMIObserver.getUpdates();
                        if (vector.isEmpty()) continue;
                        serializableArray[n++] = rMIObserver.getDestination();
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            serializableArray[n++] = (Serializable)enumeration.nextElement();
                        }
                    }
                    this.receiver.remoteUpdate(serializableArray);
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("RMIEventQueue Thread terminating");
                this.receiver = null;
                Object var11_14 = null;
                this.receiver = null;
                this.m_obs = null;
            }
            catch (RemoteException remoteException) {
                System.out.println("Error dispatching events " + remoteException);
                Object var11_15 = null;
                this.receiver = null;
                this.m_obs = null;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.receiver = null;
            this.m_obs = null;
            throw throwable;
        }
    }

    private class RMIObserver
    implements Observer {
        private boolean stopped = false;
        private Vector m_active = new Vector();
        private Vector m_queue = new Vector();
        private Vector m_result = new Vector();
        private RMIDestination dest;

        RMIObserver(RMIDestination rMIDestination) {
            this.dest = rMIDestination;
        }

        RMIDestination getDestination() {
            return this.dest;
        }

        void stop() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable observable, Object object) {
            if (this.stopped) {
                return;
            }
            if (object instanceof Serializable) {
                boolean bl = this.m_active.isEmpty();
                this.m_active.addElement(object);
                if (bl) {
                    RMIEventQueue rMIEventQueue = RMIEventQueue.this;
                    synchronized (rMIEventQueue) {
                        RMIEventQueue.this.notifyAll();
                    }
                }
            } else {
                throw new RuntimeException("Argument for RMIObserver not serializable");
            }
        }

        boolean hasMessages() {
            return !this.stopped && !this.m_active.isEmpty();
        }

        int getNUpdates() {
            this.m_result.removeAllElements();
            if (this.m_active.isEmpty()) {
                return 0;
            }
            Vector vector = this.m_active;
            this.m_queue.removeAllElements();
            this.m_active = this.m_queue;
            this.m_queue = vector;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                Serializable serializable = (Serializable)vector.elementAt(n2);
                if (serializable instanceof Preemptable) {
                    Preemptable preemptable = (Preemptable)((Object)serializable);
                    int n3 = n2 + 1;
                    while (n3 < n) {
                        if (!preemptable.preemptedBy(vector.elementAt(n3))) {
                            ++n3;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.m_result.addElement(serializable);
                }
                ++n2;
            }
            return this.m_result.size();
        }

        Vector getUpdates() {
            return this.m_result;
        }
    }
}

