/*
 * Decompiled with CFR 0.152.
 */
package jas.util.tree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TreeItem
implements Externalizable,
Cloneable {
    public String[] path;
    public String type;
    public int flags;
    public static final int HAS_SUB_ITEMS = 1;
    public static final int DELETED = 2;
    public static final int FOLDER = 4;

    public TreeItem() {
    }

    public TreeItem(String string) {
        String[] stringArray = new String[]{string};
        this.path = stringArray;
    }

    public TreeItem(String string, String string2) {
        this(string, string2, 0);
    }

    public TreeItem(String string, String string2, int n) {
        String[] stringArray = new String[]{string};
        this.path = stringArray;
        this.type = string2;
        this.flags = n;
    }

    public TreeItem(String[] stringArray, String string, int n) {
        this.path = stringArray;
        this.type = string;
        this.flags = n;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.path = (String[])objectInput.readObject();
        this.type = (String)objectInput.readObject();
        this.flags = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.path);
        objectOutput.writeObject(this.type);
        objectOutput.writeInt(this.flags);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreeItem)) {
            return false;
        }
        TreeItem treeItem = (TreeItem)object;
        if (treeItem.path.length != this.path.length) {
            return false;
        }
        if (this.path == null || treeItem.path == null) {
            return this.path == treeItem.path;
        }
        int n = 0;
        while (n < this.path.length) {
            if (!this.path[n].equals(treeItem.path[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.path != null) {
            int n2 = 0;
            while (n2 < this.path.length) {
                n += this.path[n2].hashCode();
                ++n2;
            }
        }
        return n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.path.length) {
            string = string + "/" + this.path[n];
            ++n;
        }
        string = string + " [ type=" + this.type + " flags=" + Integer.toHexString(this.flags) + " ]";
        return string;
    }
}

