#include "manual_input.h"
#include "ui_manual_input.h"
#include "vector.h"
#include "map.h"
#include "string.h"
#include <stdio.h>
#include <sstream>
#include "tokenscanner.h"
#include <sstream>

Manual_Input::Manual_Input(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Manual_Input)
{
    ui->setupUi(this);
}

Manual_Input::~Manual_Input()
{
    delete ui;
}

void Manual_Input::on_numSpeciesBox_valueChanged(int arg1)
{
    numSpecies = arg1;
}

void Manual_Input::on_treebox_textChanged(const QString &arg1)
{
    int numSpcheck = numSpecies;
    string temp = arg1.toStdString();
    if(temp[0] != '\"'){
        ui->treestatus->setText(QString::fromStdString("Tree doesn't start with a quote."));
    }
    else if(temp[temp.size()-1] != '\"'){
        ui->treestatus->setText(QString::fromStdString("Tree doesn't end with a quote."));
    }
    else if(temp[1] != '('){
        ui->treestatus->setText(QString::fromStdString("For tree, open paren doesn't follow quote."));
    }
    else if(temp[temp.size() - 2] != ')'){
        ui->treestatus->setText(QString::fromStdString("For tree, quote doesn't follow closed paren."));
    }
    else{
        //Now we step through the rest of the string counting parens
        int openParen, closedParen, numSpecFromChar;
        openParen = 0;
        closedParen = 0;
        numSpecFromChar = 0;
        for(size_t i = 1; i < temp.size() - 1; ++i){
            if(temp[i] == '(') openParen++;
            else if(temp[i] == ')') closedParen++;
            else numSpecFromChar++;
        }
        if(openParen != closedParen){
            ui->treestatus->setText(QString::fromStdString("Parentheses don't match"));
        }
        else if(openParen != numSpcheck - 1){
            ui->treestatus->setText(QString::fromStdString("Number of parens doesn't correspond to number of species.  If you change the number of species, please also re-type the last part of the tree."));
        }
        else if(numSpecFromChar != numSpcheck){
            ui->treestatus->setText(QString::fromStdString("Number of species doesn't match number of labels in tree.  If you change the number of species, please also re-type the last part of the tree."));
        }
        else{
            treestr = temp;
            ui->treestatus->setText("Tree verified.");
        }
    }
}

void Manual_Input::on_Sbox_textChanged(const QString &arg1)
{
    string temp = arg1.toStdString();
    int slashcounter = 0;
    int numbercounter = 0;
    TokenScanner scanner;
    scanner.ignoreWhitespace();
    scanner.scanNumbers();
    scanner.scanStrings();
    scanner.setInput(temp);
    string currtoken;
    currtoken = scanner.nextToken();
    if(scanner.getTokenType(currtoken) != NUMBER){
        ui->ssamplestatus->setText("Failure to find number in S sample sizes");
    }
    else{
        numbercounter++;
        while(scanner.hasMoreTokens()){
            currtoken = scanner.nextToken();
            if(currtoken != "/"){
                ui->ssamplestatus->setText("Failure to find slash in S sample sizes");
                break;
            }
            else{
                slashcounter++;
                if(!scanner.hasMoreTokens()){
                    ui->ssamplestatus->setText("S samples end in slash");
                    break;
                }
                else{
                    currtoken = scanner.nextToken();
                    if(scanner.getTokenType(currtoken) != NUMBER){
                        ui->ssamplestatus->setText("Failure to find number in S sample sizes");
                        break;
                    }
                    else{
                        numbercounter++;
                        continue;
                    }
                }
            }
        }
        if(numbercounter != numSpecies){
            ui->ssamplestatus->setText("Mismatch between number of species and number of S sample sizes.");
        }
        else if(slashcounter != numSpecies - 1){
            ui->ssamplestatus->setText("Mismatch between number of species and number of slashes in S sample sizes.");
        }
        else{
            ui->ssamplestatus->setText("S sample sizes verified.");
            initialSstr = arg1.toStdString();
        }
    }
}

void Manual_Input::on_Cbox_textChanged(const QString &arg1)
{
    string temp = arg1.toStdString();
    int slashcounter = 0;
    int numbercounter = 0;
    TokenScanner scanner;
    scanner.ignoreWhitespace();
    scanner.scanNumbers();
    scanner.scanStrings();
    scanner.setInput(temp);
    string currtoken;
    currtoken = scanner.nextToken();
    if(scanner.getTokenType(currtoken) != NUMBER){
        ui->csamplestatus->setText("Failure to find number in C sample sizes");
    }
    else{
        numbercounter++;
        while(scanner.hasMoreTokens()){
            currtoken = scanner.nextToken();
            if(currtoken != "/"){
                ui->csamplestatus->setText("Failure to find slash in C sample sizes");
                break;
            }
            else{
                slashcounter++;
                if(!scanner.hasMoreTokens()){
                    ui->csamplestatus->setText("C samples end in slash");
                    break;
                }
                else{
                    currtoken = scanner.nextToken();
                    if(scanner.getTokenType(currtoken) != NUMBER){
                        ui->csamplestatus->setText("Failure to find number in C sample sizes");
                        break;
                    }
                    else{
                        numbercounter++;
                        continue;
                    }
                }
            }
        }
        if(numbercounter != numSpecies){
            ui->csamplestatus->setText("Mismatch between number of species and number of C sample sizes.");
        }
        else if(slashcounter != numSpecies - 1){
            ui->csamplestatus->setText("Mismatch between number of species and number of slashes in C sample sizes.");
        }
        else{
            ui->csamplestatus->setText("C sample sizes verified.");
            initialCstr = arg1.toStdString();
        }
    }
}

void Manual_Input::on_Tbox_textChanged(const QString &arg1)
{
    string temp = arg1.toStdString();
    int slashcounter = 0;
    int numbercounter = 0;
    TokenScanner scanner;
    scanner.ignoreWhitespace();
    scanner.scanNumbers();
    scanner.scanStrings();
    scanner.setInput(temp);
    string currtoken;
    currtoken = scanner.nextToken();
    if(scanner.getTokenType(currtoken) != NUMBER){
        ui->branchlengthstatus->setText("Failure to find number in branch lengths");
    }
    else{
        numbercounter++;
        while(scanner.hasMoreTokens()){
            currtoken = scanner.nextToken();
            if(currtoken != "/"){
                ui->branchlengthstatus->setText("Failure to find slash in branch lengths");
                break;
            }
            else{
                slashcounter++;
                if(!scanner.hasMoreTokens()){
                    ui->branchlengthstatus->setText("Branch lengths end in slash");
                    break;
                }
                else{
                    currtoken = scanner.nextToken();
                    if(scanner.getTokenType(currtoken) != NUMBER){
                        ui->branchlengthstatus->setText("Failure to find number in branch lengths");
                        break;
                    }
                    else{
                        numbercounter++;
                        continue;
                    }
                }
            }
        }
        if(numbercounter != 2*numSpecies-1){
            ui->branchlengthstatus->setText("Mismatch between number of species and number of branch lengths.");
        }
        else if(slashcounter != 2*numSpecies - 2){
            ui->branchlengthstatus->setText("Mismatch between number of species and number of slashes in branch lengths.");
        }
        else{
            ui->branchlengthstatus->setText("Branch lengths verified.");
            timesstr = arg1.toStdString();
        }
    }
}

void Manual_Input::on_chooseCalcBox_currentIndexChanged(int index)
{
    calculation = index;
    if(index != 1){
        if(index == 2){
            ui->treebox->setText(QString::fromStdString("\"(AB)\""));
            ui->numSpeciesBox->setValue(2);
            ui->Sbox->setText(QString::fromStdString("/"));
            ui->Tbox->setText(QString::fromStdString("/5001/"));
        }
        else if(index == 3){
            ui->treebox->setText(QString::fromStdString("\"((AB)C)\""));
            ui->numSpeciesBox->setValue(3);
            ui->Sbox->setText(QString::fromStdString("//"));
            ui->Tbox->setText(QString::fromStdString("///5001/"));
        }
        else if(index == 4){
            ui->treebox->setText(QString::fromStdString("\"((AB)(CD))\""));
            ui->numSpeciesBox->setValue(4);
            ui->Sbox->setText(QString::fromStdString("///"));
            ui->Tbox->setText(QString::fromStdString("///5001///"));
        }
        else if(index == 5){
            ui->treebox->setText(QString::fromStdString("\"((((AB)C)D)\""));
            ui->numSpeciesBox->setValue(4);
            ui->Sbox->setText(QString::fromStdString("///"));
            ui->Tbox->setText(QString::fromStdString("/////5001/"));
        }
        else{
            error("undefined calculation");
        }
    }
}


void Manual_Input::on_handRunButton_clicked()
{
    if(calculation == 0){
        ui->generalstatus->setText(QString::fromStdString("Please choose a calculation."));
    }
    else{
        if(numSpecies == 0){
            ui->generalstatus->setText(QString::fromStdString("Please set number of species."));
        }
        else{
            if(treestr == "not set"){
                ui->generalstatus->setText(QString::fromStdString("Please input a species tree."));
            }
            else{
                if(initialSstr == "not set" || (calculation == 1 && initialCstr == "not set")){
                    ui->generalstatus->setText(QString::fromStdString("Please input S samples (and C samples if appropriate)."));
                }
                else{
                    // Finally, we check to see if there's a monophyly condition
                    if(monocondstr == "not set" && calculation == 1){
                        ui->generalstatus->setText(QString::fromStdString("Please set monophyly condition."));
                    }
                    else{
                        //Now I think we are ready to go.
                        ui->generalstatus->clear();
                        string numS = integerToString(numSpecies);
                        stringstream relay;
                        string Cstr, mcstr;
                        if(calculation == 1){
                            Cstr = initialCstr;
                            mcstr = monocondstr;
                        }
                        else{
                            Cstr.clear();
                            mcstr.clear();
                        }
                        relay << numS << " " << treestr << " " << initialSstr << " " << Cstr << " " << timesstr << " " << mcstr;
                        relayqstr = QString::fromStdString(relay.str());
                        relayed = true;
                        //cout << relayqstr.toStdString() << endl;
                        ui->generalstatus->setText("Input constructed and sent. Press <Run> in the main window to perform the calculation.");
                    }
                }
            }
        }
    }
}



void Manual_Input::on_monocondbox_currentTextChanged(const QString &arg1)
{
    monocondstr = arg1.toStdString();
}

void Manual_Input::on_handCancelButton_clicked()
{
    relayed = false;
    std::string cancelledstr = "Cancelled.  Input not constructed.  You are now free to input from file.";
    QString cancelled = QString::fromStdString(cancelledstr);
    ui->generalstatus->setText(cancelled);
}
