#ifndef MANUAL_INPUT_H
#define MANUAL_INPUT_H

#include <QWidget>
//#include "tokenscanner.h"
#include <QString>

namespace Ui {
class Manual_Input;
}

class Manual_Input : public QWidget
{
    Q_OBJECT

public:
    explicit Manual_Input(QWidget *parent = 0);
    ~Manual_Input();
    bool relayed = false;
    QString relayqstr;
    int calculation = 0;

private slots:
    void on_numSpeciesBox_valueChanged(int arg1);

    void on_treebox_textChanged(const QString &arg1);

    void on_Sbox_textChanged(const QString &arg1);

    void on_Cbox_textChanged(const QString &arg1);

    void on_Tbox_textChanged(const QString &arg1);

    void on_chooseCalcBox_currentIndexChanged(int index);

    void on_handRunButton_clicked();

    void on_monocondbox_currentTextChanged(const QString &arg1);

    void on_handCancelButton_clicked();

private:
    Ui::Manual_Input *ui;
    int numSpecies = 0; //Starts at 0 so that we know when the value (>=1) has been chosen
    std::string treestr = "not set", initialSstr = "not set", initialCstr = "not set", timesstr = "not set", monocondstr = "not set";
    bool treebool, initialSbool, initialCbool, timesbool, monocondbool;

};

#endif // MANUAL_INPUT_H
