#ifndef VERIFY_H
#define VERIFY_H

#include "strlib.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "string.h"
#include "vector.h"
#include "tokenscanner.h"
#include <sstream>
#include <QString>

bool verifyTree(string tree, Ui::MainWindow *ui, int counter, int numS){
    stringstream errorsstr;
    string temp = tree;
    if(temp[0] != '\"'){
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": tree <"<< tree << "> doesn't start with a quote.";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    else if(temp[temp.size()-1] != '\"'){
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": tree <"<< tree << "> doesn't end with a quote.";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    else if(temp[1] != '('){
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": for tree <"<< tree << ">, open paren doesn't follow quote";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    else if(temp[temp.size() - 2] != ')'){
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": for tree <"<< tree << ">, quote doesn't follow closed paren.";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    else{
        //Now we step through the rest of the string counting parens
        int openParen, closedParen, numSpecFromChar;
        openParen = 0;
        closedParen = 0;
        numSpecFromChar = 0;
        for(size_t i = 1; i < temp.size() - 1; ++i){
            if(temp[i] == '(') openParen++;
            else if(temp[i] == ')') closedParen++;
            else numSpecFromChar++;
        }
        if(openParen != closedParen){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": for tree <"<< tree << ">, parentheses don't match.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
        else if(openParen != numS - 1){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": for tree <"<< tree << ">, number of parentheses doesn't correspond to number of species.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
        else if(numSpecFromChar != numS){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": for tree <"<< tree << ">, number of species labels doesn't correspond to number of species.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
        else return true;
    }
}

bool verifySamples(TokenScanner& scanner, Ui::MainWindow *ui, int counter, int numS, Vector<int>& samplevec){
    samplevec.clear(); // Just in case.
    stringstream errorsstr;
    string nextoken;
    for(int i = 0; i < numS - 1; i++){
        nextoken = scanner.nextToken();
        //cout << nextoken << endl;
        if(!stringIsInteger(nextoken)){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": expected integer in S samples, got <" << nextoken << "> instead.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
        samplevec.add(stringToInteger(nextoken));
        nextoken = scanner.nextToken();
        //cout << nextoken << endl;
        if(nextoken != "/"){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": expected slash in S samples, got <" << nextoken << "> instead.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
    }
    nextoken = scanner.nextToken();
    //cout << nextoken << endl;
    if(!stringIsInteger(nextoken)){
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": expected integer in S samples, got <" << nextoken << "> instead.";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    samplevec.add(stringToInteger(nextoken));
    return true;
}

bool verifyTimes(TokenScanner& scanner, Ui::MainWindow *ui, int counter, int numS, Vector<double>& timevec){
    timevec.clear(); // Just in case.
    stringstream errorsstr;
    string nextoken;
    for(int i = 0; i < 2*numS - 2; i++){
        nextoken = scanner.nextToken();
        //cout << nextoken << endl;
        if(!stringIsReal(nextoken)){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": expected integer in S samples, got <" << nextoken << "> instead.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
        timevec.add(stringToReal(nextoken));
        nextoken = scanner.nextToken();
        //cout << nextoken << endl;
        if(nextoken != "/"){
            errorsstr.str(std::string());
            errorsstr << "Error line " << counter + 3 << ": expected slash in S samples, got <" << nextoken << "> instead.";
            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
            return false;
        }
    }
    nextoken = scanner.nextToken();
    //cout << nextoken << endl;
    if(!stringIsReal(nextoken)){
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": expected integer in S samples, got <" << nextoken << "> instead.";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    timevec.add(stringToReal(nextoken));
    return true;
}

bool verifyMonocond(string monocond, Vector<int>& initialS, Vector<int>& initialC, int counter, bool& rmcheck, Ui::MainWindow *ui){
    stringstream errorsstr;
    Vector<int> holder; // If the monophyly condition is C, we need to relabel the tree (T_{SC} --> T_{CS})
    // The following tree checks to see if reciprocal monophyly is necessary or if relabeling the tree is necessary.
    if(monocond == "S"){
        rmcheck = false;
    }
    else if(monocond == "C"){
        holder = initialS;
        initialS = initialC;
        initialC = holder;
        rmcheck = false;
    }
    else if(monocond == "SC"){
        rmcheck = true;
    }
    else{
        errorsstr.str(std::string());
        errorsstr << "Error line " << counter + 3 << ": expected <S>, <C>, or <SC>, got <" << monocond << "> instead.";
        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
        return false;
    }
    return true;
}

#endif // VERIFY_H
