#!/usr/bin/python

import sys
import os

if len(sys.argv)>=3:
    sub_filename = sys.argv[1]
    output_filename = sys.argv[2]
else:
    print("usage: ./getlongersub.py sub_file output_sub_filename")
    print("or ")
    sys.exit(1)
################################################################################
def processls(d):
    result_d = {}
    i=0
    for range in d:
        ls = range.split('_')
        L = int(ls[1]) -int(ls[0])
        if i==0:
            ref_L = L
            ref_seq = d[range]
            ref_range = range
            i+=1 
            continue
        if L >= ref_L :
            result_d[range]=d[range]
        elif L < ref_L:
            result_d[ref_range]=ref_seq
            ref_L =L
            ref_seq = d[range]
            ref_range = range
    return result_d 
################################################################################

sub_file = open(sub_filename,'r')
output = open(output_filename,'w')
intact_MS = open(output_filename+"_intact_MS",'w')
TF = 0
sub_dt ={}
for line in sub_file:
    if line[0]=='>':
        ls =line.strip().split('/')
        sub_name = '/'.join(ls[0:-1])+ '/'
        if ls[-1] == "ccs":
            output.write(line)
            TF = 1
        else:
            if not sub_dt.has_key(sub_name):
                sub_dt[sub_name] = {}
            sub_dt[sub_name][ls[-1]] = ""
            TF = 0
        continue
    if TF:
        output.write(line)
    else:
        sub_dt[sub_name][ls[-1]] = sub_dt[sub_name][ls[-1]] + line.strip()
sub_file.close()

for sub_name in sub_dt:
    if len(sub_dt[sub_name])>2:
        intact_MS.write( sub_name[1:] + '\t' + str(len(sub_dt[sub_name])) + '\n')
    if len(sub_dt[sub_name])==2:
        sub_dt[sub_name] = processls(sub_dt[sub_name])
    elif len(sub_dt[sub_name])>2:
        sub_dt[sub_name] = processls(sub_dt[sub_name])
        sub_dt[sub_name] = processls(sub_dt[sub_name])
    for range in sub_dt[sub_name]:
        output.write(sub_name+range+'\n')
        output.write(sub_dt[sub_name][range]+'\n')
output.close()
intact_MS.close()
