#!/usr/bin/python

import sys
import os
from numpy import *
import datetime
result_filename="final_LR_SR_mapping_file"
if len(sys.argv) >= 2:
    LR_SR_mapping_filename_ls = sys.argv[1:]
    if len(sys.argv) >= 3:
        result_filename=sys.argv[-1]
        del LR_SR_mapping_filename_ls[-1]
else:
    print("usage: python merge_mapping_file.py nav_file1 nav_file2 nav_file3 ...")
    print("or ./merge_mapping_file.py nav_file1 nav_file2 nav_file3 ...")
    sys.exit(1)
t0 = datetime.datetime.now()
################################################################################
result_dt={}
for LR_SR_mapping_filename in LR_SR_mapping_filename_ls:
    LR_SR_mapping_file = open(LR_SR_mapping_filename,'r')
    for line in LR_SR_mapping_file:
        ls = line.strip().split('\t')
        if len(ls)>1:
            NLR = ls[0]
            if not result_dt.has_key(NLR):
                result_dt[NLR]=[]
            result_dt[NLR].append(ls[1])
    LR_SR_mapping_file.close()
################################################################################
result_file = open(result_filename, 'w')
for NLR in result_dt:
    result_file.write(NLR+'\t'+';'.join(result_dt[NLR])+'\n')
result_file.close()
print "#####write LR_SR_mapping to file:" + str(datetime.datetime.now()-t0)

