#!/usr/bin/python

import sys
import os

################################################################################

def GetPathAndName(pathfilename):
    ls=pathfilename.split('/')
    filename=ls[-1]
    path='/'.join(ls[0:-1])+'/'
    return path, filename

################################################################################

if len(sys.argv) >= 4:
    genome_list_filename =  sys.argv[1]
    Lgap = int(sys.argv[2])
    N = int(sys.argv[3])
else:
    print("usage: python poolchr.py seq Lgap size")
    print("or ./poolchr.py seq Lgap size")
    sys.exit(1)

################################################################################
i=0
S=""
while i<Lgap:
    S=S+"N"
    i+=1
################################################################################
path, filename = GetPathAndName(genome_list_filename)

chrfile=open(genome_list_filename,'r')
singlechrfile=open(path + "pseudochr_"+ filename,"w")
chr_len_dist=open(path + "dist_"+ filename,"w")

i=0
Nchr=1
chr_name = "Pac" + str(Nchr)
singlechrfile.write(">"+chr_name+"\n")
p=0
temp_p=0
read_name=""
for line in chrfile:

    if line[0]==">":
        if p>N:
            Nchr+=1
            chr_len_dist.write(read_name + "\t" + chr_name + '\t' + str(p)+ '\t' + str(temp_p) + "\n")
            chr_name = "Pac" + str(Nchr)
            singlechrfile.write('\n>'+chr_name+'\n')
            p=0
            temp_p=0
            
        if p!=0:
            chr_len_dist.write(read_name + "\t" + chr_name + '\t' + str(p)+  '\t' + str(temp_p) + "\n")
            temp_p = p
        read_name = line.strip(">").strip()

        singlechrfile.write(S)
        p+=Lgap

        i+=1
    else:
        line=line.strip().upper()

        singlechrfile.write(line)
        p+=len(line)
chr_len_dist.write(read_name + "\t" + chr_name + '\t' + str(p)+  '\t' + str(temp_p) + "\n")
singlechrfile.write("\n")

chrfile.close()
singlechrfile.close()
chr_len_dist.close()
print "finsish genome"

################################################################################

