#!/usr/bin/python
import sys
import datetime
import string
import os

################################################################################
def GetPathAndName(pathfilename):
    ls=pathfilename.split('/')
    filename=ls[-1]
    path='/'.join(ls[0:-1])+'/'
    return path, filename
################################################################################

if len(sys.argv) >= 5:
    LR_SR_mapping_filename = sys.argv[1]
    LR_filename = sys.argv[2]
    SR_filename = sys.argv[3]
    Nthread2 = int(sys.argv[4])
    LR_cps_filename = LR_filename + '.cps'
    SR_cps_filename = SR_filename + '.cps'
    LR_idx_filename = LR_filename + '.idx'
    SR_idx_filename = SR_filename + '.idx'

else:
    print ("usage: ./writetmp.py LR_SR_mapping_file LR.fa SR.fa 12")
    print ("usage: python writetmp.py LR_SR_mapping_file LR.fa SR.fa 12")
    print ("###You need the corresponding compression indexing files (such as LR.fa.cps, LR.fa.idx, SR.fa.cps and SR.fa.idx) of two input files: LR.fa and SR.fa###")

    sys.exit(1)

t0 = datetime.datetime.now()
#########################################################################################################
LR_cps_file = open(LR_cps_filename,'r')
LR_cps_dict={}
for line in LR_cps_file:
    if line[0]=='>':
        readname = line[1:-1]
    else:
        LR_cps_dict[readname] = line.strip()
LR_cps_file.close()

LR_idx_file = open(LR_idx_filename,'r')
LR_idx_dict={}
for line in LR_idx_file:
    readname=line.split('\t')[0]
    LR_idx_dict[readname] = line.strip()
LR_idx_file.close()


SR_cps_file = open(SR_cps_filename,'r')
SR_cps_dict={}
for line in SR_cps_file:
    if line[0]=='>':
        readname = line[1:-1]
    else:
        SR_cps_dict[readname] = line.strip()
SR_cps_file.close()


SR_idx_file = open(SR_idx_filename,'r')
SR_idx_dict={}
for line in SR_idx_file:
    readname=line.split('\t')[0]
    SR_idx_dict[readname] = line.strip()
SR_idx_file.close()

print "finish loading files"
print (datetime.datetime.now()-t0)

#########################################################################################################
#ext_ls = ['aa','ab','ac','ad','ae','af','ag','ah','ai','aj','ak','al','am','an','ao','ap','aq','ar','as','at','au','av','aw','ax','ay','az','ba','bb','bc','bd','be','bf','bg','bh']
ext_ls = ['aa','ab','ac','ad','ae','af','ag','ah','ai','aj','ak','al','am','an','ao','ap']

ext_ls=[]
j=0
k=0
i=0
while i <Nthread2:
    ext_ls.append( string.lowercase[j] + string.lowercase[k] )
    k+=1
    if k==26:
        j+=1
        k=0
    i+=1
    
#########################################################################################################

for ext in ext_ls:
    t0 = datetime.datetime.now()
    LR_SR_mapping_filename_ext = LR_SR_mapping_filename+'.'+ext
    LR_SR_mapping_file = open(LR_SR_mapping_filename_ext,'r')    
    tmp = open(LR_SR_mapping_filename_ext + '_tmp','w')

    for line in LR_SR_mapping_file:
        ls = line.strip().split('\t')
        read_name = '>'+ls[0]
        if len(ls) == 1:
            print read_name
            print "no alignments"
            continue

        NLR = ls[0]
        SR_ls_ls = ls[1].split(';')

        LR_seq = LR_cps_dict[NLR]
        LR_idx_seq = LR_idx_dict[NLR]
        ls_SR_seq = []
        ls_SR_idx_seq= []

        temp_SR_ls_ls = []
        for SR in SR_ls_ls:
            SR_ls = SR.split(',')
            pos = int(SR_ls[1])
            pos -=1
            if pos<0:
               continue
            if SR_ls[0][0]=="-":
                NSR = SR_ls[0][1:]
            else:
                NSR = SR_ls[0]
            temp_SR_ls_ls.append(SR)
            ls_SR_seq.append( SR_cps_dict[NSR] )
            ls_SR_idx_seq.append( SR_idx_dict[NSR] )
       

        input_ls= [LR_seq, LR_idx_seq, ';'.join(temp_SR_ls_ls),read_name,'kinfai'.join(ls_SR_seq), 'kinfai'.join(ls_SR_idx_seq)]
        tmp.write('yue'.join(input_ls)+'\n')

    tmp.close()
    LR_SR_mapping_file.close()
    print (datetime.datetime.now()-t0)







