% lyapexp.m
%   Matlab script file which performs bisections on a given interval to
%   find the lowest upper bound on Lyapunov exponent (within the given
%   tolerance).
% This file works with sdpsol (sdpsol source file: lyapexp)

up_alpha = 2.12;  % known feasible exponent
lo_alpha = 0;     % feasible exponent can not be lower than 0
tol = 1e-4;     % tolerance

tol=tol/2;
pre_alpha = up_alpha;
alpha = (up_alpha+lo_alpha)/2;
while (abs(alpha-pre_alpha)>tol)
  save lyapexp.mat alpha
  !sdpsol -o -m -q lyapexp
  load lyapexp.mat
  if SDPINFO(1,1)==1
    up_alpha = alpha;
    disp('feasible')
  else
    lo_alpha = alpha;
    disp('infeasible')
  end
  pre_alpha = alpha;
  alpha = (up_alpha+lo_alpha)/2;
  disp(sprintf('alpha changed to %d',alpha))
end


