%%% Leverage limit example for:
% Performance Bounds and Suboptimal Policies for Multi-Period Investment
% by Stephen Boyd, Mark T. Mueller, Brendan O'Donoghue, Yang Wang
 
% this script performs the Monte Carlo simulations
% for the Model Predictive Control (MPC) policy

% it saves down all the data to 'MPC_data.mat'

fprintf('*** Running MPC for the leverage limit example. ***\n')
fprintf('This takes about 15 minutes to run 100 samples, depending on your machine.\n')
fprintf('You can run this with a different number of simulations by changing NUM_SIMULATIONS in the script.\n')
fprintf('The results are saved to MPC_data.mat.\n')

clear all;

make_solver % make the cvxgen solver 

cd ../../
data_gen % call data generation file
cd leverage_limit/MPC/

NUM_SIMULATIONS = 5000 % change this to run a different number of simulations
N1 = NUM_SIMULATIONS;

fprintf('\nStarting %i runs\n',N1);

% cvxgen settings:
settings.verbose=0;
params.Sigma = sigma;
params.S = diag(s);
params.kappa = kappa;
params.lambda = lambda;
params.sh = sh;
params.r_bar = r_bar;
params.eta = eta;
randn('seed',1);rand('seed',1);
rho=0.1; % admm step size parameter

costs=zeros(T,N1);Zs_init=zeros(n,T);Vs_init=zeros(n,T);Ys_init=zeros(n,T-1);

tic
for i=1:N1
    fprintf('starting simulation number %i\n',i);
    x=x_init; % initial portfolio
    cs=zeros(T,1); % cost incurred per step stored here
    Zs=Zs_init;Vs=Vs_init;Ys=Ys_init; % warm-start each MPC step
    for t=1:T 
        if t==T
            u=x_term-x;
        else
            while(1)
                Vsold=Vs;Zsold=Zs;Ysold=Ys;
                for tau=t:T % MPC decomposed over time-periods
                    st = tau-t+1;
                    
                    params.rtp1 = rho/2;
                    params.rtm1 = rho/2;
                    params.az = 0;params.av=0;
                    params.x_constraint = zeros(n,1);
                    
                    if tau==t
                        params.az=1;
                        params.av=0;
                        params.x_constraint=x;
                        params.rtm1=0;
                        params.ztm1 = zeros(n,1);
                        params.ztp1 = Zs(:,st+1);
                        params.vtm1 = zeros(n,1);
                        params.yt = Ys(:,st);
                        params.ytm1 = zeros(n,1);
                    elseif tau==T
                        params.az=1;
                        params.av=1;
                        params.x_constraint=x_term;
                        params.rtp1=0;
                        params.ztm1 = Zs(:,st-1);
                        params.ztp1 = zeros(n,1);
                        params.vtm1 = Vs(:,st-1);
                        params.yt = zeros(n,1);
                        params.ytm1 = Ys(:,st-1);
                    else
                        params.ztm1 = Zs(:,st-1);
                        params.ztp1 = Zs(:,st+1);
                        params.vtm1 = Vs(:,st-1);
                        params.yt = Ys(:,st);
                        params.ytm1 = Ys(:,st-1);
                    end
                    % call cvxgen:
                    [vars, status] = csolve(params, settings);
                    Zs(:,st) = vars.z;
                    Vs(:,st) = vars.v;
                    if tau~=t
                        Ys(:,st-1) = Ys(:,st-1)+Zs(:,st)-diag(r_bar)*(Zs(:,st-1)+Vs(:,st-1));
                    end
                end
                enm=(norm(Vs-Vsold,'fro')^2+norm(Zs-Zsold,'fro')^2 + norm(Ys-Ysold,'fro')^2)/(3*(T-t+1)); % difference between one iterate to the next in admm
                if(enm <= 0.001)
                    break; % run admm until convergence
                end
            end
            u=Vs(:,1);
            if (i==1 && t==1)
                Zs_init=Zs;
                Vs_init=Vs;
                Ys_init=Ys;
            end
            Zs=Zs(:,2:end);
            Vs=Vs(:,2:end);
            Ys=Ys(:,2:end);
        end
       
        cs(t) = sum(u) + sh'*pos(-x-u) + kappa'*abs(u) + s'*u.^2 + lambda*(x+u)'*sigma*(x+u);% total cost at time t
        x=diag(exp(rt_Sigma_t*randn(n,1)+mu))*(x+u); % update portfolio
        
    end
    clear Zs Vs Ys Zsold Vsold Ysold
    costs(:,i) = cs;
    save MPC_data.mat;
end
tadmm = toc;
save MPC_data.mat;
