% Performance Bounds and Suboptimal Policies for Multi-Period Investment
% by Stephen Boyd, Mark T. Mueller, Brendan O'Donoghue, Yang Wang

% plot generation script

% loads the data from 'MC_data.mat' to generate
% plots in the paper

load MC_data

%%% GENERATE TRACES:

K=5; % number of sample traces to include in figs

grey=[0.7;0.7;0.7];
%scrsz = get(0,'ScreenSize');
%figure('Position',[1 scrsz(4)/2 scrsz(3)/2 scrsz(4)])
figure('Position',[1 440 600 880])
subplot(3,2,1);
hold on
plot(long_pos(:,1:K),'color',grey);
plot(mean(long_pos,2));
plot(short_pos(:,1:K),'color',grey);
plot(mean(short_pos,2),'r');
title('long-short-pos')
xlabel('t')
ylabel('y')

leverage = short_pos./pos_val;

subplot(3,2,2);
%axis([0 T 0.22 0.32])
hold on
plot(leverage(:,1:K),'color',grey);
plot(median(leverage,2));
title('leverage')
xlabel('t')
ylabel('y')

subplot(3,2,3);
hold on
plot(su(:,1:K),'color',grey);
plot(mean(su,2));
title('sum(u)')
xlabel('t')
ylabel('y')

subplot(3,2,4);
hold on
plot(cumsum(costs(:,1:K)),'color',grey);
plot(mean(cumsum(costs),2))
plot(0:T,lb*ones(1+T,1),'r--')
title('cumsum-stage-cost')
xlabel('t')
ylabel('y')


subplot(3,2,5);
hold on
plot(short(:,1:K)+quad(:,1:K)+abs_c(:,1:K),'color',grey);
plot(mean(short+quad+abs_c,2))
title('trans-costs')
xlabel('t')
ylabel('y')


subplot(3,2,6);
hold on
plot(risk(:,1:K),'color',grey);
plot(mean(risk,2))
title('risk')
xlabel('t')
ylabel('y')

set(gcf,'PaperPositionMode','auto')
print -depsc './traces.eps'

%%% GENERATE HISTOGRAM:

figure('Position',[1 440 800 300])
hist(sum(costs),40);hold on
fig_axes=axis;
close;
figure('Position',[1 440 800 300])
plot(lb*ones(fig_axes(4),1), 1:fig_axes(4),'r','linewidth',3);hold on;
plot(mean(sum(costs))*ones(fig_axes(4),1), 1:fig_axes(4),'g','linewidth',3)
legend('lower-bound','ADP-performance')
hist(sum(costs),40);hold on
plot(lb*ones(fig_axes(4),1), 1:fig_axes(4),'r','linewidth',3);hold on;
plot(mean(sum(costs))*ones(fig_axes(4),1), 1:fig_axes(4),'g','linewidth',3)
title('cost-hist')
xlabel('cost')
ylabel('count')
h = findobj(gca,'Type','patch');
set(h,'FaceColor',grey,'EdgeColor','k')

set(gcf,'PaperPositionMode','auto')
print -depsc './hist.eps'

