%%% Quadratic example for:
% Performance Bounds and Suboptimal Policies for Multi-Period Investment 
% by Stephen Boyd, Mark T. Mueller, Brendan O'Donoghue, Yang Wang

% this script performs value iteration to
% obtain the sequence of value functions and
% the optimal expected cost

% it saves down all the data to 'data.mat'
% which will be loaded when we run the MC simulations

% run this BEFORE running quadratic_MC.m

fprintf('*** Performing the Bellman recursion for the quadratic example. ***\n')
fprintf('The results are saved to data.mat.\n')
fprintf('After this has completed you can run the Monte Carlo simulations by typing:\n run_montecarlo.\n')


cd ../../
data_gen % call data generation file
cd quadratic/ADP/

L=lambda*sigma;
Q=lambda*sigma;
S=diag(s)+lambda*sigma;

% value iteration
% value fuctions:
P=zeros(n,n,T);p=zeros(n,T);q=zeros(T,1);
P(:,:,T)=S+Q-2*L;p(:,T)=-ones/2;q(T)=0;
% optimal trading policy: u_t = phi_t(x) = J_t x + k_t
J=zeros(n,n,T-1);k=zeros(n,T-1);
for i=T:-1:2
    M_inv = pinv(S+P(:,:,i).*M);
    mat = [Q + P(:,:,i).*M p(:,i).*r_bar;(p(:,i).*r_bar)' q(i)]-...
        [L+P(:,:,i).*M;((0.5)*ones(n,1)+p(:,i).*r_bar)']*M_inv*...
        [L+P(:,:,i).*M;((0.5)*ones(n,1)+p(:,i).*r_bar)']';
    P(:,:,i-1)=mat(1:n,1:n);p(:,i-1)=mat(1:n,end);q(i-1)=mat(end,end);
    J(:,:,i-1)=-M_inv*(L+P(:,:,i).*M);
    k(:,i-1)=-M_inv*(0.5*ones(n,1)+p(:,i).*r_bar);
end

% optimal cost
opt_cost = q(1)
lb = opt_cost; % (just for naming consistency with other examples)
clearvars -except P p q J k N1 T kappa lambda lb opt_cost mu n r_bar rt_Sigma_t sigma sigma_tilde s sh x_init x_term M
save data;
