% Performance Bounds and Suboptimal Policies for Multi-Period Investment 
% by Stephen Boyd, Mark T. Mueller, Brendan O'Donoghue, Yang Wang

% loads the data from 'data.mat' and performs
% the Monte Carlo simulation

% requires cvxgen: if solver not installed run 'make_solver'
% in MATLAB before running this script

% run this AFTER solving SDP

% saves results to 'MC_data.mat'

fprintf('*** Starting Monte Carlo simulations. ***\n')
fprintf('This can take up to an hour or more, depending on your machine.\n')
fprintf('You can run this with a different number of simulations by changing NUM_SIMULATIONS in the script.\n')
fprintf('The results are saved to MC_data.mat.\n')
fprintf('After this has completed you can generate the plot by typing:\n gen_plots\n')

clear all
load data
NUM_SIMULATIONS = N1 % change this to run different num of simuations
N1=NUM_SIMULATIONS;

fprintf('\nStarting %i runs\n',N1);

save_on=1; % set to 1 to save to MC_data.mat

randn('seed',1);rand('seed',1);

costs=zeros(T,N1);ts=0;
%%%%%%%%
su=costs;cash=costs;risk=costs;tot=costs;
short=costs;quad=costs;abs_c=costs;short_pos=costs;
long_pos=costs;tot_pos=costs;pos_val=costs;
%%%%%%%%
for i=1:N1
    if mod(i,1000)==0
        i
        if save_on
            save MC_data.mat;
        end
    end
    cs=zeros(T,1);
    %%%%%%%%
    su_t=cs;cash_t=cs;risk_t=cs;tot_t=cs;
    short_t=cs;quad_t=cs;abs_c_t=cs;short_pos_t=cs;
    long_pos_t=cs;tot_pos_t=cs;pos_val_t=cs;
    %%%%%%%%
    
    x=x_init;
    
    for t=1:T
        if (t==T)
            u=x_term-x;% terminal portfolio condition
        else
            % apply optimal controller
            tic;
            u=J(:,:,t)*x+k(:,t);
            ts=ts+toc;
        end
        %%%%%%
        su_t(t)=sum(u); % gross difference between asset sales and purchases
        cash_t(t)=sum(u) + sh'*pos(-x-u)+ kappa'*abs(u) + s'*u.^2; % gross cash
        short_t(t)=sh'*pos(-x-u); % shorting cost
        quad_t(t)=s'*u.^2; % quadratic transaction cost
        abs_c_t(t)=kappa'*abs(u); % absolute value transaction cost
        risk_t(t)=lambda*(x+u)'*sigma*(x+u); % risk penalty fee
        tot_t(t)=sum(u) + sh'*pos(-x-u)+ kappa'*abs(u) + s'*u.^2 + lambda*(x+u)'*sigma*(x+u); % net cash
        short_pos_t(t)=sum(pos(-x-u)); % short position
        long_pos_t(t)=sum(pos(x+u)); % long position
        tot_pos_t(t)=norm(x+u,1); % total position
        pos_val_t(t)=sum(x+u); % net value of portfolio
        %%%%%%
        cs(t) = sum(u) + s'*u.^2 + lambda*(x+u)'*sigma*(x+u);% total cost at time t
        %progpagate portfolio forward in time
        x=diag(exp(rt_Sigma_t*randn(n,1)+mu))*(x+u);
    end
    costs(:,i) = cs;
    %%%%%%%
    su(:,i)=su_t;cash(:,i)=cash_t;risk(:,i)=risk_t;tot(:,i)=tot_t;
    short(:,i)=short_t;quad(:,i)=quad_t;abs_c(:,i)=abs_c_t;short_pos(:,i)=short_pos_t;
    long_pos(:,i)=long_pos_t;tot_pos(:,i)=tot_pos_t;pos_val(:,i)=pos_val_t;
    %%%%%%%
end
if save_on
    save_on=0
    save MC_data.mat;
end

